/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.states.core;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jeasy.states.api.Event;
import org.jeasy.states.api.FiniteStateMachine;
import org.jeasy.states.api.FiniteStateMachineException;
import org.jeasy.states.api.State;
import org.jeasy.states.api.Transition;

final class FiniteStateMachineImpl
implements FiniteStateMachine {
    private static final Logger LOGGER = Logger.getLogger(FiniteStateMachineImpl.class.getSimpleName());
    private State currentState;
    private State initialState;
    private Set<State> finalStates;
    private Set<State> states;
    private Set<Transition> transitions;
    private Event lastEvent;
    private Transition lastTransition;

    FiniteStateMachineImpl(Set<State> states, State initialState) {
        this.states = states;
        this.initialState = initialState;
        this.currentState = initialState;
        this.transitions = new HashSet<Transition>();
        this.finalStates = new HashSet<State>();
    }

    @Override
    public final synchronized State fire(Event event) throws FiniteStateMachineException {
        if (!this.finalStates.isEmpty() && this.finalStates.contains(this.currentState)) {
            LOGGER.log(Level.WARNING, "FSM is in final state '" + this.currentState.getName() + "', event " + event + " is ignored.");
            return this.currentState;
        }
        if (event == null) {
            LOGGER.log(Level.WARNING, "Null event fired, FSM state unchanged");
            return this.currentState;
        }
        for (Transition transition : this.transitions) {
            if (!this.currentState.equals(transition.getSourceState()) || !transition.getEventType().equals(event.getClass()) || !this.states.contains(transition.getTargetState())) continue;
            try {
                if (transition.getEventHandler() != null) {
                    transition.getEventHandler().handleEvent(event);
                }
                this.currentState = transition.getTargetState();
                this.lastEvent = event;
                this.lastTransition = transition;
                break;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "An exception occurred during handling event " + event + " of transition " + transition, e);
                throw new FiniteStateMachineException(transition, event, e);
            }
        }
        return this.currentState;
    }

    void registerTransition(Transition transition) {
        this.transitions.add(transition);
    }

    void registerFinalState(State finalState) {
        this.finalStates.add(finalState);
    }

    @Override
    public State getCurrentState() {
        return this.currentState;
    }

    @Override
    public State getInitialState() {
        return this.initialState;
    }

    @Override
    public Set<State> getFinalStates() {
        return this.finalStates;
    }

    @Override
    public Set<State> getStates() {
        return this.states;
    }

    @Override
    public Set<Transition> getTransitions() {
        return this.transitions;
    }

    @Override
    public Event getLastEvent() {
        return this.lastEvent;
    }

    @Override
    public Transition getLastTransition() {
        return this.lastTransition;
    }
}

