/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.states.core;

import java.util.Set;
import org.jeasy.states.api.FiniteStateMachine;
import org.jeasy.states.api.State;
import org.jeasy.states.util.Utils;

class FiniteStateMachineDefinitionValidator {
    FiniteStateMachineDefinitionValidator() {
    }

    void validateFiniteStateMachineDefinition(FiniteStateMachine finiteStateMachine) {
        State initialState;
        Set<State> states = finiteStateMachine.getStates();
        if (!states.contains(initialState = finiteStateMachine.getInitialState())) {
            throw new IllegalStateException("Initial state '" + initialState.getName() + "' must belong to FSM states: " + Utils.dumpFSMStates(states));
        }
        for (State finalState : finiteStateMachine.getFinalStates()) {
            if (states.contains(finalState)) continue;
            throw new IllegalStateException("Final state '" + finalState.getName() + "' must belong to FSM states: " + Utils.dumpFSMStates(states));
        }
    }
}

