package org.jeecf.osgi.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jeecf.common.mapper.JsonMapper;

/**
 * 语言枚举
 * 
 * @author jianyiming
 *
 */
public enum LanguageEnum {
    /**
     * java
     */
    JAVA(1, "java"),
    /**
     * go
     */
    GO(2, "go"),
    /**
     * python
     */
    PYTHON(3, "python"),
    /**
     * js
     */
    JS(4, "js"),
    /**
     * css
     */
    CSS(5, "css"),
    /**
     * css
     */
    HTML(6, "html"),
    /**
     * css
     */
    WEB(7, "web"),
    /**
     * python
     */
    PHP(8, "php"),
    /**
     * c
     */
    C(9, "c"),;

    private final int code;
    private final String name;

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    private LanguageEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Integer getCode(String name) {
        for (LanguageEnum e : LanguageEnum.values()) {
            if (e.getName().equals(name)) {
                return e.getCode();
            }
        }
        return null;
    }

    public static String getName(int code) {
        for (LanguageEnum e : LanguageEnum.values()) {
            if (e.getCode() == code) {
                return e.getName();
            }
        }
        return null;
    }

    public static String toJsonString() {
        List<Map<String, Object>> dataMap = new ArrayList<>();
        for (LanguageEnum e : LanguageEnum.values()) {
            Map<String, Object> map = new HashMap<String, Object>(10);
            map.put("code", e.getCode());
            map.put("name", e.getName());
            dataMap.add(map);
        }
        return JsonMapper.toJson(dataMap);
    }

}
