/*
 * Decompiled with CFR 0.152.
 */
package org.jeecf.osgi.boundle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jeecf.osgi.boundle.LifeCycle;
import org.jeecf.osgi.model.BoundleContext;
import org.jeecf.osgi.plugin.Plugin;

public abstract class BaseBoundle
implements LifeCycle {
    Map<String, Class<?>> classesMap = null;
    Map<String, Plugin> instancesMap = null;

    @Override
    public void install(ClassLoader loader, String[] packageNames) throws ClassNotFoundException {
        if (this.classesMap == null) {
            this.classesMap = new HashMap(12);
        }
        for (String packageName : packageNames) {
            Class<?> classes = loader.loadClass(packageName);
            if (!this.getClasses().isAssignableFrom(classes)) continue;
            this.classesMap.put(packageName, classes);
        }
    }

    @Override
    public void init(BoundleContext context) throws InstantiationException, IllegalAccessException {
        if (this.instancesMap == null) {
            this.instancesMap = new HashMap<String, Plugin>(12);
        }
        for (Map.Entry<String, Class<?>> entry : this.classesMap.entrySet()) {
            Plugin plugin = (Plugin)entry.getValue().newInstance();
            plugin.init(context);
            this.instancesMap.put(entry.getKey(), plugin);
        }
    }

    @Override
    public void init(String[] packageNames, BoundleContext context) throws InstantiationException, IllegalAccessException {
        if (this.instancesMap == null) {
            this.instancesMap = new HashMap<String, Plugin>(12);
        }
        for (String packageName : packageNames) {
            Class<?> classes = this.classesMap.get(packageName);
            if (classes == null) continue;
            Plugin plugin = (Plugin)classes.newInstance();
            plugin.init(context);
            this.instancesMap.put(packageName, plugin);
        }
    }

    @Override
    public Plugin getInstance(String packageName) {
        return this.instancesMap.get(packageName);
    }

    @Override
    public List<Plugin> getInstances() {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        for (Map.Entry<String, Plugin> entry : this.instancesMap.entrySet()) {
            result.add(entry.getValue());
        }
        Collections.sort(result, new Comparator<Plugin>(){

            @Override
            public int compare(Plugin plugin1, Plugin plugin2) {
                return plugin1.getOrder() - plugin2.getOrder();
            }
        });
        return result;
    }

    @Override
    public void uninstall() {
        this.classesMap = null;
        this.instancesMap = null;
    }

    @Override
    public List<Plugin> uninstall(String[] packageNames) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (String packageName : packageNames) {
            plugins.add(this.instancesMap.get(packageName));
            this.classesMap.remove(packageName);
            this.instancesMap.remove(packageName);
        }
        return plugins;
    }

    public abstract Class<?> getClasses();
}

