/*
 * Decompiled with CFR 0.152.
 */
package org.jeecf.osgi.boundle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jeecf.osgi.model.BoundleContext;
import org.jeecf.osgi.plugin.Plugin;

public interface LifeCycle {
    public void install(ClassLoader var1, String[] var2) throws ClassNotFoundException;

    public void init(BoundleContext var1) throws InstantiationException, IllegalAccessException;

    public void init(String[] var1, BoundleContext var2) throws InstantiationException, IllegalAccessException;

    public Plugin getInstance(String var1);

    default public List<Plugin> getInstances(String[] packageNames) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (String packageName : packageNames) {
            Plugin plugin = this.getInstance(packageName);
            if (plugin == null) continue;
            plugins.add(plugin);
        }
        Collections.sort(plugins, new Comparator<Plugin>(){

            @Override
            public int compare(Plugin plugin1, Plugin plugin2) {
                return plugin1.getOrder() - plugin2.getOrder();
            }
        });
        return plugins;
    }

    public List<Plugin> getInstances();

    public void uninstall();

    public List<Plugin> uninstall(String[] var1);
}

