/*
 * Decompiled with CFR 0.152.
 */
package org.jeecf.osgi.enums;

import java.util.ArrayList;
import java.util.HashMap;
import org.jeecf.common.mapper.JsonMapper;

public enum LanguageEnum {
    JAVA(1, "java"),
    GO(2, "go"),
    PYTHON(3, "python"),
    JS(4, "js"),
    CSS(5, "css"),
    HTML(6, "html"),
    WEB(7, "web"),
    PHP(8, "php"),
    C(9, "c");

    private final int code;
    private final String name;

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    private LanguageEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Integer getCode(String name) {
        for (LanguageEnum e : LanguageEnum.values()) {
            if (!e.getName().equals(name)) continue;
            return e.getCode();
        }
        return null;
    }

    public static String getName(int code) {
        for (LanguageEnum e : LanguageEnum.values()) {
            if (e.getCode() != code) continue;
            return e.getName();
        }
        return null;
    }

    public static String toJsonString() {
        ArrayList dataMap = new ArrayList();
        for (LanguageEnum e : LanguageEnum.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            map.put("code", e.getCode());
            map.put("name", e.getName());
            dataMap.add(map);
        }
        return JsonMapper.toJson(dataMap);
    }
}

