/*
 * Decompiled with CFR 0.152.
 */
package org.jeecf.osgi.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.collections4.CollectionUtils;

public class JarUtils {
    private static final String CLASS_SUFFIX = ".class";

    public static void delete(URL url) {
        File file = new File(url.getPath());
        file.deleteOnExit();
    }

    public static void delete(URL[] urls) {
        for (URL url : urls) {
            File file = new File(url.getPath());
            file.deleteOnExit();
        }
    }

    public static List<String> getClassNames(URL url) throws IOException {
        ArrayList<String> packageNames = new ArrayList<String>();
        JarFile jarFile = new JarFile(url.getFile());
        List<String> tempPackageNames = JarUtils.getClassNames(jarFile, true);
        if (CollectionUtils.isNotEmpty(tempPackageNames)) {
            tempPackageNames.forEach(packageName -> packageNames.add((String)packageName));
        }
        return packageNames;
    }

    public static List<String> getClassNames(URL[] urls) throws IOException {
        ArrayList<String> packageNames = new ArrayList<String>();
        for (URL url : urls) {
            JarFile jarFile = new JarFile(url.getFile());
            List<String> tempPackageNames = JarUtils.getClassNames(jarFile, true);
            if (!CollectionUtils.isNotEmpty(tempPackageNames)) continue;
            tempPackageNames.forEach(packageName -> packageNames.add((String)packageName));
        }
        return packageNames;
    }

    public static List<String> getClassNames(JarFile jarFile, boolean flag) {
        return JarUtils.getClassNames(jarFile, null, flag);
    }

    public static List<String> getClassNames(JarFile jarFile, String packageName, boolean flag) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            if (!name.endsWith(CLASS_SUFFIX)) continue;
            name = name.replace(CLASS_SUFFIX, "").replace("/", ".");
            if (flag) {
                if (packageName != null && !name.startsWith(packageName) || -1 != name.indexOf("$")) continue;
                result.add(name);
                continue;
            }
            if (packageName != null && !packageName.equals(name.substring(0, name.lastIndexOf("."))) || -1 != name.indexOf("$")) continue;
            result.add(name);
        }
        return result;
    }
}

