/*
 * Decompiled with CFR 0.152.
 */
package org.jeecf.osgi.utils;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.jeecf.osgi.boundle.BaseBoundle;
import org.jeecf.osgi.boundle.GenHandlerBoundle;
import org.jeecf.osgi.enums.BoundleEnum;
import org.jeecf.osgi.model.BoundleContext;
import org.jeecf.osgi.plugin.Plugin;
import org.jeecf.osgi.utils.JarUtils;

public class PluginManager {
    private Map<String, BoundleContext> boundleContextMap = new HashMap<String, BoundleContext>(12);
    private Map<String, List<String>> urlMap = new HashMap<String, List<String>>(12);

    public PluginManager() {
        this.boundleContextMap.put(BoundleEnum.GEN_HANDLER_PLUGIN_BOUNDLE.getName(), new BoundleContext(new GenHandlerBoundle()));
    }

    public void install(URL[] urls, BoundleEnum boundleEnum, boolean isInit) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.install(urls, boundleEnum, isInit, null);
    }

    public void install(URL[] urls, BoundleEnum boundleEnum, boolean isInit, ClassLoader loadder) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (urls == null || urls.length == 0) {
            return;
        }
        URLClassLoader pluginClassLoader = null;
        pluginClassLoader = loadder != null ? new URLClassLoader(urls, loadder) : new URLClassLoader(urls);
        BoundleContext context = this.boundleContextMap.get(boundleEnum.getName());
        context.setUrls(urls);
        BaseBoundle boundle = context.getBoundle();
        for (URL url : urls) {
            List<String> packageNameList = JarUtils.getClassNames(url);
            String[] packageNames = packageNameList.toArray(new String[packageNameList.size()]);
            boundle.install(pluginClassLoader, packageNames);
            this.urlMap.put(url.getPath(), packageNameList);
            if (!isInit) continue;
            boundle.init(packageNames, context);
        }
    }

    public BoundleContext getContext(BoundleEnum boundleEnum) {
        return this.boundleContextMap.get(boundleEnum.getName());
    }

    public List<Plugin> getInstances(BoundleEnum boundleEnum) {
        BoundleContext context = this.boundleContextMap.get(boundleEnum.getName());
        if (CollectionUtils.isEmpty(context.getPlugins())) {
            context.setPlugins(context.getBoundle().getInstances());
        }
        return context.getPlugins();
    }

    public List<Plugin> getInstances(BoundleEnum boundleEnum, URL[] urls) {
        BoundleContext context = this.boundleContextMap.get(boundleEnum.getName());
        BaseBoundle boundle = context.getBoundle();
        ArrayList<String> allPackageNames = new ArrayList<String>();
        for (URL url : urls) {
            List<String> packageNames = this.urlMap.get(url.getPath());
            if (!CollectionUtils.isNotEmpty(packageNames)) continue;
            allPackageNames.addAll(packageNames);
        }
        return boundle.getInstances(allPackageNames.toArray(new String[allPackageNames.size()]));
    }

    public BaseBoundle getBoundle(BoundleEnum boundleEnum) {
        return this.boundleContextMap.get(boundleEnum.getName()).getBoundle();
    }

    public void uninstall(BoundleEnum boundleEnum) {
        this.boundleContextMap.get(boundleEnum.getName()).getBoundle().uninstall();
        this.boundleContextMap.remove(boundleEnum.getName());
    }

    public void uninstall(BoundleEnum boundleEnum, URL url) throws IOException {
        BoundleContext context = this.boundleContextMap.get(boundleEnum.getName());
        List<Plugin> plugins = context.getPlugins();
        List<String> packageNames = this.urlMap.get(url.getPath());
        if (CollectionUtils.isNotEmpty(packageNames)) {
            List<Plugin> uninstallPlugins = context.getBoundle().uninstall(packageNames.toArray(new String[packageNames.size()]));
            if (CollectionUtils.isNotEmpty(plugins)) {
                uninstallPlugins.forEach(uninstallPlugin -> {
                    for (Plugin plugin : plugins) {
                        if (plugin != uninstallPlugin) continue;
                        plugins.remove(plugin);
                        break;
                    }
                });
            }
            uninstallPlugins = null;
        }
        this.urlMap.remove(url.getPath());
    }
}

