/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.export.template;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.poi.cache.ExcelCache;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.entity.TemplateExportParams;
import org.jeecgframework.poi.excel.entity.enmus.ExcelType;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.excel.entity.params.ExcelTemplateParams;
import org.jeecgframework.poi.excel.export.base.ExcelExportBase;
import org.jeecgframework.poi.excel.export.styler.IExcelExportStyler;
import org.jeecgframework.poi.exception.excel.ExcelExportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelExportEnum;
import org.jeecgframework.poi.util.PoiElUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.jeecgframework.poi.util.PoiSheetUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelExportOfTemplateUtil
extends ExcelExportBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportOfTemplateUtil.class);
    private Set<String> tempCreateCellSet = new HashSet<String>();
    private TemplateExportParams teplateParams;

    private void addDataToSheet(Class<?> pojoClass, Collection<?> dataSet, Sheet sheet, Workbook workbook) throws Exception {
        int index;
        if (workbook instanceof XSSFWorkbook) {
            this.type = ExcelType.XSSF;
        }
        Map<String, Integer> titlemap = this.getTitleMap(sheet);
        Drawing patriarch = sheet.createDrawingPatriarch();
        Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
        ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
        String targetId = null;
        if (etarget != null) {
            targetId = etarget.value();
        }
        ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
        this.getAllExcelField(null, targetId, fileds, excelParams, pojoClass, null);
        this.sortAndFilterExportField(excelParams, titlemap);
        short rowHeight = this.getRowHeight(excelParams);
        int titleHeight = index = this.teplateParams.getHeadingRows() + this.teplateParams.getHeadingStartRow();
        sheet.shiftRows(this.teplateParams.getHeadingRows() + this.teplateParams.getHeadingStartRow(), sheet.getLastRowNum(), this.getShiftRows(dataSet, excelParams), true, true);
        if (excelParams.size() == 0) {
            return;
        }
        for (Object t : dataSet) {
            index += this.createCells(patriarch, index, t, excelParams, sheet, workbook, rowHeight);
        }
        this.mergeCells(sheet, excelParams, titleHeight);
    }

    private int getShiftRows(Collection<?> dataSet, List<ExcelExportEntity> excelParams) throws Exception {
        int size = 0;
        for (Object t : dataSet) {
            size += this.getOneObjectSize(t, excelParams);
        }
        return size;
    }

    public int getOneObjectSize(Object t, List<ExcelExportEntity> excelParams) throws Exception {
        int maxHeight = 1;
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            Collection list;
            ExcelExportEntity entity = excelParams.get(k);
            if (entity.getList() == null || (list = (Collection)entity.getMethod().invoke(t, new Object[0])) == null || list.size() <= maxHeight) continue;
            maxHeight = list.size();
        }
        return maxHeight;
    }

    public Workbook createExcleByTemplate(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        if (params == null || map == null || StringUtils.isEmpty((CharSequence)params.getTemplateUrl())) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        Workbook wb = null;
        try {
            int le;
            this.teplateParams = params;
            wb = this.getCloneWorkBook();
            this.setExcelExportStyler((IExcelExportStyler)this.teplateParams.getStyle().getConstructor(Workbook.class).newInstance(wb));
            int n = le = params.isScanAllsheet() ? wb.getNumberOfSheets() : params.getSheetNum().length;
            for (int i = 0; i < le; ++i) {
                if (params.getSheetName() != null && params.getSheetName().length > i && StringUtils.isNotEmpty((CharSequence)params.getSheetName()[i])) {
                    wb.setSheetName(i, params.getSheetName()[i]);
                }
                this.parseTemplate(wb.getSheetAt(i), map);
            }
            if (dataSet != null) {
                this.dataHanlder = params.getDataHanlder();
                if (this.dataHanlder != null) {
                    this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
                }
                this.addDataToSheet(pojoClass, dataSet, wb.getSheetAt(params.getDataSheetNum()), wb);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return wb;
    }

    private Workbook getCloneWorkBook() throws Exception {
        return ExcelCache.getWorkbook(this.teplateParams.getTemplateUrl(), this.teplateParams.getSheetNum(), this.teplateParams.isScanAllsheet());
    }

    private Map<String, Integer> getTitleMap(Sheet sheet) {
        Row row = null;
        HashMap<String, Integer> titlemap = new HashMap<String, Integer>();
        for (int j = 0; j < this.teplateParams.getHeadingRows(); ++j) {
            row = sheet.getRow(j + this.teplateParams.getHeadingStartRow());
            Iterator cellTitle = row.cellIterator();
            int i = row.getFirstCellNum();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = cell.getStringCellValue();
                if (!StringUtils.isEmpty((CharSequence)value)) {
                    titlemap.put(value, i);
                }
                ++i;
            }
        }
        return titlemap;
    }

    private void parseTemplate(Sheet sheet, Map<String, Object> map) throws Exception {
        this.deleteCell(sheet, map);
        Row row = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                if (row.getCell(i) == null || this.tempCreateCellSet.contains(row.getRowNum() + "_" + row.getCell(i).getColumnIndex())) continue;
                this.setValueForCellByMap(row.getCell(i), map);
            }
        }
    }

    private void deleteCell(Sheet sheet, Map<String, Object> map) throws Exception {
        Row row = null;
        Cell cell = null;
        int index = 0;
        while (index <= sheet.getLastRowNum()) {
            if ((row = sheet.getRow(index++)) == null) continue;
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                cell = row.getCell(i);
                if (row.getCell(i) == null || cell.getCellType() != 1 && cell.getCellType() != 0) continue;
                cell.setCellType(1);
                String text = cell.getStringCellValue();
                if (!text.contains("!if:")) continue;
                if (Boolean.valueOf(PoiElUtil.eval(text.substring(text.indexOf("{{") + 2, text.indexOf("}}")).trim(), map).toString()).booleanValue()) {
                    PoiSheetUtility.deleteColumn(sheet, i);
                }
                cell.setCellValue("");
            }
        }
    }

    private void setValueForCellByMap(Cell cell, Map<String, Object> map) throws Exception {
        int cellType = cell.getCellType();
        if (cellType != 1 && cellType != 0) {
            return;
        }
        cell.setCellType(1);
        String oldString = cell.getStringCellValue();
        if (oldString != null && oldString.indexOf("{{") != -1 && !oldString.contains("fe:")) {
            String params = null;
            boolean isNumber = false;
            if (this.isNumber(oldString)) {
                isNumber = true;
                oldString = oldString.replace("n:", "");
            }
            while (oldString.indexOf("{{") != -1) {
                params = oldString.substring(oldString.indexOf("{{") + 2, oldString.indexOf("}}"));
                oldString = oldString.replace("{{" + params + "}}", PoiElUtil.eval(params, map).toString());
            }
            if (isNumber && StringUtils.isNotBlank((CharSequence)oldString)) {
                cell.setCellValue(Double.parseDouble(oldString));
                cell.setCellType(0);
            } else {
                cell.setCellValue(oldString);
            }
        }
        if (oldString != null && oldString.contains("fe:")) {
            this.addListDataToExcel(cell, map, oldString.trim());
        }
    }

    private boolean isNumber(String text) {
        return text.startsWith("n:") || text.contains("{n:") || text.contains(" n:");
    }

    private void addListDataToExcel(Cell cell, Map<String, Object> map, String name) throws Exception {
        Object t;
        boolean isCreate = !name.contains("!fe:");
        boolean isShift = name.contains("$fe:");
        name = name.replace("!fe:", "").replace("$fe:", "").replace("fe:", "").replace("{{", "");
        String[] keys = name.replaceAll("\\s{1,}", " ").trim().split(" ");
        Collection datas = (Collection)PoiPublicUtil.getParamsValue(keys[0], map);
        List<ExcelTemplateParams> columns = this.getAllDataColumns(cell, name.replace(keys[0], ""));
        if (datas == null) {
            return;
        }
        Iterator its = datas.iterator();
        int rowIndex = cell.getRow().getRowNum() + 1;
        if (its.hasNext()) {
            t = its.next();
            cell.getRow().setHeight(columns.get(0).getHeight());
            this.setForEeachCellValue(isCreate, cell.getRow(), cell.getColumnIndex(), t, columns, map);
        }
        if (isShift) {
            cell.getRow().getSheet().shiftRows(cell.getRowIndex() + 1, cell.getRow().getSheet().getLastRowNum(), datas.size() - 1, true, true);
        }
        while (its.hasNext()) {
            Row row;
            t = its.next();
            if (isCreate) {
                row = cell.getRow().getSheet().createRow(rowIndex++);
            } else {
                row = cell.getRow().getSheet().getRow(rowIndex++);
                if (row == null) {
                    row = cell.getRow().getSheet().createRow(rowIndex - 1);
                }
            }
            row.setHeight(columns.get(0).getHeight());
            this.setForEeachCellValue(isCreate, row, cell.getColumnIndex(), t, columns, map);
        }
    }

    private void setForEeachCellValue(boolean isCreate, Row row, int columnIndex, Object t, List<ExcelTemplateParams> columns, Map<String, Object> map) throws Exception {
        int i;
        int max = columnIndex + columns.size();
        for (i = 0; i < max; ++i) {
            if (row.getCell(i) != null) continue;
            row.createCell(i);
        }
        max = columns.size();
        for (i = 0; i < max; ++i) {
            boolean isNumber = false;
            String tempStr = new String(columns.get(i).getName());
            if (this.isNumber(tempStr)) {
                isNumber = true;
                tempStr = tempStr.replace("n:", "");
            }
            map.put(this.teplateParams.getTempParams(), t);
            String val = PoiElUtil.eval(tempStr, map).toString();
            if (isNumber && StringUtils.isNotEmpty((CharSequence)val)) {
                row.getCell(i + columnIndex).setCellValue(Double.parseDouble(val));
                row.getCell(i + columnIndex).setCellType(0);
            } else {
                row.getCell(i + columnIndex).setCellValue(val);
            }
            row.getCell(i + columnIndex).setCellStyle(columns.get(i).getCellStyle());
            this.tempCreateCellSet.add(row.getRowNum() + "_" + (i + columnIndex));
        }
    }

    private List<ExcelTemplateParams> getAllDataColumns(Cell cell, String name) {
        Cell tempCell;
        ArrayList<ExcelTemplateParams> columns = new ArrayList<ExcelTemplateParams>();
        cell.setCellValue("");
        if (name.contains("}}")) {
            columns.add(new ExcelTemplateParams(name.replace("}}", "").trim(), cell.getCellStyle(), cell.getRow().getHeight()));
            return columns;
        }
        columns.add(new ExcelTemplateParams(name.trim(), cell.getCellStyle(), cell.getRow().getHeight()));
        int index = cell.getColumnIndex();
        while ((tempCell = cell.getRow().getCell(++index)) != null) {
            String cellStringString;
            try {
                cellStringString = tempCell.getStringCellValue();
                if (StringUtils.isBlank((CharSequence)cellStringString)) {
                    break;
                }
            }
            catch (Exception e) {
                throw new ExcelExportException("for each \u5f53\u4e2d\u5b58\u5728\u7a7a\u5b57\u7b26\u4e32,\u8bf7\u68c0\u67e5\u6a21\u677f");
            }
            tempCell.setCellValue("");
            if (cellStringString.contains("}}")) {
                columns.add(new ExcelTemplateParams(cellStringString.trim().replace("}}", ""), tempCell.getCellStyle(), tempCell.getRow().getHeight()));
                break;
            }
            if (!cellStringString.trim().contains(this.teplateParams.getTempParams())) break;
            columns.add(new ExcelTemplateParams(cellStringString.trim(), tempCell.getCellStyle(), tempCell.getRow().getHeight()));
        }
        return columns;
    }

    private void sortAndFilterExportField(List<ExcelExportEntity> excelParams, Map<String, Integer> titlemap) {
        for (int i = excelParams.size() - 1; i >= 0; --i) {
            if (excelParams.get(i).getList() != null && excelParams.get(i).getList().size() > 0) {
                this.sortAndFilterExportField(excelParams.get(i).getList(), titlemap);
                if (excelParams.get(i).getList().size() == 0) {
                    excelParams.remove(i);
                    continue;
                }
                excelParams.get(i).setOrderNum(i);
                continue;
            }
            if (titlemap.containsKey(excelParams.get(i).getName())) {
                excelParams.get(i).setOrderNum(i);
                continue;
            }
            excelParams.remove(i);
        }
        this.sortAllParams(excelParams);
    }
}

