/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.word.parse.excel;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.jeecgframework.poi.util.PoiElUtil;

public final class ExcelMapParse {
    private static String[] parseCurrentRowGetParams(XWPFTableRow currentRow) {
        List cells = currentRow.getTableCells();
        String[] params = new String[cells.size()];
        for (int i = 0; i < cells.size(); ++i) {
            String text = ((XWPFTableCell)cells.get(i)).getText();
            params[i] = text == null ? "" : text.trim().replace("{{", "").replace("}}", "");
        }
        return params;
    }

    public static void parseNextRowAndAddRow(XWPFTable table, int index, List<Object> list) throws Exception {
        XWPFTableRow currentRow = table.getRow(index);
        String[] params = ExcelMapParse.parseCurrentRowGetParams(currentRow);
        String listname = params[0];
        boolean isCreate = !listname.contains("!fe:");
        listname = listname.replace("!fe:", "").replace("$fe:", "").replace("fe:", "").replace("{{", "");
        String[] keys = listname.replaceAll("\\s{1,}", " ").trim().split(" ");
        params[0] = keys[1];
        table.removeRow(index);
        int cellIndex = 0;
        HashMap tempMap = Maps.newHashMap();
        for (Object obj : list) {
            String val;
            currentRow = isCreate ? table.createRow() : table.getRow(index++);
            tempMap.put("t", obj);
            for (cellIndex = 0; cellIndex < currentRow.getTableCells().size(); ++cellIndex) {
                val = PoiElUtil.eval(params[cellIndex], tempMap).toString();
                ((XWPFTableCell)currentRow.getTableCells().get(cellIndex)).setText(val);
            }
            while (cellIndex < params.length) {
                val = PoiElUtil.eval(params[cellIndex], tempMap).toString();
                currentRow.createCell().setText(val);
                ++cellIndex;
            }
        }
    }
}

