/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.html.css;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jeecgframework.poi.excel.html.entity.style.CellStyleBorderEntity;
import org.jeecgframework.poi.excel.html.entity.style.CellStyleEntity;
import org.jeecgframework.poi.excel.html.entity.style.CssStyleFontEnity;
import org.jeecgframework.poi.util.PoiCssUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssParseServer {
    private static final Logger log = LoggerFactory.getLogger(CssParseServer.class);
    private static final Set<String> BORDER_STYLES = new HashSet<String>(){
        {
            this.add("none");
            this.add("hidden");
            this.add("dotted");
            this.add("dashed");
            this.add("solid");
            this.add("double");
        }
    };

    public CellStyleEntity parseStyle(String style) {
        HashMap<String, String> mapStyle = new HashMap<String, String>();
        for (String s : style.split("\\s*;\\s*")) {
            String[] ss;
            if (!StringUtils.isNotBlank((CharSequence)s) || (ss = s.split("\\s*\\:\\s*")).length != 2 || !StringUtils.isNotBlank((CharSequence)ss[0]) || !StringUtils.isNotBlank((CharSequence)ss[1])) continue;
            String attrName = ss[0].toLowerCase();
            String attrValue = ss[1];
            if (!"font".equals(attrName) && !"font-family".equals(attrName)) {
                attrValue = attrValue.toLowerCase();
            }
            mapStyle.put(attrName, attrValue);
        }
        this.parseFontAttr(mapStyle);
        this.parseBackground(mapStyle);
        this.parseBorder(mapStyle);
        return this.mapToCellStyleEntity(mapStyle);
    }

    private CellStyleEntity mapToCellStyleEntity(Map<String, String> mapStyle) {
        CellStyleEntity entity = new CellStyleEntity();
        entity.setAlign(mapStyle.get("text-align"));
        entity.setVetical(mapStyle.get("vertical-align"));
        entity.setBackground(this.parseBackground(mapStyle));
        entity.setHeight(mapStyle.get("height"));
        entity.setWidth(mapStyle.get("width"));
        entity.setFont(this.getCssStyleFontEnity(mapStyle));
        entity.setBackground(mapStyle.get("background-color"));
        entity.setBorder(this.getCssStyleBorderEntity(mapStyle));
        return entity;
    }

    private CellStyleBorderEntity getCssStyleBorderEntity(Map<String, String> mapStyle) {
        CellStyleBorderEntity border = new CellStyleBorderEntity();
        border.setBorderTopColor(mapStyle.get("border-top-color"));
        border.setBorderBottomColor(mapStyle.get("border-bottom-color"));
        border.setBorderLeftColor(mapStyle.get("border-left-color"));
        border.setBorderRightColor(mapStyle.get("border-right-color"));
        border.setBorderTopWidth(mapStyle.get("border-top-width"));
        border.setBorderBottomWidth(mapStyle.get("border-bottom-width"));
        border.setBorderLeftWidth(mapStyle.get("border-left-width"));
        border.setBorderRightWidth(mapStyle.get("border-right-width"));
        border.setBorderTopStyle(mapStyle.get("border-top-style"));
        border.setBorderBottomStyle(mapStyle.get("border-bottom-style"));
        border.setBorderLeftStyle(mapStyle.get("border-left-style"));
        border.setBorderRightStyle(mapStyle.get("border-right-style"));
        return border;
    }

    private CssStyleFontEnity getCssStyleFontEnity(Map<String, String> style) {
        CssStyleFontEnity font = new CssStyleFontEnity();
        font.setStyle(style.get("font-style"));
        int fontSize = PoiCssUtils.getInt(style.get("font-size"));
        if (fontSize > 0) {
            font.setSize(fontSize);
        }
        font.setWeight(style.get("font-weight"));
        font.setFamily(style.get("font-family"));
        font.setDecoration(style.get("text-decoration"));
        font.setColor(style.get("color"));
        return font;
    }

    public void parseBorder(Map<String, String> style) {
        for (String pos : new String[]{null, "top", "right", "bottom", "left"}) {
            if (pos == null) {
                this.setBorderAttr(style, pos, style.get("border"));
                this.setBorderAttr(style, pos, style.get("border-color"));
                this.setBorderAttr(style, pos, style.get("border-width"));
                this.setBorderAttr(style, pos, style.get("border-style"));
                continue;
            }
            this.setBorderAttr(style, pos, style.get("border-" + pos));
            for (String attr : new String[]{"color", "width", "style"}) {
                String attrName = "border-" + pos + "-" + attr;
                String attrValue = style.get(attrName);
                if (!StringUtils.isNotBlank((CharSequence)attrValue)) continue;
                style.put(attrName, attrValue);
            }
        }
    }

    private void setBorderAttr(Map<String, String> mapBorder, String pos, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String borderColor = null;
            for (String borderAttr : value.split("\\s+")) {
                borderColor = PoiCssUtils.processColor(borderAttr);
                if (borderColor != null) {
                    this.setBorderAttr(mapBorder, pos, "color", borderColor);
                    continue;
                }
                if (PoiCssUtils.isNum(borderAttr)) {
                    this.setBorderAttr(mapBorder, pos, "width", borderAttr);
                    continue;
                }
                if (BORDER_STYLES.contains(borderAttr)) {
                    this.setBorderAttr(mapBorder, pos, "style", borderAttr);
                    continue;
                }
                log.info("Border Attr [{}] Is Not Suppoted.", (Object)borderAttr);
            }
        }
    }

    private void setBorderAttr(Map<String, String> mapBorder, String pos, String attr, String value) {
        if (StringUtils.isNotBlank((CharSequence)pos)) {
            mapBorder.put("border-" + pos + "-" + attr, value);
        } else {
            for (String name : new String[]{"top", "right", "bottom", "left"}) {
                mapBorder.put("border-" + name + "-" + attr, value);
            }
        }
    }

    private void parseFontAttr(Map<String, String> mapRtn) {
        String font;
        log.debug("Parse Font Style.");
        String color = PoiCssUtils.processColor(mapRtn.get("color"));
        if (StringUtils.isNotBlank((CharSequence)color)) {
            log.debug("Text Color [{}] Found.", (Object)color);
            mapRtn.put("color", color);
        }
        if (StringUtils.isNotBlank((CharSequence)(font = mapRtn.get("font"))) && !ArrayUtils.contains((Object[])new String[]{"small-caps", "caption", "icon", "menu", "message-box", "small-caption", "status-bar"}, (Object)font)) {
            log.debug("Parse Font Attr [{}].", (Object)font);
            Object[] ignoreStyles = new String[]{"normal", "[1-3]00"};
            StringBuffer sbFont = new StringBuffer(font.replaceAll("^|\\s*" + StringUtils.join((Object[])ignoreStyles, (String)"|") + "\\s+|$", " "));
            log.debug("Font Attr [{}] After Process Ingore.", (Object)sbFont);
            Matcher m = Pattern.compile("(?:^|\\s+)(italic|oblique)(?:\\s+|$)").matcher(sbFont.toString());
            if (m.find()) {
                sbFont.setLength(0);
                if (log.isDebugEnabled()) {
                    log.debug("Font Style [{}] Found.", (Object)m.group(1));
                }
                mapRtn.put("font-style", "italic");
                m.appendReplacement(sbFont, " ");
                m.appendTail(sbFont);
            }
            if ((m = Pattern.compile("(?:^|\\s+)(bold(?:er)?|[7-9]00)(?:\\s+|$)").matcher(sbFont.toString())).find()) {
                sbFont.setLength(0);
                if (log.isDebugEnabled()) {
                    log.debug("Font Weight [{}](bold) Found.", (Object)m.group(1));
                }
                mapRtn.put("font-weight", "bold");
                m.appendReplacement(sbFont, " ");
                m.appendTail(sbFont);
            }
            if ((m = Pattern.compile("(?:^|\\s+)" + "(xx-small|x-small|small|medium|large|x-large|xx-large|" + "(?:" + "\\d*\\.?\\d+\\s*(?:em|ex|cm|mm|q|in|pt|pc|px)?" + "))" + "(?:\\s*\\/\\s*(" + "\\d*\\.?\\d+\\s*(?:em|ex|cm|mm|q|in|pt|pc|px)?" + "))?" + "(?:\\s+|$)").matcher(sbFont.toString())).find()) {
                String lineHeight;
                sbFont.setLength(0);
                log.debug("Font Size[/line-height] [{}] Found.", (Object)m.group());
                String fontSize = m.group(1);
                if (StringUtils.isNotBlank((CharSequence)fontSize)) {
                    fontSize = StringUtils.deleteWhitespace((String)fontSize);
                    log.debug("Font Size [{}].", (Object)fontSize);
                    if (fontSize.matches("\\d*\\.?\\d+\\s*(?:em|ex|cm|mm|q|in|pt|pc|px)?")) {
                        mapRtn.put("font-size", fontSize);
                    } else {
                        log.info("Font Size [{}] Not Supported, Ignore.", (Object)fontSize);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(lineHeight = m.group(2)))) {
                    log.info("Line Height [{}] Not Supported, Ignore.", (Object)lineHeight);
                }
                m.appendReplacement(sbFont, " ");
                m.appendTail(sbFont);
            }
            if (sbFont.length() > 0) {
                log.debug("Font Families [{}].", (Object)sbFont);
                String fontFamily = sbFont.toString().split("\\s*,\\s*")[0].trim().replaceAll("'|\"", "");
                log.debug("Use First Font Family [{}].", (Object)fontFamily);
                mapRtn.put("font-family", fontFamily);
            }
        }
        if (ArrayUtils.contains((Object[])new String[]{"italic", "oblique"}, (Object)(font = mapRtn.get("font-style")))) {
            log.debug("Font Italic [{}] Found.", (Object)font);
            mapRtn.put("font-style", "italic");
        }
        if (StringUtils.isNotBlank((CharSequence)(font = mapRtn.get("font-weight"))) && Pattern.matches("^bold(?:er)?|[7-9]00$", font)) {
            log.debug("Font Weight [{}](bold) Found.", (Object)font);
            mapRtn.put("font-weight", "bold");
        }
        if (!PoiCssUtils.isNum(font = mapRtn.get("font-size"))) {
            log.debug("Font Size [{}] Error.", (Object)font);
            mapRtn.remove("font-size");
        }
    }

    private String parseBackground(Map<String, String> style) {
        String bg = style.get("background");
        String bgColor = null;
        if (StringUtils.isNotBlank((CharSequence)bg)) {
            for (String bgAttr : bg.split("(?<=\\)|\\w|%)\\s+(?=\\w)")) {
                bgColor = PoiCssUtils.processColor(bgAttr);
                if (bgColor == null) continue;
                style.put("background-color", bgColor);
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(bg = style.get("background-color"))) && (bgColor = PoiCssUtils.processColor(bg)) != null) {
            style.put("background-color", bgColor);
        }
        if (bgColor != null && "#ffffff".equals(bgColor = style.get("background-color"))) {
            style.remove("background-color");
        }
        return null;
    }
}

