/*
 * Decompiled with CFR 0.152.
 */
package org.jesperancinha.console.consolerizer8;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.jesperancinha.console.consolerizer8.ConsolerizerColor;

public class ConsolerizerInteractions {
    public static void performQuestion(String question, String[] options, int maxFails, List<String> correctAnswers) {
        String questionBlock = question.concat("\n");
        String optionsBlock = String.join((CharSequence)"\n", Arrays.asList(options));
        ConsolerizerInteractions.performQuestion(questionBlock.concat(optionsBlock), maxFails, correctAnswers);
    }

    public static void performQuestion(String question, int maxFails, List<String> correctAnswers) {
        ConsolerizerColor.RED.printSyncGenericLn("Q: " + question + ":");
        ArrayList<String> correctResponses = new ArrayList<String>();
        int fails = maxFails;
        while (fails-- > 0 && correctResponses.size() != correctAnswers.size()) {
            Scanner sc = new Scanner(System.in);
            String answer = sc.nextLine();
            if (correctAnswers.stream().anyMatch(answer::contains)) {
                if (correctAnswers.stream().filter(ca -> ca.contains(answer)).findAny().map(ca -> correctResponses.stream().anyMatch(cr -> cr.contains((CharSequence)ca))).orElse(false).booleanValue()) {
                    ConsolerizerColor.ORANGE.printGenericLn("You've answered this already! %d correct , %d to go! You have %d tries left", correctResponses.size(), correctAnswers.size() - correctResponses.size(), fails);
                    continue;
                }
                correctResponses.add(answer);
                fails = maxFails;
                ConsolerizerColor.GREEN.printGenericLn("Correct! %d correct , %d to go! You have %d tries left", correctResponses.size(), correctAnswers.size() - correctResponses.size(), fails);
                continue;
            }
            ConsolerizerColor.RED.printGenericLn("Fail! %d correct , %d to go! You have %d tries left", correctResponses.size(), correctAnswers.size() - correctResponses.size(), fails);
        }
        if (correctResponses.size() == correctAnswers.size()) {
            ConsolerizerColor.GREEN.printGenericLn("You have answered this question correctly! \ud83d\udc4d");
        } else {
            ConsolerizerColor.RED.printGenericLn("You have failed this question! No worries, just study harder next time \ud83d\ude0a");
        }
        ConsolerizerColor.ORANGE.printGenericLn("Correct answers were %s", correctAnswers);
        ConsolerizerColor.MAGENTA.printGenericLn("Your correct answers were %s", correctResponses);
    }

    public static void performQuestion(String question, int maxFails, Map<String, List<String>> correctAnswers) {
        ConsolerizerColor.RED.printSyncGenericLn("Q: " + question + ":");
        ConsolerizerColor.YELLOW.printGenericLn("NOTE: To provide an answer use a =>. Left side is the key and the right side is the value");
        HashMap correctResponses = new HashMap();
        int fails = maxFails;
        while (fails-- > 0 && correctResponses.size() != correctAnswers.size()) {
            Scanner sc = new Scanner(System.in);
            String answer = sc.nextLine();
            String[] keyValue = answer.split("=>");
            if (keyValue.length != 2) {
                ConsolerizerColor.RED.printGenericLn("Fail! %d correct , %d to go! You have %d tries left", correctResponses.size(), correctAnswers.size() - correctResponses.size(), fails);
                continue;
            }
            String key = keyValue[0].trim();
            List value = Arrays.stream(keyValue[1].trim().split(",")).map(String::trim).collect(Collectors.toList());
            List<String> correctAnswersList = correctAnswers.get(key);
            if (Objects.nonNull(correctAnswersList) && value.containsAll(correctAnswersList)) {
                if (correctAnswersList.stream().filter(ca -> ca.contains(answer)).findAny().map(ca -> ((List)correctResponses.get(key)).stream().anyMatch(cr -> cr.contains((CharSequence)ca))).orElse(false).booleanValue()) {
                    ConsolerizerColor.ORANGE.printGenericLn("You've answered this already! %d correct , %d to go! You have %d tries left", correctResponses.size(), correctAnswers.size() - correctResponses.size(), fails);
                    continue;
                }
                correctResponses.put(key, value);
                fails = maxFails;
                ConsolerizerColor.GREEN.printGenericLn("Correct! %d correct , %d to go! You have %d tries left", correctResponses.size(), correctAnswers.size() - correctResponses.size(), fails);
                continue;
            }
            ConsolerizerColor.RED.printGenericLn("Fail! %d correct , %d to go! You have %d tries left", correctResponses.size(), correctAnswers.size() - correctResponses.size(), fails);
        }
        if (correctResponses.size() == correctAnswers.size()) {
            ConsolerizerColor.GREEN.printGenericLn("You have answered this question correctly! \ud83d\udc4d");
        } else {
            ConsolerizerColor.RED.printGenericLn("You have failed this question! No worries, just study harder next time \ud83d\ude0a");
        }
        ConsolerizerColor.ORANGE.printGenericLn("Correct answers were %s", correctAnswers);
        ConsolerizerColor.MAGENTA.printGenericLn("Your correct answers were %s", correctResponses);
    }
}

