/*
 * Decompiled with CFR 0.152.
 */
package org.jesperancinha.console.consolerizer8;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jesperancinha.console.consolerizer8.ConsolerizerColor;
import org.jesperancinha.console.consolerizer8.ConsolerizerTexts;

public class Consolerizer {
    private static final int TYPING_DEFAULT_MS = 0;
    private static final int MAX_LINE_CHARS = 0;
    private static final int RAINBOW_LINE_CHARS = 10;
    private static final int TITLE_SPREAD = 100;
    private static final ConsolerizerColor CON_COLOR_DEFAULT = ConsolerizerColor.BRIGHT_WHITE;
    private static ConsolerizerColor currentColor;
    private int typingWait;
    public static int typingWaitGlobal;
    public static int maxLineCharsGlobal;
    public static int rainbowLineChars;
    public static int titleSpread;
    public static boolean blackAndWhite;
    private final ConsolerizerColor consolerizerColor;

    public Consolerizer() {
        this.typingWait = 0;
        this.consolerizerColor = CON_COLOR_DEFAULT;
    }

    public Consolerizer(int typingWait) {
        this.typingWait = typingWait;
        this.consolerizerColor = CON_COLOR_DEFAULT;
    }

    public Consolerizer(ConsolerizerColor consolerizerColor) {
        this.consolerizerColor = consolerizerColor;
    }

    public static void setupFastDefault() {
        typingWaitGlobal = 0;
        maxLineCharsGlobal = 100;
        titleSpread = 100;
        blackAndWhite = false;
    }

    public static void setupFastDefaultWideTitleSpread() {
        typingWaitGlobal = 0;
        titleSpread = maxLineCharsGlobal = 250;
        blackAndWhite = false;
    }

    public static void setupRetro() {
        typingWaitGlobal = 10;
        maxLineCharsGlobal = 0;
        titleSpread = 100;
        blackAndWhite = false;
    }

    public Consolerizer typingWait(int typingWait) {
        this.typingWait = typingWait;
        return this;
    }

    public static void printRandomColorGenericLn(String text, Object ... args) {
        Consolerizer.printRandomColorGeneric(text.concat("\n"), args);
    }

    public static void printRandomColorGenericLn(Object text) {
        Consolerizer.printRandomColorGeneric(("" + text).trim().concat("\n"));
    }

    public static void printRandomColorGeneric(Object text) {
        Consolerizer.printColor(ConsolerizerColor.getRandomColor());
        Consolerizer.printPrivateText(text.toString());
    }

    public static void printRandomColorGeneric(String text, Object ... args) {
        Consolerizer.printColor(ConsolerizerColor.getRandomColor());
        Consolerizer.printPrivateText(text, args);
    }

    public void printColorText(ConsolerizerColor consolerizerColor, String text) {
        Consolerizer.printColor(consolerizerColor);
        Consolerizer.printPrivateText(text);
    }

    public void printText(String text) {
        Consolerizer.printColor(this.consolerizerColor);
        Consolerizer.printPrivateText(text);
    }

    public void printText(String text, Object ... vars) {
        Consolerizer.printColor(this.consolerizerColor);
        Consolerizer.printPrivateText(text, vars);
    }

    static void printPrivateText(Object text) {
        if (blackAndWhite) {
            Consolerizer.printColor(ConsolerizerColor.WHITE);
        }
        Consolerizer.printPrivateText(text.toString(), typingWaitGlobal, maxLineCharsGlobal);
    }

    private static void printPrivateText(String text, Object ... vars) {
        if (blackAndWhite) {
            Consolerizer.printColor(ConsolerizerColor.WHITE);
        }
        if (vars instanceof String[][]) {
            Consolerizer.printPrivateText(text, typingWaitGlobal, maxLineCharsGlobal, new Object[]{Consolerizer.processMultiArrays2((String[][])vars)});
        } else {
            for (int i = 0; i < vars.length; ++i) {
                Object variable = vars[i];
                if (variable instanceof Exception) {
                    StringWriter out = new StringWriter();
                    ((Exception)variable).printStackTrace(new PrintWriter(out));
                    vars[i] = out.toString();
                }
                if (variable instanceof Error) {
                    Throwable cause;
                    Throwable e = (Throwable)variable;
                    StackTraceElement[] stackTrace = e.getStackTrace();
                    StringBuilder sb = new StringBuilder(e.getClass().getCanonicalName());
                    if (Objects.nonNull(e.getMessage())) {
                        sb.append("\n\t");
                        sb.append(e.getMessage());
                    }
                    Arrays.stream(stackTrace).forEach(stackTraceElement -> {
                        sb.append("\n\t");
                        sb.append(stackTraceElement.toString());
                    });
                    if (variable instanceof Error && Objects.nonNull(cause = e.getCause())) {
                        sb.append("\n");
                        sb.append(cause.getClass().getCanonicalName());
                        if (Objects.nonNull(cause.getMessage())) {
                            sb.append("\n\t");
                            sb.append(cause.getMessage());
                        }
                        Arrays.stream(cause.getStackTrace()).forEach(stackTraceElement -> {
                            sb.append("\n\t");
                            sb.append(stackTraceElement.toString());
                        });
                    }
                    vars[i] = sb.toString();
                    continue;
                }
                if (variable instanceof String[][]) {
                    vars[i] = Consolerizer.processMultiArrays2((String[][])vars[i]);
                    continue;
                }
                if (variable instanceof String[]) {
                    vars[i] = "[".concat(String.join((CharSequence)",", (String[])variable)).concat("]");
                    continue;
                }
                if (!(variable instanceof int[])) continue;
                vars[i] = "[".concat(IntStream.of((int[])variable).mapToObj(Integer::toString).collect(Collectors.joining(",")).concat("]"));
            }
            Consolerizer.printPrivateText(text, typingWaitGlobal, maxLineCharsGlobal, vars);
        }
    }

    private static String processMultiArrays2(String[][] vars) {
        return "[".concat(Arrays.stream(vars).flatMap(x -> Stream.of("[".concat(String.join((CharSequence)",", x)).concat("]"))).collect(Collectors.joining(","))).concat("]");
    }

    private static void printPrivateText(String text, int typingWait, int maxLineChars) {
        String printText = text;
        if (maxLineChars > 0 && printText.length() > maxLineChars) {
            Consolerizer.printPerLine(printText, typingWait, maxLineChars);
        } else {
            Consolerizer.printColor(currentColor);
            for (int i = 0; i < printText.length(); ++i) {
                if (typingWait > 0) {
                    try {
                        Thread.sleep(typingWait);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                Consolerizer.printColor(currentColor);
                char c = printText.charAt(i);
                System.out.print(c);
                if (c != '\n') continue;
                Consolerizer.printColor(currentColor);
            }
            if (!text.contains("\n")) {
                System.out.print(" ");
            }
            System.out.print(ConsolerizerColor.WHITE.getConsoleColor());
        }
    }

    private static void printPerLine(String printText, int typingWait, int maxLineChars) {
        List collect = Arrays.stream(printText.split("\n")).map(paragraph -> Arrays.stream(Consolerizer.getSplit(maxLineChars, paragraph)).map(ConsolerizerTexts::trim).collect(Collectors.toList())).collect(Collectors.toList());
        for (List list : collect) {
            for (String line : list) {
                Arrays.stream(line.split("\n")).forEach(subLine -> {
                    for (int i = 0; i < subLine.length(); ++i) {
                        if (typingWait > 0) {
                            try {
                                Thread.sleep(typingWait);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        Consolerizer.printColor(currentColor);
                        char c = subLine.charAt(i);
                        System.out.print(c);
                        if (c != '\n') continue;
                        Consolerizer.printColor(currentColor);
                    }
                    Consolerizer.printNewLine();
                });
            }
        }
    }

    private static void printPrivateText(String text, int typingWait, int maxLineChars, Object ... vars) {
        String newText;
        String printText = newText = String.format(text, vars);
        if (maxLineChars > 0) {
            Consolerizer.printPerLine(printText, typingWait, maxLineChars);
        } else {
            for (int i = 0; i < printText.length(); ++i) {
                if (typingWait > 0) {
                    try {
                        Thread.sleep(typingWait);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                char c = printText.charAt(i);
                System.out.print(c);
                if (c != '\n') continue;
                Consolerizer.printColor(currentColor);
            }
            if (!text.contains("\n")) {
                System.out.print(" ");
            }
            System.out.print(ConsolerizerColor.WHITE.getConsoleColor());
        }
    }

    private static String[] getSplit(int maxLineChars, String printText) {
        String[] split = ConsolerizerTexts.trim(printText).split("(?<=\\G.{" + maxLineChars + "})");
        if (split.length > 1 && split[1].length() > maxLineChars) {
            String[] newSplit = Consolerizer.getSplit(maxLineChars, split[1]);
            int newLength = newSplit.length + 1;
            String[] newStrings = new String[newLength];
            newStrings[0] = ConsolerizerTexts.trim(split[0]);
            System.arraycopy(newSplit, 0, newStrings, 1, newSplit.length);
            return newStrings;
        }
        return split;
    }

    public static void printRainbowTitleLn(Object title) {
        Consolerizer.printRainbowTitle(title.toString().trim());
        System.out.print("\n");
        Consolerizer.printColor(ConsolerizerColor.WHITE);
    }

    public static void printRainbowTitleLn(String title, Object ... objects) {
        Consolerizer.printRainbowTitle(String.format(title, objects));
        System.out.print("\n");
        Consolerizer.printColor(ConsolerizerColor.WHITE);
    }

    public static void printRainbowTitle(String title) {
        List<String> consoleRainbow = ConsolerizerColor.getConsoleRainbow();
        int k = 0;
        for (int i = 0; i < title.length(); ++i) {
            if (k == consoleRainbow.size()) {
                k = 0;
            }
            System.out.print(consoleRainbow.get(k));
            System.out.print(title.charAt(i));
            if (title.charAt(i) == ' ') continue;
            ++k;
        }
        Consolerizer.printColor(ConsolerizerColor.WHITE);
    }

    public static void printRainbowLn(char c, int nchars) {
        Consolerizer.printRainbowLn(Stream.generate(Character.valueOf(c)::toString).limit(nchars).collect(Collectors.joining()));
    }

    public static void printRainbowLn(char c) {
        Consolerizer.printRainbowLn(Stream.generate(Character.valueOf(c)::toString).limit(rainbowLineChars).collect(Collectors.joining()));
    }

    public static void printRainbowLn(String theme) {
        Consolerizer.printRainbow(theme);
        System.out.print("\n");
    }

    public static void printRainbow(String theme) {
        ConsolerizerColor.getConsoleRainbow().forEach(color -> {
            System.out.print((String)color);
            System.out.print(theme);
        });
    }

    public static void printRainbowStack(String theme) {
        ConsolerizerColor.getConsoleRainbow().forEach(color -> {
            System.out.print((String)color);
            System.out.println(theme);
        });
    }

    public static void printSameLine(String text, Object ... objects) {
        System.out.print("\r");
        System.out.printf(text, objects);
    }

    public static void printNewLine() {
        System.out.print("\n");
    }

    static void printColor(ConsolerizerColor consolerizerColor) {
        currentColor = consolerizerColor;
        if (Objects.nonNull((Object)consolerizerColor)) {
            System.out.print(currentColor.getConsoleColor());
        }
    }

    static String createTitleLineLn(Object text, char limitingChar) {
        return ConsolerizerTexts.createTitleLineLn(text, limitingChar, true);
    }

    static String createTitleLine(Object text, char limitingChar) {
        return ConsolerizerTexts.createTitleLineLn(text, limitingChar, false);
    }

    public static void printRawGenericLn(Object text, Object ... args) {
        Consolerizer.printPrivateText(text.toString().concat("\n"), args);
    }

    public static void printRawGeneric(Object text, Object ... args) {
        Consolerizer.printPrivateText(text.toString(), args);
    }

    public void printGenericLn(Object text, Object ... args) {
        this.printGeneric(text.toString().concat("\n"), args);
    }

    public void printGenericLn(Object text) {
        this.printGeneric(("" + text).trim().concat("\n"));
    }

    public void printGeneric(Object text) {
        Consolerizer.printColor(this.consolerizerColor);
        Consolerizer.printPrivateText(text.toString());
    }

    public void printGeneric(Object text, Object ... args) {
        Consolerizer.printColor(this.consolerizerColor);
        Consolerizer.printPrivateText(text.toString(), args);
    }

    public void printGenericTitleLn(Object text, Object ... args) {
        Consolerizer.printColor(this.consolerizerColor);
        this.printGenericTitleLn(String.format("" + text, args));
    }

    public void printGenericTitleLn(Object text) {
        Consolerizer.printColor(this.consolerizerColor);
        String titleString = Consolerizer.createTitleLineLn(text, '=');
        this.printGeneric(titleString);
    }

    public void printThrowableAndExit(Throwable e) {
        Consolerizer.printColor(this.consolerizerColor);
        this.printGenericLn("Ooops! This should not have happened. Check your system! -> %s", e);
        this.printGenericLn("Check if there is a prepare.sh script and if you ran it.", e);
        System.exit(1);
    }

    public void printInstanceLn(Object text) {
        Consolerizer.printColor(this.consolerizerColor);
        this.printGenericLn("This is an instance of type %s with hash %s", text.getClass().getCanonicalName(), text.hashCode());
    }

    static {
        typingWaitGlobal = 0;
        maxLineCharsGlobal = 0;
        rainbowLineChars = 10;
        titleSpread = 100;
    }
}

