/*
 * Decompiled with CFR 0.152.
 */
package org.jesperancinha.console.consolerizer8;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jesperancinha.console.consolerizer8.Consolerizer;
import org.jesperancinha.console.consolerizer8.ConsolerizerColor;
import org.jesperancinha.console.consolerizer8.ConsolerizerConsoleWriter;
import org.jesperancinha.console.consolerizer8.ConsolerizerWriter;

public class ConsolerizerGraphs {
    public static String getUnicorns(int i) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < i; ++j) {
            sb.append("\ud83e\udd84");
        }
        return sb.toString();
    }

    public static void printRainbowFlag(String flagText, Object ... args) {
        ConsolerizerGraphs.printRainbowFlag(String.format(flagText, args));
    }

    public static void printRainbowFlag(String flagText) {
        ConsolerizerGraphs.printRainbowFlag(flagText, new ConsolerizerConsoleWriter());
    }

    public static void printRainbowFlag(String flagText, ConsolerizerWriter consolerizerWriter) {
        int heightPerColorBar = (int)((double)Consolerizer.titleSpread * 10.0 / 19.0) / 6 / 4;
        heightPerColorBar = heightPerColorBar <= 0 ? 1 : heightPerColorBar;
        List<ConsolerizerColor> consoleRainbow = ConsolerizerColor.getConsoleRainbowEnumList();
        int rainbowColorSize = consoleRainbow.size();
        int height = rainbowColorSize * heightPerColorBar;
        int iMiddle = height / 2;
        iMiddle = height % 2 == 0 ? iMiddle - 1 : iMiddle;
        int k = 0;
        for (int i = 0; i < rainbowColorSize; ++i) {
            consolerizerWriter.printColor(consoleRainbow.get(i));
            int j = 0;
            while (j < heightPerColorBar) {
                if (k == iMiddle || k == iMiddle + 1) {
                    consolerizerWriter.printPrivateText(Consolerizer.createTitleLine(flagText, '*'));
                } else {
                    consolerizerWriter.printPrivateText(StringUtils.repeat((String)"*", (int)Consolerizer.titleSpread));
                }
                consolerizerWriter.printNewLine();
                ++j;
                ++k;
            }
        }
    }

    public static void printUnicornsLn(int nUnicorns) {
        Consolerizer.printRainbowLn('-', nUnicorns / 4);
        for (int i = 0; i < nUnicorns; ++i) {
            System.out.print("\ud83e\udd84");
        }
        Consolerizer.printNewLine();
        Consolerizer.printRainbowLn('-', nUnicorns / 4);
    }
}

