/*
 * Decompiled with CFR 0.152.
 */
package org.jesperancinha.console.consolerizer8.html;

import org.jesperancinha.console.consolerizer8.common.Composer;
import org.jesperancinha.console.consolerizer8.common.ConsolerizerColor;
import org.jesperancinha.console.consolerizer8.html.HtmlPWriter;

public class HtmlComposer
extends Composer<HtmlComposer> {
    HtmlComposer() {
    }

    HtmlComposer(String splitter) {
        super(splitter);
    }

    public static HtmlComposer out() {
        return new HtmlComposer();
    }

    public static HtmlComposer out(String splitter) {
        return new HtmlComposer(String.format("<span>%s</span>", splitter));
    }

    @Override
    public HtmlComposer out(ConsolerizerColor consolerizerColor, String text) {
        this.sb.append(String.format("<span style=\"color: %s\">%s</span>", consolerizerColor.getHexColor(), text));
        this.sb.append(this.splitter);
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    public void writeToHtml(HtmlPWriter htmlPWriter) {
        htmlPWriter.printRawPrivateText(this.toString());
    }

    public void writeLineToHtml(HtmlPWriter htmlPWriter) {
        htmlPWriter.printRawPrivateText("<p>".concat(this.toString()).concat("</p>"));
    }
}

