/*
 * Decompiled with CFR 0.152.
 */
package org.jesperancinha.console.consolerizer8.common;

import java.util.Arrays;
import java.util.List;
import org.jesperancinha.console.consolerizer8.console.Consolerizer;
import org.jesperancinha.console.consolerizer8.html.Htmlizer;

public enum ConsolerizerColor {
    RESET("FFFFFF", "\u001b[0m"),
    WHITE("FFFFFF", "\u001b[0m"),
    BLACK("000000", "\u001b[0;30m"),
    BLUE("0000AA", "\u001b[0;34m"),
    GREEN("00AA00", "\u001b[0;32m"),
    CYAN("00AAAA", "\u001b[0;36m"),
    RED("AA0000", "\u001b[0;31m"),
    ORANGE("FFA500", "\u001b[38;5;208m"),
    MAGENTA("AA00AA", "\u001b[38;5;135m"),
    BROWN("AA5500", "\u001b[0;33m"),
    YELLOW("FFFF55", "\u001b[0;33m"),
    LIGHT_GREY("AAAAAA", "\u001b[0;37m"),
    DARK_GREY("555555", "\u001b[0;90m"),
    BRIGHT_BLUE("5555FF", "\u001b[1;34m"),
    BRIGHT_GREEN("55FF55", "\u001b[1;32m"),
    BRIGHT_CYAN("55FFFF", "\u001b[1;36m"),
    BRIGHT_RED("FF5555", "\u001b[1;31m"),
    BRIGHT_MAGENTA("FF55FF", "\u001b[0;95m"),
    BRIGHT_WHITE("FFFFFF", "\u001b[1;39m"),
    BG_ORANGE("AA0000", "\u001b[48:2:255:165:0m");

    private final Consolerizer colorManager;
    private final String hexColor;
    private final String consoleColor;

    private ConsolerizerColor(String hexColor, String consoleColor) {
        this.hexColor = hexColor;
        this.consoleColor = consoleColor;
        this.colorManager = new Consolerizer(this);
        Consolerizer.setupFastDefault();
    }

    public static ConsolerizerColor getRandomColor() {
        ConsolerizerColor[] values = ConsolerizerColor.values();
        int randomI = (int)(Math.random() * (double)values.length);
        return values[randomI];
    }

    public String getConsoleColor() {
        return this.consoleColor;
    }

    public String getHexColor() {
        return this.hexColor;
    }

    public Consolerizer getColorManager() {
        return this.colorManager;
    }

    public void printGenericLn(Object text, Object ... args) {
        this.colorManager.printGenericLn(text, args);
    }

    public synchronized void printSyncGenericLn(Object text, Object ... args) {
        this.colorManager.printGenericLn(text, args);
    }

    public void printGenericLn(Object text) {
        this.colorManager.printGenericLn(text);
    }

    public synchronized void printSyncGenericLn(Object text) {
        this.colorManager.printGenericLn(text);
    }

    public void printGeneric(Object text) {
        this.colorManager.printGeneric(text);
    }

    public void printGeneric(Object text, Object ... args) {
        this.colorManager.printGeneric(text, args);
    }

    public void printGenericTitleLn(Object text, Object ... args) {
        this.colorManager.printGenericTitleLn(text, args);
    }

    public synchronized void printSyncGenericTitleLn(Object text) {
        this.colorManager.printGenericTitleLn(text);
    }

    public void printGenericTitleLn(Object text) {
        this.colorManager.printGenericTitleLn(text);
    }

    public void printThrowableAndExit(Throwable e) {
        this.colorManager.printThrowableAndExit(e);
    }

    public void printInstanceLn(Object text) {
        this.colorManager.printInstanceLn(text);
    }

    public String getPText(Object text, Object ... args) {
        return this.getPText(String.format("" + text, args));
    }

    public String getPText(Object text) {
        return Htmlizer.getPTextColor(this.hexColor, "" + text);
    }

    public String getPBText(Object text, Object ... args) {
        return this.getPBText(String.format("" + text, args));
    }

    public String getPBText(Object text) {
        return Htmlizer.getPBTextColor(this.hexColor, "" + text);
    }

    public String getAnchorLink(Object text, String url) {
        return Htmlizer.getAnchorLink(this.hexColor, "" + text, url);
    }

    public String getPBEscapedText(Object text, Object ... args) {
        return this.getPBEscapedText(String.format("" + text, args));
    }

    public String getPBEscapedText(Object text) {
        return Htmlizer.getPBTextEscapedColor(this.hexColor, "" + text);
    }

    public static List<String> getConsoleRainbow() {
        return Arrays.asList(RED.getConsoleColor(), ORANGE.getConsoleColor(), YELLOW.getConsoleColor(), GREEN.getConsoleColor(), BLUE.getConsoleColor(), MAGENTA.getConsoleColor());
    }

    public static List<ConsolerizerColor> getConsoleRainbowEnumList() {
        return Arrays.asList(RED, ORANGE, YELLOW, GREEN, BLUE, MAGENTA);
    }

    public void printExpectedException(String text, Object e) {
        this.printGenericLn("This is expected! %s -> %s", text, e);
    }

    public String toString() {
        return this.consoleColor;
    }
}

