/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.app;

import java.io.File;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jessma.app.AppLifeCycleListener;
import org.jessma.app.UserConfigParser;
import org.jessma.dao.SessionMgr;
import org.jessma.util.GeneralHelper;
import org.jessma.util.LogUtil;
import org.slf4j.Logger;

public class AppConfig {
    private Map<String, SessionMgr> sessionMgrs = new HashMap<String, SessionMgr>();
    private UserConfigParser userCfgParser;
    private AppLifeCycleListener appListener;
    private String confFile;
    private static final Logger jessMALogger = LogUtil.getJessMALogger();
    private static final AppConfig instance = new AppConfig();

    private AppConfig() {
    }

    public static final Map<String, SessionMgr> getSessionManagers() {
        return AppConfig.instance.sessionMgrs;
    }

    public static final SessionMgr getSessionManager(String name) {
        return AppConfig.instance.sessionMgrs.get(name);
    }

    static final void sendStartupNotice(ServletContext context, ServletContextEvent sce) {
        if (AppConfig.instance.appListener != null) {
            AppConfig.instance.appListener.onStartup(context, sce);
        }
    }

    static final void sendShutdownNotice(ServletContext context, ServletContextEvent sce) {
        if (AppConfig.instance.appListener != null) {
            AppConfig.instance.appListener.onShutdown(context, sce);
        }
    }

    static void initialize(String file) {
        AppConfig.instance.confFile = file;
        instance.loadConfig();
    }

    private void loadConfig() {
        try {
            Element root = this.getRootElement();
            Element sys = this.getSystemElement(root);
            this.loadSessionMgrs(sys);
            this.loadUserConfig(root, sys);
            this.loadAppListener(sys);
        }
        catch (Exception e) {
            throw new RuntimeException("load application configuration fail", e);
        }
    }

    private Element getRootElement() throws DocumentException {
        SAXReader sr = new SAXReader();
        Document doc = sr.read(new File(this.confFile));
        Element root = doc.getRootElement();
        return root;
    }

    private Element getSystemElement(Element root) {
        Element sys = root.element("system");
        if (sys == null) {
            throw new RuntimeException("'system' element not found");
        }
        return sys;
    }

    private void loadSessionMgrs(Element sys) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Element sms = sys.element("database-session-managers");
        if (sms == null) {
            jessMALogger.warn("'database-session-managers' element not found");
        } else {
            List mgrs = sms.elements("manager");
            if (mgrs.size() == 0) {
                jessMALogger.warn("none of DATABASE SESSION MANAGER found");
            } else {
                for (Element e : mgrs) {
                    String[] params;
                    String name = e.attributeValue("name");
                    String clazz = e.attributeValue("class");
                    if (GeneralHelper.isStrEmpty(name) || GeneralHelper.isStrEmpty(clazz)) {
                        throw new RuntimeException("manager's 'name' or 'class' attribute not valid");
                    }
                    Element iniargs = e.element("initialize-args");
                    if (iniargs == null) {
                        params = new String[]{};
                    } else {
                        List args = iniargs.elements("arg");
                        params = new String[args.size()];
                        for (int i = 0; i < args.size(); ++i) {
                            params[i] = ((Element)args.get(i)).getTextTrim();
                        }
                    }
                    jessMALogger.info(String.format("register DATABASE SESSION MANAGER '%s (%s)'", name, clazz));
                    SessionMgr mgr = (SessionMgr)Class.forName(clazz).newInstance();
                    mgr.initialize(params);
                    this.sessionMgrs.put(name, mgr);
                }
            }
        }
    }

    private void loadUserConfig(Element root, Element sys) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String clazz;
        Element parser = sys.element("user-config-parser");
        if (parser != null && !GeneralHelper.isStrEmpty(clazz = parser.attributeValue("class"))) {
            jessMALogger.info(String.format("register USER CONFIG PARSER '%s'", clazz));
            this.userCfgParser = (UserConfigParser)Class.forName(clazz).newInstance();
            this.parseUserConfig(root);
        }
    }

    private void parseUserConfig(Element root) {
        jessMALogger.info("parse user configuration");
        Element user = root.element("user");
        this.userCfgParser.parse(user);
    }

    private void loadAppListener(Element sys) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String clazz;
        Element listener = sys.element("app-life-cycle-listener");
        if (listener != null && !GeneralHelper.isStrEmpty(clazz = listener.attributeValue("class"))) {
            jessMALogger.info(String.format("register APP LIFE CYCLE LISTENER '%s'", clazz));
            this.appListener = (AppLifeCycleListener)Class.forName(clazz).newInstance();
        }
    }

    static void unInitialize() {
        instance.cleanup();
        AppConfig.deregisterDrivers();
    }

    private void cleanup() {
        Set<Map.Entry<String, SessionMgr>> mgrs = this.sessionMgrs.entrySet();
        for (Map.Entry<String, SessionMgr> mgr : mgrs) {
            jessMALogger.info(String.format("unregister DATABASE SESSION MANAGER '%s'", mgr.getKey()));
            mgr.getValue().unInitialize();
        }
        this.sessionMgrs = null;
        this.userCfgParser = null;
        this.appListener = null;
    }

    private static void deregisterDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                jessMALogger.info(String.format("unregister JDBC DRIVER '%s'", driver));
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                LogUtil.exception(e, String.format("unregister JDBC DRIVER '%s' fail", driver), true);
            }
        }
    }

    public static final AppConfig instance() {
        return instance;
    }

    public synchronized void reloadUserConfig(long delay) throws Exception {
        if (this.userCfgParser != null) {
            GeneralHelper.waitFor(delay);
            Element root = this.getRootElement();
            this.parseUserConfig(root);
        }
    }
}

