/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.app;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jessma.app.AppConfig;
import org.jessma.util.GeneralHelper;
import org.jessma.util.LogUtil;

public class AppListener
implements ServletContextListener {
    private static final String APP_CONFIG_FILE_KEY = "app-config-file";
    private static final String DEFAULT_APP_CONFIG_FILE = "app-config.xml";
    private ServletContext context;

    public void contextInitialized(ServletContextEvent sce) {
        this.context = sce.getServletContext();
        String appConfigFile = this.context.getInitParameter(APP_CONFIG_FILE_KEY);
        if (GeneralHelper.isStrEmpty(appConfigFile)) {
            appConfigFile = DEFAULT_APP_CONFIG_FILE;
        }
        appConfigFile = GeneralHelper.getClassResourcePath(AppListener.class, appConfigFile);
        try {
            LogUtil.logServerStartup(this);
            LogUtil.getJessMALogger().info("load application configuration");
            AppConfig.initialize(appConfigFile);
            AppConfig.sendStartupNotice(this.context, sce);
        }
        catch (Exception e) {
            String msg = "application startup fail";
            LogUtil.exception(e, msg, true);
            throw new RuntimeException(msg, e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            AppConfig.sendShutdownNotice(this.context, sce);
            AppConfig.unInitialize();
            LogUtil.logServerShutdown(this);
        }
        catch (Exception e) {
            String msg = "application shutdown exception";
            LogUtil.exception(e, msg, true);
            throw new RuntimeException(msg, e);
        }
    }
}

