/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.app;

import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jessma.app.AppConfig;
import org.jessma.dao.AbstractFacade;
import org.jessma.dao.DaoBean;
import org.jessma.dao.DaoBeans;
import org.jessma.dao.FacadeProxy;
import org.jessma.dao.SessionMgr;
import org.jessma.mvc.AbstractActionFilter;
import org.jessma.mvc.Action;
import org.jessma.mvc.ActionExecutor;
import org.jessma.mvc.ActionSupport;
import org.jessma.util.BeanHelper;
import org.jessma.util.CoupleKey;
import org.jessma.util.GeneralHelper;

public class DaoInjectFilter
extends AbstractActionFilter {
    private Map<CoupleKey<Class<?>, Method>, DaoAttr[]> daoMap;

    @Override
    public void init() {
        this.daoMap = new HashMap();
    }

    @Override
    public void destroy() {
        this.daoMap = null;
    }

    @Override
    public String doFilter(ActionExecutor executor) throws Exception {
        Action action = executor.getAction();
        Method method = executor.getEntryMethod();
        CoupleKey key = new CoupleKey(action.getClass(), method);
        this.checkDaoMap(executor, action, key);
        this.tryInject(action, key);
        return executor.invoke();
    }

    private void checkDaoMap(ActionExecutor executor, Action action, CoupleKey<Class<?>, Method> key) throws Exception {
        if (!this.daoMap.containsKey(key)) {
            ArrayList<DaoAttr> daoAttrList = new ArrayList<DaoAttr>();
            Map<String, DaoBean> daoBeanMap = this.parseDaoBeans(executor, action, key);
            this.parseDaoAttrs(executor, action, daoAttrList, daoBeanMap);
            this.tryPutDaoMap(key, daoAttrList);
        }
    }

    private void parseDaoAttrs(ActionExecutor executor, Action action, List<DaoAttr> daoAttrList, Map<String, DaoBean> daoBeanMap) throws Exception {
        Set<Map.Entry<String, DaoBean>> entries = daoBeanMap.entrySet();
        for (Map.Entry<String, DaoBean> entry : entries) {
            this.parseDaoAttr(executor, action, entry, daoAttrList);
        }
    }

    private void tryInject(Action action, CoupleKey<Class<?>, Method> key) {
        DaoAttr[] daoAttrs = this.daoMap.get(key);
        if (daoAttrs != null) {
            for (DaoAttr daoAttr : daoAttrs) {
                daoAttr.inject(action);
            }
        }
    }

    private void tryPutDaoMap(CoupleKey<Class<?>, Method> key, List<DaoAttr> daoAttrList) {
        DaoAttr[] daoAttrs = daoAttrList.isEmpty() ? null : daoAttrList.toArray(new DaoAttr[daoAttrList.size()]);
        GeneralHelper.syncTryPut(this.daoMap, key, daoAttrs);
    }

    private void parseDaoAttr(ActionExecutor executor, Action action, Map.Entry<String, DaoBean> entry, List<DaoAttr> daoAttrList) throws Exception {
        String name = entry.getKey();
        DaoBean daoBean = entry.getValue();
        String mgrName = daoBean.mgrName();
        Class<? extends AbstractFacade> daoClass = daoBean.daoClass();
        Class<?> actionClass = action.getClass();
        Class stopClass = ActionSupport.class.isAssignableFrom(actionClass) ? ActionSupport.class : Object.class;
        DaoAttr daoAttr = new DaoAttr(name);
        this.parsePropertyOrField(executor, actionClass, stopClass, daoAttr);
        this.parseDaoClass(executor, daoClass, daoAttr);
        this.parseSessionMgr(executor, mgrName, daoAttr);
        daoAttrList.add(daoAttr);
    }

    private Map<String, DaoBean> parseDaoBeans(ActionExecutor executor, Action action, CoupleKey<Class<?>, Method> key) throws Exception {
        HashMap<String, DaoBean> daoBeanMap = new HashMap<String, DaoBean>();
        this.analysisDaoBeans(executor, action, key.getKey2(), daoBeanMap);
        if (daoBeanMap.isEmpty()) {
            this.analysisDaoBeans(executor, action, key.getKey1(), daoBeanMap);
        }
        return daoBeanMap;
    }

    private void parseSessionMgr(ActionExecutor executor, String mgrName, DaoAttr daoAttr) throws Exception {
        if (GeneralHelper.isStrEmpty(mgrName)) {
            daoAttr.mgr = null;
        } else {
            SessionMgr mgr = AppConfig.getSessionManager(mgrName);
            if (mgr != null) {
                daoAttr.mgr = mgr;
            } else {
                DaoInjectFilter.throwParseException(executor, daoAttr.name, String.format("Session Manager named '%s' not found", mgrName));
            }
        }
        if (daoAttr.mgr != null) {
            Class paramClazz;
            Class<? extends AbstractFacade> clazz = daoAttr.daoClass;
            while (clazz.getSuperclass() != AbstractFacade.class) {
                clazz = clazz.getSuperclass();
            }
            Type type = clazz.getGenericSuperclass();
            if (type instanceof ParameterizedType && !(paramClazz = (Class)((ParameterizedType)type).getActualTypeArguments()[0]).isAssignableFrom(daoAttr.mgr.getClass())) {
                String cause = String.format("DAO class (%s) does not match SessionMgr '%s' (%s)", daoAttr.daoClass.getName(), mgrName, daoAttr.mgr.getClass().getName());
                DaoInjectFilter.throwParseException(executor, daoAttr.name, cause);
            }
        }
    }

    private void parseDaoClass(ActionExecutor executor, Class<? extends AbstractFacade> daoClass, DaoAttr daoAttr) throws Exception {
        if (!BeanHelper.isPublicClass(daoClass) || daoClass == AbstractFacade.class) {
            Class<Object> clazz = daoClass = daoAttr.property != null ? daoAttr.property.getPropertyType() : daoAttr.field.getType();
        }
        if (BeanHelper.isPublicClass(daoClass) && daoClass != AbstractFacade.class) {
            daoAttr.daoClass = daoClass;
        } else {
            DaoInjectFilter.throwParseException(executor, daoAttr.name, String.format("Dao Class '%s' can not be instantiated", daoClass.getName()));
        }
    }

    private void parsePropertyOrField(ActionExecutor executor, Class<? extends Action> actionClass, Class<?> stopClass, DaoAttr daoAttr) throws Exception {
        PropertyDescriptor pd = BeanHelper.getPropDescByName(actionClass, stopClass, daoAttr.name);
        Method setter = BeanHelper.getPropertyWriteMethod(pd);
        if (setter != null) {
            if (AbstractFacade.class.isAssignableFrom(pd.getPropertyType())) {
                daoAttr.property = pd;
            } else {
                DaoInjectFilter.throwParseException(executor, daoAttr.name, "invalid type of property");
            }
        } else {
            Field field = BeanHelper.getInstanceFiledByName(actionClass, stopClass, daoAttr.name);
            if (field != null) {
                if (AbstractFacade.class.isAssignableFrom(field.getType())) {
                    daoAttr.field = field;
                } else {
                    DaoInjectFilter.throwParseException(executor, daoAttr.name, "invalid type of field");
                }
            }
        }
        if (daoAttr.property == null && daoAttr.field == null) {
            DaoInjectFilter.throwParseException(executor, null, String.format("no property or field named '%s'", daoAttr.name));
        }
    }

    private void putDaoBeanMap(ActionExecutor executor, Action action, DaoBean daoBean, boolean single, Map<String, DaoBean> daoBeanMap) throws Exception {
        String name = daoBean.value();
        if (GeneralHelper.isStrNotEmpty(name)) {
            GeneralHelper.tryPut(daoBeanMap, name, daoBean);
            return;
        }
        boolean found = false;
        Class<?> clazz = action.getClass();
        Class stopClass = ActionSupport.class.isAssignableFrom(clazz) ? ActionSupport.class : Object.class;
        block0: do {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!AbstractFacade.class.isAssignableFrom(field.getType()) || !BeanHelper.isInstanceNotFinalField(field)) continue;
                found = true;
                name = field.getName();
                GeneralHelper.tryPut(daoBeanMap, name, daoBean);
                if (single) break block0;
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != stopClass);
        if (!found) {
            DaoInjectFilter.throwParseException(executor, null, String.format("%s with default annotation param 'value' can not be deduced exactly", single ? "@DaoBean" : "@DaoBeans"));
        }
    }

    private void analysisDaoBeans(ActionExecutor executor, Action action, AnnotatedElement element, Map<String, DaoBean> daoBeanMap) throws Exception {
        DaoBeans daoBeans;
        DaoBean daoBean = element.getAnnotation(DaoBean.class);
        if (daoBean != null) {
            this.putDaoBeanMap(executor, action, daoBean, true, daoBeanMap);
        }
        if ((daoBeans = element.getAnnotation(DaoBeans.class)) != null) {
            DaoBean[] daoBeanArr;
            for (DaoBean daoBean2 : daoBeanArr = daoBeans.value()) {
                this.putDaoBeanMap(executor, action, daoBean2, false, daoBeanMap);
            }
        }
    }

    private static final void throwParseException(ActionExecutor executor, String name, String cause) throws Exception {
        String msg = GeneralHelper.isStrNotEmpty(name) ? String.format("Parse @DaoBean / @DaoBeans fail '%s#%s()' ['%s'] -> %s", executor.getAction().getClass().getName(), executor.getEntryMethod().getName(), name, cause) : String.format("Parse @DaoBean / @DaoBeans fail '%s#%s()' -> %s", executor.getAction().getClass().getName(), executor.getEntryMethod().getName(), cause);
        throw new RuntimeException(msg);
    }

    private static class DaoAttr {
        String name;
        PropertyDescriptor property;
        Field field;
        Class<? extends AbstractFacade> daoClass;
        SessionMgr mgr;

        public DaoAttr(String name) {
            this.name = name;
        }

        private boolean inject(Action action) {
            AbstractFacade dao = FacadeProxy.create(this.daoClass, this.mgr);
            if (this.property != null) {
                return BeanHelper.setProperty((Object)action, this.property, dao);
            }
            if (this.field != null) {
                return BeanHelper.setFieldValue((Object)action, this.field, dao);
            }
            return false;
        }
    }
}

