/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.dao;

import org.jessma.dao.SessionMgr;
import org.jessma.dao.TransIsoLevel;

public abstract class AbstractSessionMgr<S>
implements SessionMgr<S> {
    protected String configFile;
    protected TransIsoLevel defaultTransIsoLevel;
    protected final ThreadLocal<S> localSession = new ThreadLocal();
    private ThreadLocal<Boolean> invoking = new ThreadLocal();

    protected abstract void loadDefalutTransIsoLevel();

    @Override
    public void unInitialize() {
        this.localSession.remove();
        this.invoking.remove();
    }

    @Override
    public TransIsoLevel getDefalutTransIsoLevel() {
        return this.defaultTransIsoLevel;
    }

    @Override
    public S currentSession() {
        return this.localSession.get();
    }

    @Override
    public String getConfigFile() {
        return this.configFile;
    }

    @Override
    public boolean isInvoking() {
        return Boolean.TRUE == this.invoking.get();
    }

    @Override
    public void setInvoking(boolean value) {
        this.invoking.set(value);
    }
}

