/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.dao;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.jessma.dao.AbstractFacade;
import org.jessma.dao.CustomTransaction;
import org.jessma.dao.DAOException;
import org.jessma.dao.SessionMgr;
import org.jessma.dao.TransIsoLevel;
import org.jessma.dao.Transaction;
import org.jessma.util.BeanHelper;
import org.jessma.util.CoupleKey;
import org.jessma.util.GeneralHelper;

public class FacadeProxy {
    public static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F getAutoCommitProxy(Class<F> daoClass) {
        return FacadeProxy.getProxy(daoClass, true);
    }

    public static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F getAutoCommitProxy(Class<F> daoClass, M mgr) {
        return FacadeProxy.getProxy(daoClass, mgr, true);
    }

    public static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F getManualCommitProxy(Class<F> daoClass) {
        return FacadeProxy.getProxy(daoClass, false);
    }

    public static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F getManualCommitProxy(Class<F> daoClass, M mgr) {
        return FacadeProxy.getProxy(daoClass, mgr, false);
    }

    public static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F getManualCommitProxy(Class<F> daoClass, TransIsoLevel level) {
        return FacadeProxy.getProxy(daoClass, null, false, level);
    }

    public static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F getManualCommitProxy(Class<F> daoClass, M mgr, TransIsoLevel level) {
        return FacadeProxy.getProxy(daoClass, mgr, false, level);
    }

    public static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F getProxy(Class<F> daoClass, boolean autoCommit) {
        return FacadeProxy.getProxy(daoClass, null, autoCommit);
    }

    public static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F getProxy(Class<F> daoClass, M mgr, boolean autoCommit) {
        return FacadeProxy.getProxy(daoClass, mgr, autoCommit, TransIsoLevel.DEFAULT);
    }

    public static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F getProxy(Class<F> daoClass, M mgr, boolean autoCommit, TransIsoLevel level) {
        ProxyInterceptor intercepter = new ProxyInterceptor(autoCommit, level);
        return FacadeProxy.getProxy(daoClass, mgr, (Callback)intercepter);
    }

    private static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F getProxy(Class<F> daoClass, M mgr, Callback intercepter) {
        Object[] objectArray;
        Class[] argTypes;
        Class[] classArray;
        Enhancer en = new Enhancer();
        en.setSuperclass(daoClass);
        en.setCallbackFilter((CallbackFilter)InterceptFilter.INSTANCE);
        Callback[] callbacks = new Callback[]{NoOp.INSTANCE, intercepter};
        en.setCallbacks(callbacks);
        en.setInterceptDuringConstruction(false);
        if (mgr != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = mgr.getClass();
        } else {
            classArray = argTypes = new Class[]{};
        }
        if (mgr != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = mgr;
        } else {
            objectArray = new Object[]{};
        }
        Object[] args = objectArray;
        return (F)((AbstractFacade)en.create(argTypes, args));
    }

    private static final Object intercept(Object dao, Method method, Object[] args, MethodProxy proxy, SessionMgr<?> mgr, boolean autoCommit, TransIsoLevel transLevel) throws Throwable {
        Object result = null;
        if (mgr.isInvoking()) {
            result = proxy.invokeSuper(dao, args);
        } else {
            mgr.setInvoking(true);
            TransIsoLevel defLevel = mgr.getDefalutTransIsoLevel();
            boolean alterTransLevel = !autoCommit && transLevel != TransIsoLevel.DEFAULT && transLevel != defLevel;
            try {
                if (alterTransLevel) {
                    mgr.setSessionTransIsoLevel(transLevel);
                }
                if (!autoCommit) {
                    mgr.beginTransaction();
                }
                result = proxy.invokeSuper(dao, args);
                if (!autoCommit) {
                    mgr.commit();
                }
            }
            catch (Exception e) {
                if (!autoCommit) {
                    try {
                        mgr.rollback();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                throw new DAOException(e);
            }
            finally {
                if (alterTransLevel) {
                    try {
                        mgr.setSessionTransIsoLevel(defLevel);
                    }
                    catch (Exception ex) {}
                }
                try {
                    mgr.closeSession();
                }
                catch (Exception ex) {}
                mgr.setInvoking(false);
            }
        }
        return result;
    }

    public static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F create(Class<F> daoClass) {
        return FacadeProxy.create(daoClass, null);
    }

    public static final <F extends AbstractFacade<M, S>, M extends SessionMgr<S>, S> F create(Class<F> daoClass, M mgr) {
        return FacadeProxy.getProxy(daoClass, mgr, (Callback)ProxyInterceptor2.INSTANCE);
    }

    public static final <M extends SessionMgr<S>, S> void executeCustomTransaction(M mgr, CustomTransaction<M, S> trans) throws DAOException {
        FacadeProxy.executeCustomTransaction(mgr, TransIsoLevel.DEFAULT, trans);
    }

    public static final <M extends SessionMgr<S>, S> void executeCustomTransaction(M mgr, TransIsoLevel level, CustomTransaction<M, S> trans) throws DAOException {
        if (mgr.isInvoking()) {
            trans.execute(mgr);
        } else {
            mgr.setInvoking(true);
            TransIsoLevel defLevel = mgr.getDefalutTransIsoLevel();
            boolean alterTransLevel = level != TransIsoLevel.DEFAULT && level != defLevel;
            try {
                if (alterTransLevel) {
                    mgr.setSessionTransIsoLevel(level);
                }
                mgr.beginTransaction();
                trans.execute(mgr);
                mgr.commit();
            }
            catch (Exception e) {
                try {
                    mgr.rollback();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new DAOException(e);
            }
            finally {
                if (alterTransLevel) {
                    try {
                        mgr.setSessionTransIsoLevel(defLevel);
                    }
                    catch (Exception ex) {}
                }
                try {
                    mgr.closeSession();
                }
                catch (Exception ex) {}
                mgr.setInvoking(false);
            }
        }
    }

    private static class ProxyInterceptor2
    implements MethodInterceptor {
        private static final ProxyInterceptor2 INSTANCE = new ProxyInterceptor2();
        private static final Map<CoupleKey<Class<?>, Method>, TransAttr> TRANS_ATTR_MAP = new HashMap();

        private ProxyInterceptor2() {
        }

        public final Object intercept(Object dao, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            AbstractFacade facade = (AbstractFacade)dao;
            Object mgr = facade.getManager();
            if (mgr.isInvoking()) {
                return proxy.invokeSuper(dao, args);
            }
            Class<?> superClass = dao.getClass().getSuperclass();
            CoupleKey key = new CoupleKey(superClass, method);
            ProxyInterceptor2.checkTransAttrMap(key);
            TransAttr transAttr = TRANS_ATTR_MAP.get(key);
            return FacadeProxy.intercept(dao, method, args, proxy, mgr, transAttr.autoCommit, transAttr.transLevel);
        }

        private static final void checkTransAttrMap(CoupleKey<Class<?>, Method> key) {
            if (!TRANS_ATTR_MAP.containsKey(key)) {
                TransAttr transAttr = null;
                Transaction trans = key.getKey2().getAnnotation(Transaction.class);
                if (trans == null) {
                    trans = key.getKey1().getAnnotation(Transaction.class);
                }
                transAttr = trans == null ? TransAttr.DEFAULT : new TransAttr(!trans.value(), trans.level());
                GeneralHelper.syncTryPut(TRANS_ATTR_MAP, key, transAttr);
            }
        }
    }

    private static class TransAttr {
        private static final TransAttr DEFAULT = new TransAttr();
        private boolean autoCommit;
        private TransIsoLevel transLevel;

        private TransAttr() {
            this(false, TransIsoLevel.DEFAULT);
        }

        private TransAttr(boolean autoCommit, TransIsoLevel transLevel) {
            this.autoCommit = autoCommit;
            this.transLevel = transLevel;
        }
    }

    private static class ProxyInterceptor
    implements MethodInterceptor {
        private TransAttr transAttr;

        private ProxyInterceptor(boolean autoCommit, TransIsoLevel transLevel) {
            this.transAttr = new TransAttr(autoCommit, transLevel);
        }

        public final Object intercept(Object dao, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            AbstractFacade facade = (AbstractFacade)dao;
            Object mgr = facade.getManager();
            if (mgr.isInvoking()) {
                return proxy.invokeSuper(dao, args);
            }
            return FacadeProxy.intercept(dao, method, args, proxy, mgr, this.transAttr.autoCommit, this.transAttr.transLevel);
        }
    }

    private static class InterceptFilter
    implements CallbackFilter {
        private static final InterceptFilter INSTANCE = new InterceptFilter();
        private static final Set<Method> FILTER_METHODS = BeanHelper.getAllMethods(AbstractFacade.class);

        private InterceptFilter() {
        }

        public final int accept(Method method) {
            if (FILTER_METHODS.contains(method)) {
                return 0;
            }
            return 1;
        }
    }
}

