/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.dao.hbn;

import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import javax.persistence.Entity;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.jdbc.Work;
import org.jessma.dao.AbstractSessionMgr;
import org.jessma.dao.TransIsoLevel;
import org.jessma.util.BeanHelper;
import org.jessma.util.GeneralHelper;
import org.jessma.util.PackageHelper;

public class HibernateSessionMgr
extends AbstractSessionMgr<Session> {
    public static final String DEFAULT_CONFIG_FILE = "hibernate.cfg.xml";
    private SessionFactory sessionFactory;
    private String pattern;

    @Override
    public void initialize(String ... args) {
        if (args.length == 0) {
            this.initialize();
        } else if (args.length == 1) {
            this.initialize(args[0]);
        } else if (args.length == 2) {
            this.initialize(args[0], args[1]);
        } else {
            throw new InvalidParameterException("HibernateSessionMgr initialize fail (invalid paramers)");
        }
    }

    public void initialize() {
        this.initialize(DEFAULT_CONFIG_FILE);
    }

    public void initialize(String hbn_cfg_file) {
        this.initialize(hbn_cfg_file, (String)null);
    }

    public void initialize(String hbn_cfg_file, String packages) {
        this.configFile = GeneralHelper.isStrNotEmpty(hbn_cfg_file) ? hbn_cfg_file : DEFAULT_CONFIG_FILE;
        this.pattern = packages;
        try {
            this.loadDefalutTransIsoLevel();
        }
        catch (HibernateException e) {
            this.unInitialize();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unInitialize() {
        if (this.sessionFactory != null) {
            HibernateSessionMgr hibernateSessionMgr = this;
            synchronized (hibernateSessionMgr) {
                if (this.sessionFactory != null) {
                    this.sessionFactory.close();
                    this.sessionFactory = null;
                    super.unInitialize();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadDefalutTransIsoLevel() {
        try {
            Session session = this.getSession();
            session.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    int level = connection.getTransactionIsolation();
                    HibernateSessionMgr.this.defaultTransIsoLevel = TransIsoLevel.fromInt(level);
                }
            });
        }
        finally {
            this.closeSession();
        }
    }

    @Override
    public void setSessionTransIsoLevel(final TransIsoLevel level) {
        Session session = this.getSession();
        session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                connection.setTransactionIsolation(level.toInt());
            }
        });
    }

    @Override
    public String getConfigFile() {
        return this.configFile;
    }

    public final SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Session getSession() {
        Session session = (Session)this.localSession.get();
        if (session == null || !session.isOpen()) {
            if (this.sessionFactory == null) {
                HibernateSessionMgr hibernateSessionMgr = this;
                synchronized (hibernateSessionMgr) {
                    if (this.sessionFactory == null) {
                        this.sessionFactory = this.buildSessionFactory();
                    }
                }
            }
            session = this.sessionFactory.openSession();
            this.localSession.set(session);
        }
        return session;
    }

    protected SessionFactory buildSessionFactory() {
        Configuration cfg = new Configuration();
        if (GeneralHelper.isStrNotEmpty(this.pattern)) {
            Set<String> packages = PackageHelper.getPackages(this.pattern);
            for (String pkg : packages) {
                Set<Class<?>> entities = PackageHelper.getClasses(pkg, false, new PackageHelper.ClassFilter(){

                    @Override
                    public boolean accept(Class<?> clazz) {
                        if (!BeanHelper.isPublicNotAbstractClass(clazz)) {
                            return false;
                        }
                        return clazz.getAnnotation(Entity.class) != null;
                    }
                });
                for (Class<?> clazz : entities) {
                    cfg.addAnnotatedClass(clazz);
                }
            }
        }
        return cfg.configure(this.configFile).buildSessionFactory();
    }

    @Override
    public final void closeSession() {
        Session session = (Session)this.localSession.get();
        this.localSession.set(null);
        if (session != null) {
            session.close();
        }
    }

    public final Transaction getTransaction() {
        Session session = this.getSession();
        return session != null ? session.getTransaction() : null;
    }

    @Override
    public final void beginTransaction() {
        Transaction trans = this.getTransaction();
        if (trans != null) {
            trans.begin();
        }
    }

    @Override
    public final void commit() {
        Transaction trans = this.getTransaction();
        if (trans != null) {
            trans.commit();
        }
    }

    @Override
    public final void rollback() {
        Transaction trans = this.getTransaction();
        if (trans != null) {
            trans.rollback();
        }
    }
}

