/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.dao.jdbc;

import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.SQLException;
import org.jessma.dao.AbstractSessionMgr;
import org.jessma.dao.TransIsoLevel;
import org.jessma.dao.jdbc.JdbcException;
import org.jessma.util.GeneralHelper;

public abstract class AbstractJdbcSessionMgr
extends AbstractSessionMgr<Connection> {
    protected abstract String getDefaultConfigFile();

    protected abstract Connection getInternalConnection() throws SQLException;

    @Override
    protected void loadDefalutTransIsoLevel() {
        try {
            Connection session = this.getSession();
            int level = session.getTransactionIsolation();
            this.defaultTransIsoLevel = TransIsoLevel.fromInt(level);
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
        finally {
            this.closeSession();
        }
    }

    @Override
    public void setSessionTransIsoLevel(TransIsoLevel level) {
        try {
            Connection session = this.getSession();
            session.setTransactionIsolation(level.toInt());
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    @Override
    public void beginTransaction() {
        Connection session = this.getSession();
        if (session != null) {
            try {
                session.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
        }
    }

    @Override
    public void commit() {
        Connection session = this.getSession();
        if (session != null) {
            try {
                session.commit();
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
            finally {
                try {
                    session.setAutoCommit(true);
                }
                catch (SQLException ex) {}
            }
        }
    }

    @Override
    public void rollback() {
        Connection session = this.getSession();
        if (session != null) {
            try {
                session.rollback();
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
            finally {
                try {
                    session.setAutoCommit(true);
                }
                catch (SQLException ex) {}
            }
        }
    }

    @Override
    public final Connection getSession() {
        Connection session = (Connection)this.localSession.get();
        try {
            if (session == null || session.isClosed()) {
                session = this.getInternalConnection();
                this.localSession.set(session);
            }
        }
        catch (SQLException e) {
            this.localSession.set(null);
            throw new JdbcException(e);
        }
        return session;
    }

    @Override
    public void closeSession() {
        Connection session = (Connection)this.localSession.get();
        this.localSession.set(null);
        if (session != null) {
            try {
                session.close();
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
        }
    }

    protected void parseConfigFile(String configFile) throws FileNotFoundException {
        this.configFile = GeneralHelper.getClassResourcePath(AbstractJdbcSessionMgr.class, GeneralHelper.isStrNotEmpty(configFile) ? configFile : this.getDefaultConfigFile());
        if (this.configFile == null) {
            throw new FileNotFoundException(String.format("config file '%s' not found", configFile));
        }
    }

    protected boolean isXmlConfigFile() {
        String suffix;
        String PROPS_FILE_SUFFIX = ".properties";
        int index = this.configFile.lastIndexOf(46);
        return index == -1 || !(suffix = this.configFile.substring(index)).equalsIgnoreCase(".properties");
    }
}

