/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.dao.jdbc;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jessma.dao.jdbc.AbstractJdbcSessionMgr;
import org.jessma.dao.jdbc.JdbcException;
import org.jessma.util.GeneralHelper;

public class DruidSessionMgr
extends AbstractJdbcSessionMgr {
    public static final String DEFAULT_CONFIG_FILE = "druid.cfg.xml";
    private DruidDataSource dataSource;

    @Override
    protected String getDefaultConfigFile() {
        return DEFAULT_CONFIG_FILE;
    }

    @Override
    public void initialize(String ... args) {
        if (args.length == 0) {
            this.initialize();
        } else if (args.length == 1) {
            this.initialize(args[0]);
        } else {
            throw new InvalidParameterException("DruidSessionMgr initialize fail (invalid paramers)");
        }
    }

    public void initialize() {
        this.initialize(DEFAULT_CONFIG_FILE);
    }

    public void initialize(String configFile) {
        try {
            this.parseConfigFile(configFile);
            Properties props = new Properties();
            if (this.isXmlConfigFile()) {
                this.loadXmlCfg(props);
            } else {
                this.loadPropCfg(props);
            }
            props = this.filtrateCfg(props);
            this.dataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)props);
            this.loadDefalutTransIsoLevel();
        }
        catch (Exception e) {
            try {
                this.unInitialize();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new JdbcException(e);
        }
    }

    private void loadXmlCfg(Properties props) throws Exception {
        SAXReader sr = new SAXReader();
        Document doc = sr.read(new File(this.configFile));
        Element root = doc.getRootElement();
        List list = root.elements("property");
        for (Element e : list) {
            String key = e.attributeValue("name");
            String value = e.getTextTrim();
            props.put(key, value);
        }
    }

    private void loadPropCfg(Properties props) throws IOException {
        props.load(new FileInputStream(this.configFile));
    }

    private Properties filtrateCfg(Properties props) {
        Properties result = new Properties();
        Set<Map.Entry<Object, Object>> set = props.entrySet();
        for (Map.Entry<Object, Object> e : set) {
            String value = GeneralHelper.safeTrimString((String)e.getValue());
            if (!GeneralHelper.isStrNotEmpty(value)) continue;
            result.put(e.getKey(), value);
        }
        return result;
    }

    @Override
    public void unInitialize() {
        try {
            if (this.dataSource != null) {
                this.dataSource.close();
            }
        }
        catch (Exception e) {
            throw new JdbcException(String.format("DruidSessionMgr uninitialize fail (%s)", e));
        }
        finally {
            super.unInitialize();
        }
    }

    @Override
    protected Connection getInternalConnection() throws SQLException {
        return this.dataSource.getConnection();
    }
}

