/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.dao.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jessma.dao.AbstractFacade;
import org.jessma.dao.jdbc.AbstractJdbcSessionMgr;
import org.jessma.dao.jdbc.JdbcException;
import org.jessma.dao.jdbc.JdbcUtil;
import org.jessma.util.KV;

public abstract class JdbcFacade
extends AbstractFacade<AbstractJdbcSessionMgr, Connection> {
    protected JdbcFacade(AbstractJdbcSessionMgr mgr) {
        super(mgr);
    }

    protected List<Object[]> query(String sql, Object ... params) {
        return this.query(false, sql, params);
    }

    protected List<Object[]> query(boolean isCallable, String sql, Object ... params) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        ResultSet rs = null;
        PreparedStatement pst = null;
        try {
            Connection conn = (Connection)this.getSession();
            pst = JdbcUtil.prepareStatement(conn, sql, isCallable);
            JdbcUtil.setParameters(pst, params);
            rs = pst.executeQuery();
            int cols = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                Object[] objs = new Object[cols];
                for (int i = 0; i < cols; ++i) {
                    objs[i] = rs.getObject(i + 1);
                }
                result.add(objs);
            }
        }
        catch (SQLException e) {
            try {
                throw new JdbcException(e);
            }
            catch (Throwable throwable) {
                JdbcUtil.closeSqlObject(pst, rs);
                throw throwable;
            }
        }
        JdbcUtil.closeSqlObject(pst, rs);
        return result;
    }

    protected boolean call(String sql, Object ... inParams) {
        return this.call(1, new int[0], sql, inParams).getKey();
    }

    protected KV<Boolean, Object> call(int outParamPos, int outParaType, String sql, Object ... inParams) {
        KV<Boolean, Object[]> keys = this.call(outParamPos, new int[]{outParaType}, sql, inParams);
        Object[] values = keys.getValue();
        Object value = values != null && values.length > 0 ? values[0] : null;
        return new KV<Boolean, Object>(keys.getKey(), value);
    }

    protected KV<Boolean, Object[]> call(int outParamStartPos, int[] outParamTypes, String sql, Object ... inParams) {
        KV<Boolean, Object[]> result = new KV<Boolean, Object[]>();
        ResultSet rs = null;
        CallableStatement cst = null;
        try {
            Connection conn = (Connection)this.getSession();
            cst = (CallableStatement)JdbcUtil.prepareStatement(conn, sql, true);
            int inputParameterStartPosition = outParamStartPos == 1 ? outParamStartPos + outParamTypes.length : 1;
            JdbcUtil.setInputParameters(cst, inputParameterStartPosition, inParams);
            JdbcUtil.registerOutputParameters(cst, outParamStartPos, outParamTypes);
            result.setKey(cst.execute());
            if (((Boolean)result.getKey()).booleanValue() && outParamTypes.length > 0 && (rs = cst.getResultSet()).next()) {
                Object[] objs = new Object[outParamTypes.length];
                for (int i = 0; i < objs.length; ++i) {
                    objs[i] = rs.getObject(i + outParamStartPos);
                }
                result.setValue(objs);
            }
        }
        catch (SQLException e) {
            try {
                throw new JdbcException(e);
            }
            catch (Throwable throwable) {
                JdbcUtil.closeSqlObject(cst, rs);
                throw throwable;
            }
        }
        JdbcUtil.closeSqlObject(cst, rs);
        return result;
    }

    protected int update(String sql, Object ... params) {
        return this.update(false, sql, params);
    }

    protected int update(boolean isCallable, String sql, Object ... params) {
        int effect = 0;
        PreparedStatement pst = null;
        try {
            Connection conn = (Connection)this.getSession();
            pst = JdbcUtil.prepareStatement(conn, sql, isCallable);
            JdbcUtil.setParameters(pst, params);
            effect = pst.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new JdbcException(e);
            }
            catch (Throwable throwable) {
                JdbcUtil.closeSqlObject(pst);
                throw throwable;
            }
        }
        JdbcUtil.closeSqlObject(pst);
        return effect;
    }

    protected KV<Integer, List<Object>> updateAndGenerateKeys(String sql, Object ... params) {
        KV<Integer, List<Object[]>> keys = this.updateAndGenerateKeys(null, sql, params);
        List<Object[]> values = keys.getValue();
        KV<Integer, Object> result = new KV<Integer, Object>(keys.getKey(), null);
        if (values != null && values.size() > 0) {
            ArrayList<Object> v = new ArrayList<Object>();
            result.setValue(v);
            for (Object[] objs : values) {
                v.add(objs[0]);
            }
        }
        return result;
    }

    protected KV<Integer, List<Object[]>> updateAndGenerateKeys(int[] keyColIndexes, String sql, Object ... params) {
        KV<Integer, List<Object[]>> result = new KV<Integer, List<Object[]>>();
        ResultSet rs = null;
        PreparedStatement pst = null;
        try {
            Connection conn = (Connection)this.getSession();
            pst = keyColIndexes == null ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql, keyColIndexes);
            JdbcUtil.setParameters(pst, params);
            result.setKey(pst.executeUpdate());
            if ((Integer)result.getKey() > 0) {
                ArrayList<Object[]> value = new ArrayList<Object[]>();
                result.setValue(value);
                rs = pst.getGeneratedKeys();
                while (rs.next()) {
                    if (keyColIndexes == null) {
                        value.add(new Object[]{rs.getObject(1)});
                        continue;
                    }
                    Object[] keys = new Object[keyColIndexes.length];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = rs.getObject(i + 1);
                    }
                    value.add(keys);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new JdbcException(e);
            }
            catch (Throwable throwable) {
                JdbcUtil.closeSqlObject(pst, rs);
                throw throwable;
            }
        }
        JdbcUtil.closeSqlObject(pst, rs);
        return result;
    }

    protected int[] updateBatch(String sql, List<Object[]> params) {
        return this.updateBatch(false, sql, params);
    }

    protected int[] updateBatch(boolean isCallable, String sql, List<Object[]> params) {
        return this.updateBatch(isCallable, sql, params, 0);
    }

    protected int[] updateBatch(String sql, List<Object[]> params, int batchSize) {
        return this.updateBatch(false, sql, params, batchSize);
    }

    protected int[] updateBatch(boolean isCallable, String sql, List<Object[]> params, int batchSize) {
        PreparedStatement pst = null;
        int i = 0;
        int start = 0;
        int size = params.size();
        int[] effect = new int[size];
        if (size == 0) {
            return effect;
        }
        if (batchSize <= 0) {
            batchSize = size;
        }
        try {
            Connection conn = (Connection)this.getSession();
            pst = JdbcUtil.prepareStatement(conn, sql, isCallable);
            while (i < size) {
                Object[] objects = params.get(i);
                JdbcUtil.setParameters(pst, objects);
                pst.addBatch();
                if (++i % batchSize != 0) continue;
                System.arraycopy(pst.executeBatch(), 0, effect, start, i - start);
                pst.clearBatch();
                start = i;
            }
            if (i % batchSize != 0) {
                System.arraycopy(pst.executeBatch(), 0, effect, start, i - start);
            }
        }
        catch (SQLException e) {
            try {
                throw new JdbcException(e);
            }
            catch (Throwable throwable) {
                JdbcUtil.closeSqlObject(pst);
                throw throwable;
            }
        }
        JdbcUtil.closeSqlObject(pst);
        return effect;
    }
}

