/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.dao.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jessma.dao.jdbc.JdbcException;

public class JdbcUtil {
    public static final void closeSqlObject(Object ... sqlObjs) {
        try {
            for (Object obj : sqlObjs) {
                if (obj == null) continue;
                if (obj instanceof Connection) {
                    ((Connection)obj).close();
                    continue;
                }
                if (obj instanceof Statement) {
                    ((Statement)obj).close();
                    continue;
                }
                if (!(obj instanceof ResultSet)) continue;
                ((ResultSet)obj).close();
            }
        }
        catch (SQLException e) {
            throw new JdbcException(e);
        }
    }

    public static final PreparedStatement prepareStatement(Connection conn, String sql, boolean isCallable) throws SQLException {
        if (!isCallable) {
            return conn.prepareStatement(sql);
        }
        return conn.prepareCall(sql);
    }

    public static final void setParameters(PreparedStatement pst, Object ... params) throws SQLException {
        JdbcUtil.setInputParameters(pst, 1, params);
    }

    public static final void setInputParameters(PreparedStatement pst, int startPos, Object ... params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            Object o = params[i];
            if (o != null) {
                pst.setObject(i + startPos, o);
                continue;
            }
            pst.setNull(i + startPos, 0);
        }
    }

    public static final void registerOutputParameters(CallableStatement cst, int startPos, int[] types) throws SQLException {
        for (int i = 0; i < types.length; ++i) {
            int t = types[i];
            cst.registerOutParameter(i + startPos, t);
        }
    }
}

