/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.dao.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jessma.dao.jdbc.AbstractJdbcSessionMgr;
import org.jessma.dao.jdbc.JdbcException;
import org.jessma.util.GeneralHelper;

public class JndiSessionMgr
extends AbstractJdbcSessionMgr {
    public static final String DEFAULT_CONFIG_FILE = "jndi.cfg.xml";
    private static final String JNDI_NAME_KEY = "jndi-name";
    private String jndiName;
    private DataSource dataSource;

    @Override
    protected String getDefaultConfigFile() {
        return DEFAULT_CONFIG_FILE;
    }

    @Override
    public void initialize(String ... args) {
        if (args.length == 0) {
            this.initialize();
        } else if (args.length == 1) {
            this.initialize(args[0]);
        } else {
            throw new InvalidParameterException("JndiSessionMgr initialize fail (invalid paramers)");
        }
    }

    public void initialize() {
        this.initialize(DEFAULT_CONFIG_FILE);
    }

    public void initialize(String configFile) {
        Context ctx = null;
        try {
            this.parseConfigFile(configFile);
            Properties props = new Properties();
            if (this.isXmlConfigFile()) {
                this.loadXmlCfg(props);
            } else {
                this.loadPropCfg(props);
            }
            props = this.filtrateCfg(props);
            ctx = new InitialContext(props);
            this.dataSource = (DataSource)ctx.lookup(this.jndiName);
            this.loadDefalutTransIsoLevel();
        }
        catch (Exception e) {
            try {
                this.unInitialize();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new JdbcException(e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void loadXmlCfg(Properties props) throws Exception {
        SAXReader sr = new SAXReader();
        Document doc = sr.read(new File(this.configFile));
        Element root = doc.getRootElement();
        this.jndiName = root.attributeValue(JNDI_NAME_KEY);
        if (GeneralHelper.isStrEmpty(this.jndiName)) {
            throw new RuntimeException(String.format("'%s' attribute must be set for 'root' element", JNDI_NAME_KEY));
        }
        List list = root.elements("property");
        for (Element e : list) {
            String key = e.attributeValue("name");
            String value = e.getTextTrim();
            props.put(key, value);
        }
    }

    private void loadPropCfg(Properties props) throws IOException {
        props.load(new FileInputStream(this.configFile));
        this.jndiName = props.getProperty(JNDI_NAME_KEY);
        if (GeneralHelper.isStrEmpty(this.jndiName)) {
            throw new RuntimeException(String.format("'%s' protperty must be set", JNDI_NAME_KEY));
        }
        props.remove(JNDI_NAME_KEY);
    }

    private Properties filtrateCfg(Properties props) {
        Properties result = new Properties();
        Set<Map.Entry<Object, Object>> set = props.entrySet();
        for (Map.Entry<Object, Object> e : set) {
            String value = GeneralHelper.safeTrimString((String)e.getValue());
            if (!GeneralHelper.isStrNotEmpty(value)) continue;
            result.put(e.getKey(), value);
        }
        return result;
    }

    @Override
    public void unInitialize() {
        this.dataSource = null;
        super.unInitialize();
    }

    @Override
    protected Connection getInternalConnection() throws SQLException {
        return this.dataSource.getConnection();
    }
}

