/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.dao.jdbc;

import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.jessma.dao.jdbc.AbstractJdbcSessionMgr;
import org.jessma.dao.jdbc.JdbcException;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;

public class ProxoolSessionMgr
extends AbstractJdbcSessionMgr {
    public static final String PROXOOL_PREFIX = "proxool.";
    public static final String DEFAULT_CONFIG_FILE = "proxool.xml";
    public static final String DEFAULT_CONNECTION_ID = "proxool.jessma";
    private String connectionId;

    @Override
    protected String getDefaultConfigFile() {
        return DEFAULT_CONFIG_FILE;
    }

    @Override
    public void initialize(String ... args) {
        if (args.length == 0) {
            this.initialize();
        } else if (args.length == 1) {
            this.initialize(args[0]);
        } else if (args.length == 2) {
            this.initialize(args[0], args[1]);
        } else {
            throw new InvalidParameterException("ProxoolSessionMgr initialize fail (invalid paramers)");
        }
    }

    public void initialize() {
        this.initialize(DEFAULT_CONFIG_FILE);
    }

    public void initialize(String connectionId) {
        this.initialize(connectionId, DEFAULT_CONNECTION_ID);
    }

    public void initialize(String connectionId, String configFile) {
        try {
            if (connectionId != null) {
                if (!connectionId.startsWith(PROXOOL_PREFIX)) {
                    connectionId = PROXOOL_PREFIX + connectionId;
                }
                this.connectionId = connectionId;
            } else {
                this.connectionId = DEFAULT_CONNECTION_ID;
            }
            this.parseConfigFile(configFile);
            if (this.isXmlConfigFile()) {
                JAXPConfigurator.configure((String)this.configFile, (boolean)false);
            } else {
                PropertyConfigurator.configure((String)this.configFile);
            }
            this.loadDefalutTransIsoLevel();
        }
        catch (Exception e) {
            try {
                this.unInitialize();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new JdbcException(e);
        }
    }

    @Override
    public void unInitialize() {
        try {
            int length = ProxoolFacade.getAliases().length;
            if (length == 1) {
                ProxoolFacade.shutdown((int)0);
            } else if (length > 1) {
                String pool = this.connectionId.replaceFirst(PROXOOL_PREFIX, "");
                ProxoolFacade.removeConnectionPool((String)pool);
            }
        }
        catch (ProxoolException e) {
            throw new JdbcException(String.format("ProxoolSessionMgr uninitialize fail (%s)", new Object[]{e}));
        }
        finally {
            super.unInitialize();
        }
    }

    @Override
    protected Connection getInternalConnection() throws SQLException {
        return DriverManager.getConnection(this.connectionId);
    }
}

