/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.dao.mybatis;

import java.io.IOException;
import java.io.Reader;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionException;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.jessma.dao.AbstractSessionMgr;
import org.jessma.dao.TransIsoLevel;
import org.jessma.util.BeanHelper;
import org.jessma.util.GeneralHelper;
import org.jessma.util.PackageHelper;

public class MyBatisSessionMgr
extends AbstractSessionMgr<SqlSession> {
    public static final String DEFAULT_CONFIG_FILE = "mybatis.cfg.xml";
    public static final String DEFAULT_ENVIRONMENT = null;
    private String environment = DEFAULT_ENVIRONMENT;
    private SqlSessionFactory sessionFactory;
    private String pattern;
    private final ThreadLocal<Boolean> localAutoCommit = new ThreadLocal();
    private final ThreadLocal<ExecutorType> localExecutorType = new ThreadLocal();

    @Override
    public void initialize(String ... args) {
        if (args.length == 0) {
            this.initialize();
        } else if (args.length == 1) {
            this.initialize(args[0]);
        } else if (args.length == 2) {
            this.initialize(args[0], args[1]);
        } else if (args.length == 3) {
            this.initialize(args[0], args[1], args[2]);
        } else {
            throw new InvalidParameterException("MyBatisSessionMgr initialize fail (invalid paramers)");
        }
    }

    public void initialize() {
        this.initialize(DEFAULT_CONFIG_FILE);
    }

    public void initialize(String mybatis_cfg_file) {
        this.initialize(mybatis_cfg_file, DEFAULT_ENVIRONMENT);
    }

    public void initialize(String mybatis_cfg_file, String env) {
        this.initialize(mybatis_cfg_file, env, (String)null);
    }

    public void initialize(String mybatis_cfg_file, String env, String packages) {
        this.configFile = GeneralHelper.isStrNotEmpty(mybatis_cfg_file) ? mybatis_cfg_file : DEFAULT_CONFIG_FILE;
        this.environment = GeneralHelper.isStrNotEmpty(env) ? env : DEFAULT_ENVIRONMENT;
        this.pattern = packages;
        try {
            this.loadDefalutTransIsoLevel();
        }
        catch (SqlSessionException e) {
            this.unInitialize();
            throw e;
        }
    }

    @Override
    public void unInitialize() {
        this.sessionFactory = null;
        super.unInitialize();
    }

    @Override
    protected void loadDefalutTransIsoLevel() {
        try {
            SqlSession session = this.getSession();
            Connection conn = session.getConnection();
            int level = conn.getTransactionIsolation();
            this.defaultTransIsoLevel = TransIsoLevel.fromInt(level);
        }
        catch (SQLException e) {
            throw new SqlSessionException((Throwable)e);
        }
        finally {
            this.closeSession();
        }
    }

    @Override
    public void setSessionTransIsoLevel(TransIsoLevel level) {
        try {
            SqlSession session = this.getSession();
            Connection conn = session.getConnection();
            conn.setTransactionIsolation(level.toInt());
        }
        catch (SQLException e) {
            throw new SqlSessionException((Throwable)e);
        }
    }

    @Override
    public final SqlSession getSession() {
        return this.getSession(true);
    }

    public final SqlSession getSession(boolean autoCommit) {
        return this.getSession(null, autoCommit);
    }

    public final SqlSession getSession(ExecutorType type, boolean autoCommit) {
        SqlSession session = (SqlSession)this.localSession.get();
        if (session == null) {
            if (this.sessionFactory == null) {
                this.buildSessionFactory();
            }
            if (type == null && (type = this.localExecutorType.get()) == null) {
                type = this.getDefaultExecutorType();
            }
            session = this.sessionFactory.openSession(type, autoCommit);
            this.localSession.set(session);
            this.localAutoCommit.set(autoCommit);
            this.localExecutorType.set(type);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSessionFactory() {
        MyBatisSessionMgr myBatisSessionMgr = this;
        synchronized (myBatisSessionMgr) {
            if (this.sessionFactory == null) {
                try {
                    Reader reader = Resources.getResourceAsReader((String)this.configFile);
                    this.sessionFactory = new SqlSessionFactoryBuilder().build(reader, this.environment);
                    if (GeneralHelper.isStrNotEmpty(this.pattern)) {
                        Set<String> packages = PackageHelper.getPackages(this.pattern);
                        for (String pkg : packages) {
                            Set<Class<?>> entities = PackageHelper.getClasses(pkg, false, new PackageHelper.ClassFilter(){

                                @Override
                                public boolean accept(Class<?> clazz) {
                                    return BeanHelper.isPublicInterface(clazz);
                                }
                            });
                            Configuration cfg = this.sessionFactory.getConfiguration();
                            for (Class<?> clazz : entities) {
                                if (cfg.hasMapper(clazz)) continue;
                                cfg.addMapper(clazz);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new SqlSessionException((Throwable)e);
                }
            }
        }
    }

    public void changeSessionExecutorType(ExecutorType type) {
        SqlSession session = (SqlSession)this.localSession.get();
        if (session == null) {
            this.localExecutorType.set(type);
        } else {
            ExecutorType currentType;
            if (type == null) {
                type = this.getDefaultExecutorType();
            }
            if (type != (currentType = this.localExecutorType.get())) {
                SqlSession newSession = this.sessionFactory.openSession(type, session.getConnection());
                session.clearCache();
                this.localSession.set(newSession);
                this.localExecutorType.set(type);
            }
        }
    }

    @Override
    public final void closeSession() {
        SqlSession session = (SqlSession)this.localSession.get();
        this.localSession.set(null);
        this.localAutoCommit.set(null);
        this.localExecutorType.set(null);
        if (session != null) {
            session.close();
        }
    }

    @Override
    public final void beginTransaction() {
        this.getSession(false);
    }

    @Override
    public final void commit() {
        this.commit(true);
    }

    public final void commit(boolean force) {
        SqlSession session = (SqlSession)this.localSession.get();
        if (session != null) {
            session.commit(force);
        }
    }

    @Override
    public final void rollback() {
        this.rollback(true);
    }

    public final void rollback(boolean force) {
        SqlSession session = (SqlSession)this.localSession.get();
        if (session != null) {
            session.rollback(force);
        }
    }

    public final SqlSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public final Configuration getConfiguration() {
        return this.sessionFactory.getConfiguration();
    }

    public final ExecutorType getDefaultExecutorType() {
        return this.getConfiguration().getDefaultExecutorType();
    }

    public final Connection getConnection() {
        Connection conn = null;
        SqlSession session = (SqlSession)this.localSession.get();
        if (session != null) {
            conn = session.getConnection();
        }
        return conn;
    }
}

