/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.mvc;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jessma.mvc.Action;
import org.jessma.mvc.ActionExecutor;
import org.jessma.mvc.ActionFilter;
import org.jessma.mvc.ActionSupport;
import org.jessma.mvc.BeanValidator;
import org.jessma.mvc.ExceptionMapping;
import org.jessma.mvc.ExceptionMappings;
import org.jessma.mvc.FormBean;
import org.jessma.mvc.Result;
import org.jessma.mvc.Results;
import org.jessma.util.BeanHelper;
import org.jessma.util.GeneralHelper;
import org.jessma.util.http.HttpHelper;

public class ActionDispatcher
implements Filter {
    static final String PATH_SEPARATOR = "/";
    static final String CURRENT_PATH_PREFIX = "./";
    private static final String GLOBAL_KEY = "global";
    private static final String INCLUDE_KEY = "include";
    private static final String INCLUDE_FILE_KEY = "file";
    private static final String ACTIONS_KEY = "actions";
    private static final String ACTIONS_PATH_KEY = "path";
    private static final String ACTION_ENTRY_SEPARATOR = "!";
    private static final String ACTION_KEY = "action";
    private static final String ACTION_NAME_KEY = "name";
    private static final String ACTION_CLASS_KEY = "class";
    private static final String ACTION_ENTRY_KEY = "entry";
    private static final String ACTION_ENTRY_NAME_KEY = "name";
    private static final String ACTION_ENTRY_METHOD_KEY = "method";
    private static final String RESULT_KEY = "result";
    private static final String RESULT_TYPE_KEY = "type";
    private static final String RESULT_NAME_KEY = "name";
    private static final String ACTION_DEFAULT_ENTRY_METHOD = "execute";
    private static final String CONFIG_FILE_KEY = "mvc-config-file";
    private static final String DEFAULT_CONFIG_FILE = "mvc-config.xml";
    private static final String ACTION_SUFFIX_KEY = "action-suffix";
    private static final String BASE_PATH_KEY = "base-path";
    private static final String BASE_PATH_TYPE_KEY = "type";
    private static final String BASE_PATH_HREF_KEY = "href";
    private static final String SUFFIX_CHARACTER = ".";
    private static final String DEFAULT_ACTION_SUFFIX = ".action";
    private static final String I18N_KEY = "i18n";
    private static final String I18N_DEF_LOCALE_KEY = "default-locale";
    private static final String I18N_DEF_BUNDLE_KEY = "default-bundle";
    private static final String BEAN_VLD_KEY = "bean-validation";
    private static final String BEAN_VLD_ENABLE_KEY = "enable";
    private static final String BEAN_VLD_BUNDLE_KEY = "bundle";
    private static final String BEAN_VLD_VALIDATOR_KEY = "validator";
    private static final String BEAN_VLD_DEFAULT_VALIDATOR = "org.jessma.mvc.validation.HibernateBeanValidator";
    private static final String ACTION_FILTERS_KEY = "action-filters";
    private static final String FILTER_KEY = "filter";
    private static final String FILTER_CLASS_KEY = "class";
    private static final String FILTER_PATTERN_KEY = "pattern";
    private static final String FILTER_METHODS_KEY = "methods";
    private static final String FILTER_DEFAULT_PATTERN = ".*";
    private static final String FILTER_DEFAULT_METHODS = ".*";
    private static final String ACTION_CONV_KEY = "action-convention";
    private static final String CONV_ENABLE_KEY = "enable";
    private static final String CONV_DETECT_PHYSICAL_FILE_KEY = "detect-physical-file";
    private static final String CONV_BASE_PACKAGE_KEY = "action-base-package";
    private static final String CONV_DISPATCH_FILE_PATH_KEY = "dispatch-file-path";
    private static final String CONV_DISPATCH_FILE_TYPE_KEY = "dispatch-file-type";
    private static final String CONV_PHYSICAL_FILE_PATH_KEY = "physical-file-path";
    private static final String CONV_FILE_NAME_SEPARATOR_KEY = "file-name-separator";
    private static final String CONV_DEFAULT_DISPATCH_FILE_PATH = "/WEB-INF/page";
    private static final String CONV_DEFAULT_FILE_TYPE = "jsp";
    private static final String CONV_DEFAULT_FILE_NAME_SEPARATOR = "_";
    private static final String CONV_ACTION_PATH_NAME_SEPARATOR = "-";
    private static final String CONV_ACTION_NAME_USUAL_ENDING = "Action";
    private static final String RESULT_PATH_ALIASES_KEY = "result-path-aliases";
    private static final String RESULT_PATH_ALIAS_KEY = "alias";
    private static final String RESULT_PATH_ALIAS_NAME_KEY = "name";
    private static final String RESULT_PATH_ALIAS_PATH_KEY = "path";
    private static final String RESULT_PATH_PLACEHOLDER_BEGIN = "${";
    private static final String RESULT_PATH_PLACEHOLDER_END = "}";
    private static final String GLOBAL_RESULTS_KEY = "global-results";
    private static final String GLOBAL_EXCEPTION_MAPS_KEY = "global-exception-mappings";
    private static final String ENCODING_KEY = "encoding";
    private static final String EXCEPTION_MAP_KEY = "exception-mapping";
    private static final String EXCEPTION_KEY = "exception";
    private String encoding;
    private String actionSuffix;
    private BasePathConfig basePath;
    private I18nConfig i18nCfg;
    private BeanValidation validation;
    private ActionConvention convention;
    private Map<String, ActionResult> globalResults;
    private List<ActionException> globalExceptions;
    private List<ActionFilterInfo> filterInfoList;
    private LinkedList<ActionFilter> filterList;
    private Map<String, Map<String, ActionEntryConfig>> actionPkgMap;
    private Map<Method, LinkedList<ActionFilter>> filterCache;
    private Map<Class<ActionFilter>, ActionFilter> filterMap;
    private Map<Class<? extends Action>, ActionConfig> convACMap;
    private Map<String, String> resultAliasMap;
    private FilterConfig filterCfg;
    private ServletContext context;
    private boolean pausing;
    private static ActionDispatcher instance;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterCfg = filterConfig;
        this.context = filterConfig.getServletContext();
        this.attachInstance();
        this.loadConfig();
    }

    private void loadConfig() throws ServletException {
        String confFile = this.filterCfg.getInitParameter(CONFIG_FILE_KEY);
        if (GeneralHelper.isStrEmpty(confFile)) {
            confFile = DEFAULT_CONFIG_FILE;
        }
        confFile = GeneralHelper.getClassResourcePath(ActionDispatcher.class, confFile);
        this.resetProperties();
        this.loadConfigFile(confFile, true, null);
        this.loadActionFilters();
        if (this.i18nCfg.defaultLocale != null) {
            Locale.setDefault(this.i18nCfg.defaultLocale);
        }
        ActionSupport.setBeanValidation(this.validation);
        this.context.setAttribute("__default_app_bundle", (Object)this.i18nCfg.defaultBundle);
        this.context.setAttribute("__default_vld_bundle", (Object)this.validation.bundle);
        this.context.setAttribute("__context", (Object)(this.context.getContextPath() + PATH_SEPARATOR));
        this.context.setAttribute("__base_type", (Object)this.basePath.baseType);
        if (this.basePath.baseType == Action.BaseType.MANUAL) {
            this.context.setAttribute("__base", (Object)this.basePath.baseHref);
        } else {
            this.context.removeAttribute("__base");
        }
    }

    private void resetProperties() {
        this.encoding = null;
        this.actionSuffix = DEFAULT_ACTION_SUFFIX;
        this.basePath = new BasePathConfig();
        this.i18nCfg = new I18nConfig();
        this.validation = new BeanValidation();
        this.convention = new ActionConvention();
        this.globalResults = null;
        this.globalExceptions = null;
        this.filterInfoList = new ArrayList<ActionFilterInfo>();
        this.filterList = new LinkedList();
        this.actionPkgMap = new HashMap<String, Map<String, ActionEntryConfig>>();
        this.filterCache = new HashMap<Method, LinkedList<ActionFilter>>();
        this.filterMap = new HashMap<Class<ActionFilter>, ActionFilter>();
        this.convACMap = new HashMap<Class<? extends Action>, ActionConfig>();
        this.resultAliasMap = new HashMap<String, String>();
    }

    private void loadConfigFile(String confFile, boolean isMainConfigFile, Set<String> incFiles) throws ServletException {
        try {
            SAXReader sr = new SAXReader();
            Document doc = sr.read(new File(confFile));
            Element root = doc.getRootElement();
            if (isMainConfigFile) {
                incFiles = new HashSet<String>();
                incFiles.add(confFile);
                this.parseGlobal(root);
            }
            this.parseInclude(root, incFiles);
            this.parseActionPackage(root);
        }
        catch (Exception e) {
            throw new ServletException("load MVC config fail", (Throwable)e);
        }
    }

    private void parseGlobal(Element root) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Element global = root.element(GLOBAL_KEY);
        if (global != null) {
            Element gExceptionMaps;
            Element gResults;
            Element acConv;
            Element rsPathAliases;
            Element acFilters;
            Element bp;
            Element vld;
            Element i18n;
            Element acSuffix;
            Element enc = global.element(ENCODING_KEY);
            if (enc != null) {
                this.parseEncoding(enc);
            }
            if ((acSuffix = global.element(ACTION_SUFFIX_KEY)) != null) {
                this.parseActionSuffix(acSuffix);
            }
            if ((i18n = global.element(I18N_KEY)) != null) {
                this.parseI8n(i18n);
            }
            if ((vld = global.element(BEAN_VLD_KEY)) != null) {
                this.parseBeanValidation(vld);
            }
            if ((bp = global.element(BASE_PATH_KEY)) != null) {
                this.parseBasePath(bp);
            }
            if ((acFilters = global.element(ACTION_FILTERS_KEY)) != null) {
                this.parseActionFilters(acFilters);
            }
            if ((rsPathAliases = global.element(RESULT_PATH_ALIASES_KEY)) != null) {
                this.parseResultPathAliases(rsPathAliases);
            }
            if ((acConv = global.element(ACTION_CONV_KEY)) != null) {
                this.parseActionConvention(acConv);
            }
            if ((gResults = global.element(GLOBAL_RESULTS_KEY)) != null) {
                this.globalResults = this.parseResults(gResults);
            }
            if ((gExceptionMaps = global.element(GLOBAL_EXCEPTION_MAPS_KEY)) != null) {
                this.globalExceptions = this.parseExceptionLists(gExceptionMaps);
            }
        }
        this.ensureGlobalResultNone();
    }

    private void parseEncoding(Element enc) {
        String str = enc.getTextTrim();
        if (GeneralHelper.isStrNotEmpty(str)) {
            this.encoding = str;
        }
    }

    private void parseActionSuffix(Element acSuffix) {
        String str = acSuffix.getTextTrim();
        if (GeneralHelper.isStrNotEmpty(str)) {
            this.actionSuffix = str.startsWith(SUFFIX_CHARACTER) ? str : SUFFIX_CHARACTER + str;
        }
    }

    private void parseI8n(Element i18n) {
        String bundle;
        String dlc = i18n.attributeValue(I18N_DEF_LOCALE_KEY);
        if (GeneralHelper.isStrNotEmpty(dlc)) {
            this.i18nCfg.defaultLocale = GeneralHelper.getAvailableLocale(dlc);
            if (this.i18nCfg.defaultLocale == null) {
                throw new RuntimeException(String.format("parse i18n fail (invalid default-locale '%s')", dlc));
            }
        }
        if (GeneralHelper.isStrNotEmpty(bundle = i18n.attributeValue(I18N_DEF_BUNDLE_KEY))) {
            this.i18nCfg.defaultBundle = bundle;
        }
    }

    private void parseBeanValidation(Element vld) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String enable = vld.attributeValue("enable");
        this.validation.enable = GeneralHelper.str2Boolean(enable, true);
        String bundle = vld.attributeValue(BEAN_VLD_BUNDLE_KEY);
        if (GeneralHelper.isStrNotEmpty(bundle)) {
            this.validation.bundle = bundle;
        }
        if (this.validation.enable) {
            String vldClass = vld.attributeValue(BEAN_VLD_VALIDATOR_KEY);
            if (GeneralHelper.isStrEmpty(vldClass)) {
                vldClass = BEAN_VLD_DEFAULT_VALIDATOR;
            }
            Class<?> clazz = Class.forName(vldClass);
            this.validation.validator = (BeanValidator)clazz.newInstance();
            this.validation.validator.init();
        }
    }

    private void parseBasePath(Element bp) {
        String type = bp.attributeValue("type");
        if (GeneralHelper.isStrNotEmpty(type)) {
            this.basePath.baseType = Action.BaseType.fromString(type);
            if (this.basePath.baseType == Action.BaseType.MANUAL) {
                this.basePath.baseHref = bp.attributeValue(BASE_PATH_HREF_KEY);
                if (GeneralHelper.isStrEmpty(this.basePath.baseHref)) {
                    throw new RuntimeException("parse base path fail ('href' attribute must be set if 'type' = \"manual\")");
                }
                if (!this.basePath.baseHref.endsWith(PATH_SEPARATOR)) {
                    this.basePath.baseHref = this.basePath.baseHref + PATH_SEPARATOR;
                }
            }
        }
    }

    private void parseActionConvention(Element acConv) {
        String enable = acConv.attributeValue("enable");
        String detect = acConv.attributeValue(CONV_DETECT_PHYSICAL_FILE_KEY);
        String basePkg = acConv.attributeValue(CONV_BASE_PACKAGE_KEY);
        String dispatchPath = acConv.attributeValue(CONV_DISPATCH_FILE_PATH_KEY);
        String fileType = acConv.attributeValue(CONV_DISPATCH_FILE_TYPE_KEY);
        String physicalPath = acConv.attributeValue(CONV_PHYSICAL_FILE_PATH_KEY);
        String nameSep = acConv.attributeValue(CONV_FILE_NAME_SEPARATOR_KEY);
        this.convention.enable = GeneralHelper.str2Boolean(enable, true);
        this.convention.detect = GeneralHelper.str2Boolean(detect, true);
        this.convention.basePackage = GeneralHelper.safeString(basePkg);
        this.convention.dispatchPath = HttpHelper.ensurePath(this.parseResultPath(dispatchPath), CONV_DEFAULT_DISPATCH_FILE_PATH);
        this.convention.physicalPath = HttpHelper.ensurePath(this.parseResultPath(physicalPath), this.convention.dispatchPath);
        this.convention.fileType = GeneralHelper.isStrNotEmpty(fileType) ? fileType : CONV_DEFAULT_FILE_TYPE;
        this.convention.separator = GeneralHelper.isStrNotEmpty(nameSep) ? nameSep.substring(0, 1) : CONV_DEFAULT_FILE_NAME_SEPARATOR;
    }

    private void parseActionFilters(Element acFilters) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        List filters = acFilters.elements(FILTER_KEY);
        for (Element filter : filters) {
            String clazz = filter.attributeValue("class");
            String pattern = filter.attributeValue(FILTER_PATTERN_KEY);
            String methods = filter.attributeValue(FILTER_METHODS_KEY);
            if (GeneralHelper.isStrEmpty(clazz)) {
                throw new RuntimeException("parse action filter fail ('class' attribute must be set)");
            }
            if (GeneralHelper.isStrEmpty(pattern)) {
                pattern = ".*";
            }
            if (GeneralHelper.isStrEmpty(methods)) {
                methods = ".*";
            }
            ActionFilterInfo info = new ActionFilterInfo();
            info.afClass = Class.forName(clazz);
            info.pattern = Pattern.compile(pattern);
            info.methods = Pattern.compile(methods);
            this.filterInfoList.add(info);
            ActionFilter f = this.filterMap.get(info.afClass);
            if (f != null) continue;
            f = info.afClass.newInstance();
            f.init();
            this.filterList.addLast(f);
            this.filterMap.put(info.afClass, f);
        }
    }

    private void parseResultPathAliases(Element rsPathAliases) {
        List aliases = rsPathAliases.elements(RESULT_PATH_ALIAS_KEY);
        for (Element alias : aliases) {
            String name = alias.attributeValue("name");
            String path = alias.attributeValue("path");
            if (GeneralHelper.isStrEmpty(name)) {
                throw new RuntimeException("parse result path alias fail ('name' attribute must be set)");
            }
            if (path == null) {
                throw new RuntimeException("parse result path alias fail ('path' attribute must be set)");
            }
            this.resultAliasMap.put(name, this.parseResultPath(path));
        }
    }

    private List<ActionException> parseExceptionLists(Element exceptionMaps) throws ClassNotFoundException {
        ArrayList<ActionException> exceptions = new ArrayList<ActionException>();
        List maps = exceptionMaps.elements(EXCEPTION_MAP_KEY);
        for (Element map : maps) {
            ActionException ae = new ActionException();
            String clazz = map.attributeValue(EXCEPTION_KEY);
            ae.result = map.attributeValue(RESULT_KEY);
            ae.exception = GeneralHelper.isStrEmpty(clazz) ? Exception.class : Class.forName(clazz);
            if (ae.result == null) {
                ae.result = EXCEPTION_KEY;
            }
            exceptions.add(ae);
        }
        return exceptions.isEmpty() ? null : exceptions;
    }

    private void ensureGlobalResultNone() {
        if (this.globalResults == null) {
            this.globalResults = new HashMap<String, ActionResult>();
        }
        if (!this.globalResults.containsKey("none")) {
            this.globalResults.put("none", new ActionResult("none", Action.ResultType.FINISH));
        }
    }

    private void parseInclude(Element root, Set<String> incFiles) throws ServletException {
        List includes = root.elements(INCLUDE_KEY);
        for (Element inc : includes) {
            String fileName = inc.attributeValue(INCLUDE_FILE_KEY);
            String incFile = GeneralHelper.getClassResourcePath(ActionDispatcher.class, fileName);
            if (incFile == null) {
                throw new ServletException(String.format("include file '%s' not found", fileName));
            }
            if (incFiles.contains(incFile)) continue;
            incFiles.add(incFile);
            this.loadConfigFile(incFile, false, incFiles);
        }
    }

    private void parseActionPackage(Element root) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        List acsList = root.elements(ACTIONS_KEY);
        for (Element actions : acsList) {
            String path = actions.attributeValue("path");
            Map<String, ActionEntryConfig> actionEntryMap = this.actionPkgMap.get(path = HttpHelper.ensurePath(path, PATH_SEPARATOR));
            if (actionEntryMap == null) {
                actionEntryMap = new HashMap<String, ActionEntryConfig>();
                this.actionPkgMap.put(path, actionEntryMap);
            }
            this.parseAction(actions, actionEntryMap);
        }
    }

    private void parseAction(Element actions, Map<String, ActionEntryConfig> actionEntryMap) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        List acList = actions.elements(ACTION_KEY);
        for (Element action : acList) {
            ActionConfig ac = new ActionConfig();
            ac.name = action.attributeValue("name");
            String clazz = action.attributeValue("class");
            ac.acClass = clazz == null ? ActionSupport.class : Class.forName(clazz);
            ac.results = this.parseResults(action);
            ac.exceptions = this.parseExceptionLists(action);
            this.parseActionEntry(action, ac, actionEntryMap);
        }
    }

    private void parseActionEntry(Element action, ActionConfig ac, Map<String, ActionEntryConfig> actionEntryMap) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        List aecList = action.elements(ACTION_ENTRY_KEY);
        for (Element entry : aecList) {
            String entryName;
            String name = entry.attributeValue("name");
            String method = entry.attributeValue(ACTION_ENTRY_METHOD_KEY);
            String string = entryName = GeneralHelper.isStrEmpty(name) ? ac.name : ac.name + ACTION_ENTRY_SEPARATOR + name;
            String entryMethod = GeneralHelper.isStrEmpty(method) ? (GeneralHelper.isStrEmpty(name) ? ACTION_DEFAULT_ENTRY_METHOD : name) : method;
            Method m = ac.acClass.getMethod(entryMethod, new Class[0]);
            if (!String.class.isAssignableFrom(m.getReturnType()) || !BeanHelper.isPublicInstanceMethod(m)) {
                String msg = String.format("invalid action entry method '%s'", m);
                throw new RuntimeException(msg);
            }
            actionEntryMap.put(entryName, new ActionEntryConfig(entryName, m, ac, this.parseResults(entry), this.parseExceptionLists(entry)));
        }
        if (actionEntryMap.get(ac.name) == null) {
            actionEntryMap.put(ac.name, new ActionEntryConfig(ac.name, ac.acClass.getMethod(ACTION_DEFAULT_ENTRY_METHOD, new Class[0]), ac));
        }
    }

    private Map<String, ActionResult> parseResults(Element rsElement) {
        HashMap<String, ActionResult> map = new HashMap<String, ActionResult>();
        List results = rsElement.elements(RESULT_KEY);
        for (Element result : results) {
            ActionResult ars = new ActionResult();
            ars.name = result.attributeValue("name");
            String type = result.attributeValue("type");
            ars.path = this.parseResultPath(result.getTextTrim());
            if (ars.name == null) {
                ars.name = "success";
            }
            ars.type = type == null || type.equals(Action.ResultType.DEFAULT.toString()) ? (!ars.name.equals("none") ? Action.ResultType.DISPATCH : Action.ResultType.FINISH) : Action.ResultType.fromString(type);
            map.put(ars.name, ars);
        }
        return map.isEmpty() ? null : map;
    }

    private String parseResultPath(String path) {
        if (GeneralHelper.isStrEmpty(path)) {
            return path;
        }
        boolean isOK = true;
        int begin = -1;
        int end = -1;
        int length = path.length();
        StringBuilder sb = new StringBuilder();
        do {
            if ((begin = path.indexOf(RESULT_PATH_PLACEHOLDER_BEGIN, end + 1)) == -1) continue;
            sb.append(path.substring(end + 1, begin));
            end = path.indexOf(RESULT_PATH_PLACEHOLDER_END, begin + 2);
            if (end == -1) {
                isOK = false;
            }
            if (!isOK) continue;
            String name = path.substring(begin + 2, end);
            String value = this.resultAliasMap.get(name);
            if (value != null) {
                sb.append(value);
                continue;
            }
            String alias = RESULT_PATH_PLACEHOLDER_BEGIN + name + RESULT_PATH_PLACEHOLDER_END;
            throw new RuntimeException(String.format("parse result path fail (alias '%s' not found in result path '%s')", alias, path));
        } while (isOK && begin != -1);
        if (isOK) {
            if (end < length - 1) {
                sb.append(path.substring(end + 1));
            }
        } else {
            throw new RuntimeException(String.format("parse result path fail (invalid result path '%s')", path));
        }
        return sb.toString();
    }

    private void loadActionFilters() {
        if (!this.filterInfoList.isEmpty()) {
            Collection<Map<String, ActionEntryConfig>> packages = this.actionPkgMap.values();
            for (Map<String, ActionEntryConfig> pkg : packages) {
                Collection<ActionEntryConfig> aecs = pkg.values();
                for (ActionEntryConfig aec : aecs) {
                    this.loadActionFilterCache(aec);
                }
            }
        }
    }

    private void loadActionFilterCache(ActionEntryConfig aec) {
        LinkedList<ActionFilter> filters = this.filterCache.get(aec.method);
        if (filters == null) {
            filters = this.matchActionFilters(aec);
            this.tryPutFilterCache(aec.method, filters);
        }
    }

    private LinkedList<ActionFilter> matchActionFilters(ActionEntryConfig aec) {
        HashSet<ActionFilter> tmpFilterSet = new HashSet<ActionFilter>();
        LinkedList<ActionFilter> filters = new LinkedList<ActionFilter>();
        for (ActionFilterInfo info : this.filterInfoList) {
            ActionFilter filter;
            Matcher m = info.pattern.matcher(((ActionEntryConfig)aec).container.acClass.getName());
            if (!m.matches() || !(m = info.methods.matcher(aec.method.getName())).matches() || tmpFilterSet.contains(filter = this.filterMap.get(info.afClass))) continue;
            filters.add(filter);
            tmpFilterSet.add(filter);
        }
        return filters;
    }

    private void tryPutFilterCache(Method method, LinkedList<ActionFilter> filters) {
        if (!filters.isEmpty()) {
            Collection<LinkedList<ActionFilter>> fs = this.filterCache.values();
            for (LinkedList<ActionFilter> f : fs) {
                if (!filters.equals(f)) continue;
                filters = f;
                break;
            }
            GeneralHelper.syncTryPut(this.filterCache, method, filters);
        }
    }

    public void destroy() {
        while (!this.filterList.isEmpty()) {
            this.filterList.removeLast().destroy();
        }
        if (this.validation.validator != null) {
            this.validation.validator.destroy();
        }
        this.resultAliasMap = null;
        this.convACMap = null;
        this.filterList = null;
        this.filterInfoList = null;
        this.filterMap = null;
        this.filterCache = null;
        this.actionPkgMap = null;
        this.globalResults = null;
        this.globalExceptions = null;
        this.context = null;
        this.filterCfg = null;
        this.detachInstance();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String reqPath;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        if (this.pausing) {
            response.setHeader("Retry-After", Integer.toString(5));
            response.sendError(503, "Server is reloading, please retry after a few seconds");
            return;
        }
        if (this.encoding != null) {
            request.setCharacterEncoding(this.encoding);
            response.setCharacterEncoding(this.encoding);
        }
        if ((reqPath = request.getServletPath()).endsWith(this.actionSuffix)) {
            String actionPath = reqPath.substring(0, reqPath.length() - this.actionSuffix.length());
            this.dispatchAction(request, response, new ActionPackage(actionPath));
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void dispatchAction(HttpServletRequest request, HttpServletResponse response, ActionPackage pkg) throws ServletException, IOException {
        ActionEntryConfig aec = null;
        try {
            aec = this.extractActionEntryConfig(pkg, true);
        }
        catch (Exception e) {
            String msg = String.format("Extract Action Convention '%s' fail (%s)", pkg, e.getMessage());
            response.sendError(404, msg);
            return;
        }
        if (aec == null) {
            String msg = String.format("Action Entry '%s' not found", pkg);
            response.sendError(404, msg);
            return;
        }
        Action action = null;
        try {
            action = this.createAction(request, response, aec, pkg);
        }
        catch (Exception e) {
            String msg = String.format("Instantiate Action '%s (%s)' fail", pkg, ((ActionEntryConfig)aec).container.acClass.getName());
            throw new ServletException(msg, (Throwable)e);
        }
        try {
            String result = this.executeAction(request, response, aec, action);
            this.dispatchResult(request, response, pkg, aec, action, result);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    void dispatchResult(HttpServletRequest request, HttpServletResponse response, ActionPackage pkg, ActionEntryConfig aec, Action action, String result) throws ServletException, IOException {
        ActionResult rs = this.findResult(request, pkg, aec, result);
        if (rs == null) {
            String msg = String.format("Result Name '%s' in Action Entry '%s' not found", result, pkg);
            throw new ServletException(msg);
        }
        this.processResult(request, response, pkg, rs, action);
    }

    private ActionEntryConfig extractActionEntryConfig(ActionPackage pkg, boolean firstTime) throws Exception {
        ActionEntryConfig aec = null;
        Map<String, ActionEntryConfig> actionEntryMap = this.actionPkgMap.get(pkg.path);
        if (actionEntryMap != null) {
            aec = actionEntryMap.get(pkg.name);
        }
        if (aec == null & firstTime && this.convention.enable) {
            this.extractActionEntryConvention(pkg);
            aec = this.extractActionEntryConfig(pkg, false);
        }
        return aec;
    }

    private String executeAction(HttpServletRequest request, HttpServletResponse response, ActionEntryConfig aec, Action action) throws Exception {
        String result;
        block7: {
            result = null;
            LinkedList<ActionFilter> filters = this.filterCache.get(aec.method);
            try {
                if (filters == null) {
                    result = ActionExecutor.execute(action, aec.method);
                } else {
                    ActionExecutor executor = new ActionExecutor(filters, action, aec.method, this.context, request, response);
                    result = executor.invoke();
                }
            }
            catch (Exception e) {
                request.setAttribute("__exception", (Object)e);
                if (aec.exceptions != null) {
                    result = this.processActionException(request, aec.exceptions, e);
                }
                if (result == null && ((ActionEntryConfig)aec).container.exceptions != null) {
                    result = this.processActionException(request, ((ActionEntryConfig)aec).container.exceptions, e);
                }
                if (result == null && this.globalExceptions != null) {
                    result = this.processActionException(request, this.globalExceptions, e);
                }
                if (result != null) break block7;
                throw e;
            }
        }
        return result;
    }

    private String processActionException(HttpServletRequest request, List<ActionException> aes, Exception e) {
        String result = null;
        for (ActionException ae : aes) {
            if (!ae.exception.isAssignableFrom(e.getClass())) continue;
            result = ae.result;
            break;
        }
        return result;
    }

    private Action createAction(HttpServletRequest request, HttpServletResponse response, ActionEntryConfig aec, ActionPackage pkg) throws InstantiationException, IllegalAccessException {
        Action action = ((ActionEntryConfig)aec).container.acClass.newInstance();
        action.setServletContext(this.context);
        action.setRequest(request);
        action.setResponse(response);
        if (action instanceof ActionSupport) {
            ActionSupport asp = (ActionSupport)action;
            asp.setActionDispatcher(this);
            asp.setActionPackage(pkg);
            asp.setActionEntryConfig(aec);
        }
        this.parseFormBean(aec, action, request.getParameterMap());
        return action;
    }

    private ActionResult findResult(HttpServletRequest request, ActionPackage pkg, ActionEntryConfig aec, String result) {
        ActionResult rs = null;
        if (aec.results != null) {
            rs = (ActionResult)aec.results.get(result);
        }
        if (rs == null && ((ActionEntryConfig)aec).container.results != null) {
            rs = ((ActionEntryConfig)aec).container.results.get(result);
        }
        if (rs == null && this.globalResults != null) {
            rs = this.globalResults.get(result);
        }
        if (rs == null && this.convention.enable) {
            rs = this.makeConventionResult(result, request, pkg, aec);
        }
        return rs;
    }

    private void processResult(HttpServletRequest request, HttpServletResponse response, ActionPackage pkg, ActionResult ars, Action action) throws ServletException, IOException {
        switch (ars.type) {
            case DISPATCH: {
                if (this.basePath.baseType == Action.BaseType.AUTO) {
                    request.setAttribute("__base", (Object)HttpHelper.getRequestBasePath(request));
                }
                request.setAttribute("__action", (Object)action);
                RequestDispatcher rd = request.getRequestDispatcher(response.encodeURL(ars.path));
                if (rd != null) {
                    rd.forward((ServletRequest)request, (ServletResponse)response);
                    break;
                }
                String msg = String.format("Dispatch URL '%s' not found", ars.path);
                response.sendError(404, msg);
                break;
            }
            case REDIRECT: {
                response.sendRedirect(response.encodeRedirectURL(ars.path));
                break;
            }
            case CHAIN: {
                request.setAttribute("__action", (Object)action);
                this.dispatchChainAction(request, response, pkg, ars.path);
                break;
            }
            case FINISH: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private final <T> void parseFormBean(ActionEntryConfig aec, Action action, Map<String, T> paramMap) {
        if (aec.formBeanAttr != null) {
            Action formBean = null;
            if (aec.formBeanAttr.property != null) {
                formBean = BeanHelper.createBean(aec.formBeanAttr.property.getPropertyType(), paramMap);
                BeanHelper.setProperty((Object)action, aec.formBeanAttr.property, formBean);
            } else if (aec.formBeanAttr.field != null) {
                formBean = BeanHelper.createBean(aec.formBeanAttr.field.getType(), paramMap);
                BeanHelper.setFieldValue((Object)action, aec.formBeanAttr.field, formBean);
            } else {
                formBean = action;
                BeanHelper.setPropertiesOrFieldValues(formBean, paramMap);
            }
            if (action instanceof ActionSupport) {
                ActionSupport asp = (ActionSupport)action;
                asp.setFormBean(formBean);
                if (this.validation.enable) {
                    asp.setAutoValidation(aec.formBeanAttr.validate);
                    asp.setValidationGroups(aec.formBeanAttr.groups);
                }
            }
        }
    }

    private void dispatchChainAction(HttpServletRequest request, HttpServletResponse response, ActionPackage currentPkg, String path) throws ServletException, IOException {
        ActionPackage pkg = new ActionPackage(path, currentPkg.path);
        this.dispatchAction(request, response, pkg);
    }

    private void extractActionEntryConvention(ActionPackage pkg) throws Exception {
        ActionEntryDesc desc = ActionEntryDesc.generate(this.convention.basePackage, pkg);
        ActionEntryConfig aec = this.parseActionEntry(desc);
        this.tryPutActionEntryConfig(pkg, aec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryPutActionEntryConfig(ActionPackage pkg, ActionEntryConfig aec) {
        this.loadActionFilterCache(aec);
        Map<String, Map<String, ActionEntryConfig>> map = this.actionPkgMap;
        synchronized (map) {
            Map<String, ActionEntryConfig> actionEntryMap = this.actionPkgMap.get(pkg.path);
            if (actionEntryMap == null) {
                actionEntryMap = new HashMap<String, ActionEntryConfig>();
                this.actionPkgMap.put(pkg.path, actionEntryMap);
            }
            GeneralHelper.syncTryPut(actionEntryMap, pkg.name, aec);
        }
    }

    private ActionEntryConfig parseActionEntry(ActionEntryDesc desc) {
        this.checkConvActionConfigMap(desc);
        ActionConfig ac = this.convACMap.get(desc.clazz);
        ActionEntryConfig aec = new ActionEntryConfig(desc.entryName, desc.method, ac);
        aec.results = this.parseResults(desc.method);
        aec.exceptions = this.parseExceptionLists(desc.method);
        return aec;
    }

    private void checkConvActionConfigMap(ActionEntryDesc desc) {
        if (!this.convACMap.containsKey(desc.clazz)) {
            ActionConfig ac = new ActionConfig();
            ac.name = desc.actionName;
            ac.acClass = desc.clazz;
            ac.results = this.parseResults(desc.clazz);
            ac.exceptions = this.parseExceptionLists(desc.clazz);
            GeneralHelper.syncTryPut(this.convACMap, ac.acClass, ac);
        }
    }

    private Map<String, ActionResult> parseResults(AnnotatedElement ae) {
        Map<String, Result> rsMap = this.parseResultAnnotations(ae);
        Map<String, ActionResult> arsMap = this.parseActionResultMap(rsMap);
        return arsMap.isEmpty() ? null : arsMap;
    }

    private Map<String, Result> parseResultAnnotations(AnnotatedElement ae) {
        Results results;
        HashMap<String, Result> map = new HashMap<String, Result>();
        Result result = ae.getAnnotation(Result.class);
        if (result != null) {
            GeneralHelper.tryPut(map, result.value(), result);
        }
        if ((results = ae.getAnnotation(Results.class)) != null) {
            Result[] rs;
            for (Result r : rs = results.value()) {
                GeneralHelper.tryPut(map, r.value(), r);
            }
        }
        return map;
    }

    private Map<String, ActionResult> parseActionResultMap(Map<String, Result> rsMap) {
        HashMap<String, ActionResult> map = new HashMap<String, ActionResult>();
        Collection<Result> results = rsMap.values();
        for (Result result : results) {
            ActionResult ars = new ActionResult();
            ars.name = result.value();
            ars.type = result.type();
            ars.path = this.parseResultPath(result.path());
            if (ars.type == Action.ResultType.DEFAULT) {
                ars.type = !ars.name.equals("none") ? Action.ResultType.DISPATCH : Action.ResultType.FINISH;
            }
            map.put(ars.name, ars);
        }
        return map;
    }

    private List<ActionException> parseExceptionLists(AnnotatedElement ae) {
        List<ExceptionMapping> emList = this.parseExceptionMappingAnnotations(ae);
        List<ActionException> aeList = this.parseActionExceptionList(emList);
        return aeList.isEmpty() ? null : aeList;
    }

    private List<ExceptionMapping> parseExceptionMappingAnnotations(AnnotatedElement ae) {
        ExceptionMappings ems;
        ArrayList<ExceptionMapping> list = new ArrayList<ExceptionMapping>();
        ExceptionMapping em = ae.getAnnotation(ExceptionMapping.class);
        if (em != null) {
            list.add(em);
        }
        if ((ems = ae.getAnnotation(ExceptionMappings.class)) != null) {
            ExceptionMapping[] emArr;
            for (ExceptionMapping em2 : emArr = ems.value()) {
                list.add(em2);
            }
        }
        return list;
    }

    private List<ActionException> parseActionExceptionList(List<ExceptionMapping> emList) {
        ArrayList<ActionException> exceptions = new ArrayList<ActionException>();
        for (ExceptionMapping em : emList) {
            ActionException ae = new ActionException();
            ae.exception = em.value();
            ae.result = em.result();
            exceptions.add(ae);
        }
        return exceptions;
    }

    private ActionResult makeConventionResult(String result, HttpServletRequest request, ActionPackage pkg, ActionEntryConfig aec) {
        String SUCCESS_ENDS = this.convention.separator + "success";
        String pkgNamePart = pkg.name.replace(ACTION_ENTRY_SEPARATOR, this.convention.separator);
        String fileNamePart = pkgNamePart + this.convention.separator + result;
        String fileName = fileNamePart + SUFFIX_CHARACTER + this.convention.fileType;
        String dispatchPath = null;
        if (!fileNamePart.endsWith(SUCCESS_ENDS)) {
            dispatchPath = this.makeDispatchPath(fileName, request, pkg, aec, this.convention.detect);
        } else {
            String fileNamePart2;
            String fileName2;
            dispatchPath = this.makeDispatchPath(fileName, request, pkg, aec, true);
            if (dispatchPath == null && (dispatchPath = this.makeDispatchPath(fileName2 = (fileNamePart2 = fileNamePart.substring(0, fileNamePart.length() - SUCCESS_ENDS.length())) + SUFFIX_CHARACTER + this.convention.fileType, request, pkg, aec, true)) == null && !this.convention.detect) {
                dispatchPath = this.makeDispatchPath(fileName, request, pkg, aec, false);
            }
        }
        if (dispatchPath != null) {
            this.tryPutActionResult(result, aec, dispatchPath);
            return (ActionResult)aec.results.get(result);
        }
        String pkgPath = pkg.path.substring(1);
        String physicalPath = this.convention.physicalPath + pkgPath + fileName;
        String msg = String.format("physical target file '%s' not found for Action Result '%s' (%s)", physicalPath, result, pkg);
        throw new RuntimeException(msg);
    }

    private String makeDispatchPath(String fileName, HttpServletRequest request, ActionPackage pkg, ActionEntryConfig aec, boolean detect) {
        String physicalPath;
        String absolutePath;
        String pkgPath = pkg.path.substring(1);
        String dispatchPath = this.convention.dispatchPath + pkgPath + fileName;
        if (detect && !new File(absolutePath = HttpHelper.getRequestRealPath(request, physicalPath = this.convention.physicalPath + pkgPath + fileName)).isFile()) {
            return null;
        }
        return dispatchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryPutActionResult(String result, ActionEntryConfig aec, String dispatchPath) {
        ActionEntryConfig actionEntryConfig = aec;
        synchronized (actionEntryConfig) {
            if (aec.results == null) {
                aec.results = new HashMap();
            }
            GeneralHelper.syncTryPut(aec.results, result, new ActionResult(result, Action.ResultType.DISPATCH, dispatchPath));
        }
    }

    public static final ActionDispatcher instance() {
        return instance;
    }

    private void attachInstance() {
        if (instance != null) {
            throw new IllegalStateException(String.format("another filter instance exists which is assignable to '%s' (only one such instance can be created for every application)", ActionDispatcher.class.getName()));
        }
        instance = this;
        HttpHelper.initializeServletContext(this.context);
    }

    private void detachInstance() {
        if (instance == this) {
            HttpHelper.unInitializeServletContext();
            instance = null;
        }
    }

    public void pause() {
        this.pausing = true;
    }

    public void resume() {
        this.pausing = false;
    }

    public synchronized void reload(long delay) throws Exception {
        String encoding = this.encoding;
        String actionSuffix = this.actionSuffix;
        BasePathConfig basePath = this.basePath;
        I18nConfig i18nCfg = this.i18nCfg;
        BeanValidation validation = this.validation;
        ActionConvention convention = this.convention;
        Map<String, ActionResult> globalResults = this.globalResults;
        List<ActionException> globalExceptions = this.globalExceptions;
        List<ActionFilterInfo> filterInfoList = this.filterInfoList;
        LinkedList<ActionFilter> filterList = this.filterList;
        Map<String, Map<String, ActionEntryConfig>> actionPkgMap = this.actionPkgMap;
        Map<Method, LinkedList<ActionFilter>> filterCache = this.filterCache;
        Map<Class<ActionFilter>, ActionFilter> filterMap = this.filterMap;
        Map<Class<? extends Action>, ActionConfig> convACMap = this.convACMap;
        Map<String, String> resultAliasMap = this.resultAliasMap;
        try {
            GeneralHelper.waitFor(delay);
            for (ActionFilter filter : filterList) {
                filter.destroy();
            }
            if (validation.validator != null) {
                validation.validator.destroy();
            }
            this.loadConfig();
        }
        catch (Exception e) {
            for (ActionFilter filter : this.filterList) {
                filter.destroy();
            }
            if (this.validation.validator != null) {
                this.validation.validator.destroy();
            }
            if (validation.validator != null) {
                validation.validator.init();
            }
            for (ActionFilter filter : filterList) {
                filter.init();
            }
            this.encoding = encoding;
            this.actionSuffix = actionSuffix;
            this.basePath = basePath;
            this.i18nCfg = i18nCfg;
            this.validation = validation;
            this.convention = convention;
            this.globalResults = globalResults;
            this.globalExceptions = globalExceptions;
            this.filterInfoList = filterInfoList;
            this.filterList = filterList;
            this.actionPkgMap = actionPkgMap;
            this.filterCache = filterCache;
            this.filterMap = filterMap;
            this.convACMap = convACMap;
            this.resultAliasMap = resultAliasMap;
            throw e;
        }
    }

    private static class ActionEntryDesc {
        String actionPath;
        String actionName;
        String entryName;
        String className;
        String methodName;
        Class<? extends Action> clazz;
        Method method;

        private ActionEntryDesc() {
        }

        static ActionEntryDesc generate(String basePackage, ActionPackage pkg) throws SecurityException, NoSuchMethodException {
            ActionEntryDesc desc = new ActionEntryDesc();
            desc.parseBasicInfo(basePackage, pkg);
            desc.parseEntryInfo();
            return desc;
        }

        private void parseBasicInfo(String basePackage, ActionPackage pkg) {
            this.actionPath = pkg.path;
            this.entryName = pkg.name;
            StringBuilder path = new StringBuilder(basePackage);
            String subPath = pkg.toString();
            if (!subPath.startsWith(ActionDispatcher.PATH_SEPARATOR)) {
                path.append(ActionDispatcher.PATH_SEPARATOR);
            }
            path.append(subPath);
            String[] paths = GeneralHelper.splitStr(path.toString(), "/.");
            int index = paths.length - 1;
            String[] entry = GeneralHelper.splitStr(this.entryName, ActionDispatcher.ACTION_ENTRY_SEPARATOR);
            this.actionName = entry[0];
            if (entry.length == 1) {
                this.methodName = ActionDispatcher.ACTION_DEFAULT_ENTRY_METHOD;
            } else {
                paths[index] = entry[0];
                String[] halfNames = GeneralHelper.splitStr(entry[1], ActionDispatcher.CONV_ACTION_PATH_NAME_SEPARATOR);
                StringBuilder name = new StringBuilder();
                for (int j = 0; j < halfNames.length; ++j) {
                    String part = halfNames[j];
                    if (j == 0) {
                        name.append(Character.toLowerCase(part.charAt(0)));
                    } else {
                        name.append(Character.toUpperCase(part.charAt(0)));
                    }
                    name.append(part.substring(1));
                }
                this.methodName = name.toString();
            }
            StringBuilder name = new StringBuilder();
            for (int i = 0; i <= index; ++i) {
                String str = paths[i];
                String[] halfNames = GeneralHelper.splitStr(str, ActionDispatcher.CONV_ACTION_PATH_NAME_SEPARATOR);
                for (int j = 0; j < halfNames.length; ++j) {
                    String part = halfNames[j];
                    if (i < index) {
                        name.append(part.toLowerCase());
                        continue;
                    }
                    name.append(Character.toUpperCase(part.charAt(0)));
                    name.append(part.substring(1));
                }
                if (i >= index) continue;
                name.append(ActionDispatcher.SUFFIX_CHARACTER);
            }
            this.className = name.toString();
        }

        private void parseEntryInfo() throws SecurityException, NoSuchMethodException {
            Method method;
            Class<?> clazz = GeneralHelper.classForName(this.className);
            if (clazz == null && !this.className.endsWith(ActionDispatcher.CONV_ACTION_NAME_USUAL_ENDING)) {
                clazz = GeneralHelper.classForName(this.className + ActionDispatcher.CONV_ACTION_NAME_USUAL_ENDING);
            }
            if (clazz != null && Action.class.isAssignableFrom(clazz) && BeanHelper.isPublicNotAbstractClass(clazz)) {
                method = clazz.getMethod(this.methodName, new Class[0]);
                if (!String.class.isAssignableFrom(method.getReturnType()) || !BeanHelper.isPublicInstanceMethod(method)) {
                    String msg = String.format("invalid action entry method '%s' for '%s%s'", method, this.actionPath, this.entryName);
                    throw new RuntimeException(msg);
                }
            } else {
                String msg = String.format("invalid action class '%s[%s]' for '%s%s'", this.className, ActionDispatcher.CONV_ACTION_NAME_USUAL_ENDING, this.actionPath, this.entryName);
                throw new RuntimeException(msg);
            }
            this.clazz = clazz;
            this.method = method;
        }
    }

    private static class ActionConvention {
        boolean enable;
        boolean detect;
        String basePackage;
        String dispatchPath;
        String physicalPath;
        String fileType;
        String separator;

        private ActionConvention() {
        }
    }

    static class BeanValidation {
        boolean enable;
        BeanValidator validator;
        String bundle = "res.validation-message";

        BeanValidation() {
        }
    }

    private static class I18nConfig {
        Locale defaultLocale;
        String defaultBundle = "res.application-message";

        private I18nConfig() {
        }
    }

    private static class BasePathConfig {
        Action.BaseType baseType = Action.BaseType.AUTO;
        String baseHref;

        private BasePathConfig() {
        }
    }

    private static class ActionException {
        Class<? extends Exception> exception;
        String result;

        private ActionException() {
        }
    }

    private static class ActionResult {
        String name;
        Action.ResultType type;
        String path;

        ActionResult() {
        }

        ActionResult(String name, Action.ResultType type) {
            this(name, type, null);
        }

        ActionResult(String name, Action.ResultType type, String path) {
            this.name = name;
            this.type = type;
            this.path = path;
        }
    }

    private static class ActionConfig {
        String name;
        Class<? extends Action> acClass;
        Map<String, ActionResult> results;
        List<ActionException> exceptions;

        private ActionConfig() {
        }
    }

    private static class ActionFilterInfo {
        Class<ActionFilter> afClass;
        Pattern pattern;
        Pattern methods;

        private ActionFilterInfo() {
        }
    }

    static class ActionPackage {
        private String path;
        private String name;

        private ActionPackage(String actionPath) {
            this(actionPath, (String)null);
        }

        private ActionPackage(String actionPath, String currentPath) {
            int sepIndex = actionPath.lastIndexOf(ActionDispatcher.PATH_SEPARATOR);
            if (sepIndex != -1) {
                this.path = actionPath.substring(0, sepIndex + 1);
                if (currentPath != null && this.path.startsWith(ActionDispatcher.CURRENT_PATH_PREFIX)) {
                    this.path = this.path.replace(ActionDispatcher.CURRENT_PATH_PREFIX, currentPath);
                }
                if (!this.path.startsWith(ActionDispatcher.PATH_SEPARATOR)) {
                    this.path = ActionDispatcher.PATH_SEPARATOR + this.path;
                }
                if (sepIndex < actionPath.length() - 1) {
                    this.name = actionPath.substring(sepIndex + 1, actionPath.length());
                }
            } else {
                this.path = ActionDispatcher.PATH_SEPARATOR;
                this.name = actionPath;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.path != null) {
                sb.append(this.path);
            }
            if (this.name != null) {
                sb.append(this.name);
            }
            return sb.toString();
        }
    }

    static class ActionEntryConfig {
        private String name;
        private Method method;
        private ActionConfig container;
        private Map<String, ActionResult> results;
        private List<ActionException> exceptions;
        private FormBeanAttr formBeanAttr;

        private ActionEntryConfig(String name, Method method, ActionConfig container) {
            this(name, method, container, null, null);
        }

        private ActionEntryConfig(String name, Method method, ActionConfig container, Map<String, ActionResult> results, List<ActionException> exceptions) {
            this.name = name;
            this.method = method;
            this.container = container;
            this.results = results;
            this.exceptions = exceptions;
            this.analysisFormBeanAttr();
        }

        private void analysisFormBeanAttr() {
            FormBean formBean = this.method.getAnnotation(FormBean.class);
            if (formBean == null) {
                formBean = this.container.acClass.getAnnotation(FormBean.class);
            }
            if (formBean != null) {
                String value = formBean.value();
                if (GeneralHelper.isStrEmpty(value)) {
                    this.formBeanAttr = new FormBeanAttr();
                } else {
                    Class stopClass = ActionSupport.class.isAssignableFrom(this.container.acClass) ? ActionSupport.class : Object.class;
                    PropertyDescriptor pd = BeanHelper.getPropDescByName(this.container.acClass, stopClass, value);
                    Method setter = BeanHelper.getPropertyWriteMethod(pd);
                    if (setter != null) {
                        this.formBeanAttr = new FormBeanAttr(pd);
                    } else {
                        Field field = BeanHelper.getInstanceFiledByName(this.container.acClass, stopClass, value);
                        if (field != null) {
                            this.formBeanAttr = new FormBeanAttr(field);
                        }
                    }
                    if (this.formBeanAttr == null) {
                        String msg = String.format("Parse @FormBean in '%s#%s()' -> no property or field named '%s'", this.container.acClass.getName(), this.method.getName(), value);
                        throw new RuntimeException(msg);
                    }
                }
                this.formBeanAttr.validate = formBean.validate();
                FormBeanAttr.access$1902(this.formBeanAttr, formBean.groups());
            }
        }

        private static class FormBeanAttr {
            private PropertyDescriptor property;
            private Field field;
            private boolean validate;
            private Class<?>[] groups;

            private FormBeanAttr() {
            }

            private FormBeanAttr(PropertyDescriptor pd) {
                this.property = pd;
            }

            private FormBeanAttr(Field f) {
                this.field = f;
            }

            static /* synthetic */ Class[] access$1902(FormBeanAttr x0, Class[] x1) {
                x0.groups = x1;
                return x1;
            }
        }
    }
}

