/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.mvc;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Queue;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jessma.mvc.Action;
import org.jessma.mvc.ActionFilter;
import org.jessma.mvc.ActionSupport;
import org.jessma.util.BeanHelper;

public class ActionExecutor {
    private Queue<ActionFilter> filters;
    private Action action;
    private Method method;
    private ServletContext context;
    private HttpServletRequest request;
    private HttpServletResponse response;

    ActionExecutor(LinkedList<ActionFilter> filters, Action action, Method method, ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.action = action;
        this.method = method;
        this.context = context;
        this.request = request;
        this.response = response;
        this.filters = (Queue)filters.clone();
    }

    public String invoke() throws Exception {
        if (this.filters.isEmpty()) {
            return ActionExecutor.execute(this.action, this.method);
        }
        ActionFilter filter = this.filters.poll();
        return filter.doFilter(this);
    }

    static final String execute(Action action, Method method) throws Exception {
        ActionSupport asp;
        boolean valid = true;
        if (action instanceof ActionSupport && ActionSupport.isBeanValidationEnable() && (asp = (ActionSupport)action).isAutoValidation()) {
            valid = asp.validateFormBean();
        }
        if (valid) {
            valid = action.validate();
        }
        if (!valid) {
            return "input";
        }
        return (String)BeanHelper.invokeMethod(action, method, new Object[0]);
    }

    public Action getAction() {
        return this.action;
    }

    public Method getEntryMethod() {
        return this.method;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }
}

