/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.mvc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.ConstraintViolation;
import org.jessma.mvc.Action;
import org.jessma.mvc.ActionDispatcher;
import org.jessma.mvc.ActionTask;
import org.jessma.mvc.AsyncTask;
import org.jessma.mvc.AsyncTaskLauncher;
import org.jessma.mvc.BeanValidator;
import org.jessma.util.GeneralHelper;
import org.jessma.util.http.HttpHelper;

public class ActionSupport
implements Action {
    private ServletContext servletContext;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Object formBean;
    private boolean autoValidation;
    private Class<?>[] validationGroups;
    private Map<String, List<String>> errors;
    private static ActionDispatcher.BeanValidation validation;
    private static final List<String> NO_ERROR;
    private static final Map<String, List<String>> NO_ERRORS;
    public static final String ASYNC_COMPLETE = "complete";
    public static final String ASYNC_TIMEOUT = "timeout";
    public static final String ASYNC_ERROR = "error";
    private ActionDispatcher dispatcher;
    private ActionDispatcher.ActionPackage pkg;
    private ActionDispatcher.ActionEntryConfig aec;

    @Override
    public String execute() throws Exception {
        return "success";
    }

    @Override
    public boolean validate() {
        return true;
    }

    final boolean validateFormBean() {
        return this.validateBeanAndAddErrors(this.formBean, this.validationGroups);
    }

    protected final boolean validateBeanAndAddErrors(Object bean, Class<?> ... groups) {
        boolean valid = true;
        Set<ConstraintViolation<Object>> set = this.validateBean(bean, groups);
        if (!set.isEmpty()) {
            for (ConstraintViolation<Object> e : set) {
                this.addError(e.getPropertyPath().toString(), e.getMessage());
            }
            valid = false;
        }
        return valid;
    }

    protected final Set<ConstraintViolation<Object>> validateBean(Object bean, Class<?> ... groups) {
        Locale locale = this.getCurrentLocale();
        return ActionSupport.validation.validator.validate(bean, groups, ActionSupport.validation.bundle, locale);
    }

    static final void setBeanValidation(ActionDispatcher.BeanValidation validation) {
        ActionSupport.validation = validation;
    }

    static final ActionDispatcher.BeanValidation getBeanValidation() {
        return validation;
    }

    protected static final BeanValidator getBeanValidator() {
        return ActionSupport.validation.validator;
    }

    protected static final boolean isBeanValidationEnable() {
        return ActionSupport.validation.enable;
    }

    final void setFormBean(Object formBean) {
        this.formBean = formBean;
    }

    protected final Object getFormBean() {
        return this.formBean;
    }

    final void setAutoValidation(boolean autoValidation) {
        this.autoValidation = autoValidation;
    }

    protected final boolean isAutoValidation() {
        return this.autoValidation;
    }

    final void setValidationGroups(Class<?>[] groups) {
        this.validationGroups = groups;
    }

    protected final Class<?>[] getValidationGroups() {
        return this.validationGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addError(String key, String message) {
        if (this.errors == null) {
            ActionSupport actionSupport = this;
            synchronized (actionSupport) {
                if (this.errors == null) {
                    this.errors = new LinkedHashMap<String, List<String>>();
                }
            }
        }
        if (!this.errors.containsKey(key)) {
            this.errors.put(key, new ArrayList());
        }
        this.errors.get(key).add(message);
    }

    public final void addErrorByResource(String key, String resKey, Object ... params) {
        Locale locale = this.getCurrentLocale();
        String bundle = this.getDefaultValidationBundle();
        this.addErrorByResource(key, resKey, bundle, locale, params);
    }

    public final void addErrorByResource(String key, String resKey, String bundle, Locale locale, Object ... params) {
        if (locale == null) {
            locale = this.getCurrentLocale();
        }
        if (bundle == null) {
            bundle = this.getDefaultValidationBundle();
        }
        String message = GeneralHelper.getResourceMessage(locale, bundle, resKey, params);
        this.addError(resKey, message);
    }

    public final String getfirstError(String key) {
        return this.getError(key, 0);
    }

    public final String getError(String key, int index) {
        List<String> list = this.getErrors(key);
        if (list == null || index >= list.size()) {
            return "";
        }
        return list.get(index);
    }

    public final List<String> getErrors(String key) {
        if (this.errors == null || !this.errors.containsKey(key)) {
            return NO_ERROR;
        }
        return this.errors.get(key);
    }

    public final Map<String, List<String>> getAllErrors() {
        if (this.errors == null) {
            return NO_ERRORS;
        }
        return this.errors;
    }

    public final String getResourceMessage(String resKey, Object ... params) {
        return this.getResourceMessage(null, null, resKey, params);
    }

    public final String getResourceMessage(String bundle, Locale locale, String resKey, Object ... params) {
        if (locale == null) {
            locale = this.getCurrentLocale();
        }
        if (bundle == null) {
            bundle = this.getDefaultApplicationBundle();
        }
        return GeneralHelper.getResourceMessage(locale, bundle, resKey, params);
    }

    public final String getDefaultApplicationBundle() {
        String bundle = (String)this.getApplicationAttribute("__default_app_bundle");
        if (GeneralHelper.isStrEmpty(bundle)) {
            bundle = "res.application-message";
        }
        return bundle;
    }

    public final String getDefaultValidationBundle() {
        String bundle = ActionSupport.validation.bundle;
        if (GeneralHelper.isStrEmpty(bundle) && GeneralHelper.isStrEmpty(bundle = (String)this.getApplicationAttribute("__default_vld_bundle"))) {
            bundle = "res.application-message";
        }
        return bundle;
    }

    public final Locale getCurrentLocale() {
        Locale locale = (Locale)this.getRequestAttribute("__locale");
        if (locale == null && (locale = (Locale)this.getSessionAttribute("__locale")) == null) {
            locale = this.getRequestLocale();
        }
        return locale;
    }

    public final Locale getRequestLocale() {
        return HttpHelper.getRequestLocale(this.request);
    }

    public final List<Locale> getRequestLocales() {
        return HttpHelper.getRequestLocales(this.request);
    }

    public final <T> T getRequestAttribute(String name) {
        return HttpHelper.getRequestAttribute(this.request, name);
    }

    public final <T> void setRequestAttribute(String name, T value) {
        HttpHelper.setRequestAttribute(this.request, name, value);
    }

    public final void removeRequestAttribute(String name) {
        HttpHelper.removeRequestAttribute(this.request, name);
    }

    public final <T> T getSessionAttribute(String name) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            return HttpHelper.getSessionAttribute(session, name);
        }
        return null;
    }

    public final <T> void setSessionAttribute(String name, T value) {
        HttpSession session = this.getSession(true);
        HttpHelper.setSessionAttribute(session, name, value);
    }

    public final void removeSessionAttribute(String name) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            HttpHelper.removeSessionAttribute(session, name);
        }
    }

    public final void invalidateSession() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            HttpHelper.invalidateSession(session);
        }
    }

    public final <T> T getApplicationAttribute(String name) {
        return HttpHelper.getApplicationAttribute(this.servletContext, name);
    }

    public final <T> void setApplicationAttribute(String name, T value) {
        HttpHelper.setApplicationAttribute(this.servletContext, name, value);
    }

    public final void removeApplicationAttribute(String name) {
        HttpHelper.removeApplicationAttribute(this.servletContext, name);
    }

    public final String getParam(String name) {
        return HttpHelper.getParam(this.request, name);
    }

    public final String getParamNoTrim(String name) {
        return HttpHelper.getParamNoTrim(this.request, name);
    }

    public final List<String> getParamNames() {
        return HttpHelper.getParamNames(this.request);
    }

    public final List<String> getParamValues(String name) {
        return HttpHelper.getParamValues(this.request, name);
    }

    public final Map<String, String[]> getParamMap() {
        return HttpHelper.getParamMap(this.request);
    }

    public final Boolean getBooleanParam(String name) {
        return HttpHelper.getBooleanParam(this.request, name);
    }

    public final boolean getBooleanParam(String name, boolean def) {
        return HttpHelper.getBooleanParam(this.request, name, def);
    }

    public final Byte getByteParam(String name) {
        return HttpHelper.getByteParam(this.request, name);
    }

    public final byte getByteParam(String name, byte def) {
        return HttpHelper.getByteParam(this.request, name, def);
    }

    public final Character getCharParam(String name) {
        return HttpHelper.getCharParam(this.request, name);
    }

    public final char getCharParam(String name, char def) {
        return HttpHelper.getCharParam(this.request, name, def);
    }

    public final Short getShortParam(String name) {
        return HttpHelper.getShortParam(this.request, name);
    }

    public final short getShortParam(String name, short def) {
        return HttpHelper.getShortParam(this.request, name, def);
    }

    public final Integer getIntParam(String name) {
        return HttpHelper.getIntParam(this.request, name);
    }

    public final int getIntParam(String name, int def) {
        return HttpHelper.getIntParam(this.request, name, def);
    }

    public final Long getLongParam(String name) {
        return HttpHelper.getLongParam(this.request, name);
    }

    public final long getLongParam(String name, long def) {
        return HttpHelper.getLongParam(this.request, name, def);
    }

    public final Float getFloatParam(String name) {
        return HttpHelper.getFloatParam(this.request, name);
    }

    public final float getFloatParam(String name, float def) {
        return HttpHelper.getFloatParam(this.request, name, def);
    }

    public final Double getDoubleParam(String name) {
        return HttpHelper.getDoubleParam(this.request, name);
    }

    public final double getDoubleParam(String name, double def) {
        return HttpHelper.getDoubleParam(this.request, name, def);
    }

    public final Date getDateParam(String name) {
        return HttpHelper.getDateParam(this.request, name);
    }

    public final Date getDateParam(String name, String format) {
        return HttpHelper.getDateParam(this.request, name, format);
    }

    public final <T> T createFormBean(Class<T> clazz) {
        return HttpHelper.createFormBean(this.request, clazz);
    }

    public final <T> T createFormBean(Class<T> clazz, Map<String, String> keyMap) {
        return HttpHelper.createFormBean(this.request, clazz, keyMap);
    }

    public final <T> T createFormBeanByProperties(Class<T> clazz) {
        return HttpHelper.createFormBeanByProperties(this.request, clazz);
    }

    public final <T> T createFormBeanByProperties(Class<T> clazz, Map<String, String> keyMap) {
        return HttpHelper.createFormBeanByProperties(this.request, clazz, keyMap);
    }

    public final <T> T createFormBeanByFieldValues(Class<T> clazz) {
        return HttpHelper.createFormBeanByFieldValues(this.request, clazz);
    }

    public final <T> T createFormBeanByFieldValues(Class<T> clazz, Map<String, String> keyMap) {
        return HttpHelper.createFormBeanByFieldValues(this.request, clazz, keyMap);
    }

    public final <T> void fillFormBeanProperties(T bean) {
        HttpHelper.fillFormBeanProperties(this.request, bean);
    }

    public final <T> void fillFormBeanProperties(T bean, Map<String, String> keyMap) {
        HttpHelper.fillFormBeanProperties(this.request, bean, keyMap);
    }

    public final <T> void fillFormBeanFieldValues(T bean) {
        HttpHelper.fillFormBeanFieldValues(this.request, bean);
    }

    public final <T> void fillFormBeanFieldValues(T bean, Map<String, String> keyMap) {
        HttpHelper.fillFormBeanFieldValues(this.request, bean, keyMap);
    }

    public final <T> void fillFormBeanPropertiesOrFieldValues(T bean) {
        HttpHelper.fillFormBeanPropertiesOrFieldValues(this.request, bean);
    }

    public final <T> void fillFormBeanPropertiesOrFieldValues(T bean, Map<String, String> keyMap) {
        HttpHelper.fillFormBeanPropertiesOrFieldValues(this.request, bean, keyMap);
    }

    public final Cookie[] getCookies() {
        return HttpHelper.getCookies(this.request);
    }

    public final Cookie getCookie(String name) {
        return HttpHelper.getCookie(this.request, name);
    }

    public final String getCookieValue(String name) {
        return HttpHelper.getCookieValue(this.request, name);
    }

    public final void addCookie(Cookie cookie) {
        HttpHelper.addCookie(this.response, cookie);
    }

    public final void addCookie(String name, String value) {
        HttpHelper.addCookie(this.response, name, value);
    }

    public final Locale getLocale() {
        return (Locale)this.getSessionAttribute("__locale");
    }

    public final void setLocale(Locale locale) {
        if (locale != null) {
            this.setSessionAttribute("__locale", locale);
        } else {
            this.removeSessionAttribute("__locale");
        }
    }

    public final Locale getLocaleByCookie() {
        Locale locale = null;
        String lc = this.getCookieValue("__locale");
        if (lc != null) {
            locale = GeneralHelper.getAvailableLocale(lc);
        }
        return locale;
    }

    public final void setLocaleByCookie(Locale locale) {
        this.setLocaleByCookie(locale, -1, null, "/", false, false, 0, null);
    }

    public final void setLocaleByCookie(Locale locale, int maxAge) {
        this.setLocaleByCookie(locale, maxAge, null, "/", false, false, 0, null);
    }

    public final void setLocaleByCookie(Locale locale, int maxAge, String domain, String path) {
        this.setLocaleByCookie(locale, maxAge, domain, path, false, false, 0, null);
    }

    public final void setLocaleByCookie(Locale locale, int maxAge, String domain, String path, boolean secure, boolean httpOnly, int version, String comment) {
        String value = locale != null ? locale.toString() : this.getRequestLocale().toString();
        Cookie cookie = new Cookie("__locale", value);
        if (locale == null) {
            maxAge = 0;
        }
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        cookie.setSecure(secure);
        cookie.setVersion(version);
        cookie.setComment(comment);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        try {
            Method m = Cookie.class.getMethod("setHttpOnly", Boolean.TYPE);
            m.invoke((Object)cookie, httpOnly);
        }
        catch (Exception e) {
            // empty catch block
        }
        HttpHelper.addCookie(this.response, cookie);
        if (locale != null && maxAge != 0) {
            this.setRequestAttribute("__locale", locale);
        } else {
            this.removeRequestAttribute("__locale");
        }
    }

    public final String getRequestRealPath(String path) {
        return HttpHelper.getRequestRealPath(this.request, path);
    }

    public final String getRequestBasePath() {
        return HttpHelper.getRequestBasePath(this.request);
    }

    public final void setNoCacheHeader() {
        HttpHelper.setNoCacheHeader(this.response);
    }

    public final ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public final HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public final HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public final boolean isSessionExist() {
        return this.getSession(false) != null;
    }

    public final HttpSession getSession() {
        return this.getSession(true);
    }

    public final HttpSession getSession(boolean create) {
        return HttpHelper.getSession(this.request, create);
    }

    public final HttpSession createSession() {
        return this.getSession();
    }

    final void setActionDispatcher(ActionDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    final void setActionPackage(ActionDispatcher.ActionPackage pkg) {
        this.pkg = pkg;
    }

    final void setActionEntryConfig(ActionDispatcher.ActionEntryConfig aec) {
        this.aec = aec;
    }

    protected <T> T getAsyncCompleteResult() {
        return (T)ASYNC_COMPLETE;
    }

    protected <T> T getAsyncTimeoutResult() {
        return (T)ASYNC_TIMEOUT;
    }

    protected <T> T getAsyncErrorResult() {
        return (T)ASYNC_ERROR;
    }

    protected void checkTaskType(AsyncTask task) {
        if (!(task instanceof ActionTask)) {
            throw new IllegalArgumentException("the 'tast' arg must be subclass of " + ActionTask.class.getName());
        }
    }

    protected <T> void dispatchResult(HttpServletRequest request, HttpServletResponse response, T result) throws ServletException, IOException {
        this.dispatcher.dispatchResult(request, response, this.pkg, this.aec, this, (String)result);
    }

    protected void startAsync(AsyncTask task, AsyncListener ... listeners) {
        this.startAsync(task, -1L, (AsyncTaskLauncher)null, listeners);
    }

    protected void startAsync(AsyncTask task, long timeout, AsyncListener ... listeners) {
        this.startAsync(task, timeout, (AsyncTaskLauncher)null, listeners);
    }

    protected void startAsync(AsyncTask task, AsyncTaskLauncher launcher, AsyncListener ... listeners) {
        this.startAsync(task, -1L, launcher, listeners);
    }

    protected void startAsyncNoTimeout(AsyncTask task, AsyncListener ... listeners) {
        this.startAsync(task, 0L, (AsyncTaskLauncher)null, listeners);
    }

    protected void startAsyncNoTimeout(AsyncTask task, AsyncTaskLauncher launcher, AsyncListener ... listeners) {
        this.startAsync(task, 0L, launcher, listeners);
    }

    protected void startAsync(AsyncTask task, long timeout, AsyncTaskLauncher launcher, AsyncListener ... listeners) {
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        if (!request.isAsyncSupported()) {
            throw new UnsupportedOperationException("async operation is not supported by current request");
        }
        this.checkTaskType(task);
        AsyncContext ctx = request.startAsync((ServletRequest)request, (ServletResponse)response);
        if (timeout >= 0L) {
            ctx.setTimeout(timeout);
        }
        if (listeners != null) {
            for (AsyncListener listener : listeners) {
                ctx.addListener(listener, (ServletRequest)request, (ServletResponse)response);
            }
        }
        AsyncTaskRunner runner = new AsyncTaskRunner(ctx, task);
        if (launcher == null) {
            ctx.start((Runnable)runner);
        } else {
            launcher.start(runner);
        }
    }

    static {
        NO_ERROR = new ArrayList<String>();
        NO_ERRORS = new LinkedHashMap<String, List<String>>();
    }

    private class InternalAsyncListener
    implements AsyncListener {
        private static final byte START_ASYNC_FLAG = 1;
        private static final byte COMPLETE_FLAG = 2;
        private static final byte TIMEOUT_FLAG = 4;
        private static final byte ERROR_FLAG = 8;
        private byte flag;

        private InternalAsyncListener() {
        }

        private boolean hasStartAsync() {
            return (this.flag & 1) != 0;
        }

        private boolean hasComplete() {
            return (this.flag & 2) != 0;
        }

        private boolean hasTimeout() {
            return (this.flag & 4) != 0;
        }

        private boolean hasError() {
            return (this.flag & 8) != 0;
        }

        public synchronized void onComplete(AsyncEvent evt) throws IOException {
            this.setFlag((byte)2);
        }

        public synchronized void onError(AsyncEvent evt) throws IOException {
            this.setFlag((byte)8);
            if (!this.hasComplete() && !this.hasTimeout()) {
                Object result = ActionSupport.this.getAsyncErrorResult();
                this.dispatch(evt, result);
            }
        }

        public synchronized void onStartAsync(AsyncEvent evt) throws IOException {
            this.setFlag((byte)1);
        }

        public synchronized void onTimeout(AsyncEvent evt) throws IOException {
            this.setFlag((byte)4);
            if (!this.hasComplete() && !this.hasError()) {
                Object result = ActionSupport.this.getAsyncTimeoutResult();
                this.dispatch(evt, result);
            }
        }

        private void setFlag(byte f) {
            this.flag = (byte)(this.flag | f);
        }

        private void dispatch(AsyncEvent evt, Object result) {
            HttpServletRequest request = (HttpServletRequest)evt.getAsyncContext().getRequest();
            HttpServletResponse response = (HttpServletResponse)evt.getAsyncContext().getResponse();
            try {
                ActionSupport.this.dispatchResult(request, response, result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class AsyncTaskRunner
    implements Runnable {
        private AsyncContext ctx;
        private AsyncTask task;
        private InternalAsyncListener listener;

        private AsyncTaskRunner(AsyncContext ctx, AsyncTask task) {
            this.listener = new InternalAsyncListener();
            this.ctx = ctx;
            this.task = task;
            task.setAsyncContext(ctx);
            ctx.addListener((AsyncListener)this.listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object result = this.task.run();
                InternalAsyncListener internalAsyncListener = this.listener;
                synchronized (internalAsyncListener) {
                    this.listener.setFlag((byte)2);
                    if (!this.listener.hasTimeout() && !this.listener.hasError()) {
                        HttpServletRequest request = (HttpServletRequest)this.ctx.getRequest();
                        HttpServletResponse response = (HttpServletResponse)this.ctx.getResponse();
                        ActionSupport.this.dispatchResult(request, response, result);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    InternalAsyncListener internalAsyncListener = this.listener;
                    synchronized (internalAsyncListener) {
                        this.listener.setFlag((byte)2);
                        if (!this.listener.hasTimeout() && !this.listener.hasError()) {
                            this.ctx.complete();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

