/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.mvc.validation;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.jessma.mvc.BeanValidator;
import org.jessma.util.GeneralHelper;

public class HibernateBeanValidator
implements BeanValidator {
    private Map<BeanValidator.ValidatorKey, Validator> validatorMap;

    @Override
    public void init() {
        this.validatorMap = new HashMap<BeanValidator.ValidatorKey, Validator>();
    }

    @Override
    public void destroy() {
        this.validatorMap.clear();
    }

    @Override
    public Set<ConstraintViolation<Object>> validate(Object bean, Class<?>[] groups, String bundle, Locale locale) {
        BeanValidator.ValidatorKey key = new BeanValidator.ValidatorKey(groups, bundle, locale);
        Validator validator = this.validatorMap.get(key);
        if (validator == null) {
            validator = this.tryCreateValidator(bundle, locale, key);
        }
        return validator.validate(bean, (Class[])groups);
    }

    private Validator tryCreateValidator(String bundle, final Locale locale, BeanValidator.ValidatorKey key) {
        HibernateValidatorConfiguration configure = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure();
        configure.messageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator((ResourceBundleLocator)new PlatformResourceBundleLocator(bundle)){

            public String interpolate(String message, MessageInterpolator.Context context) {
                return super.interpolate(message, context, locale);
            }
        });
        ValidatorFactory vf = configure.buildValidatorFactory();
        Validator validator = vf.getValidator();
        GeneralHelper.syncTryPut(this.validatorMap, key, validator);
        return this.validatorMap.get(key);
    }
}

