/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.jessma.mvc.ActionSupport;
import org.jessma.util.GeneralHelper;

public class Error
extends SimpleTagSupport {
    private String key;
    private int index = -1;
    private String element;
    private boolean escape = true;
    private String cssClass;
    private String cssStyle;
    private String cssAlign;
    private String cssId;
    private String cssDir;
    private String cssLang;
    private String cssTitle;
    private String cssType;
    private String cssCompact;
    private String cssStart;
    private String cssAttrs;

    public void doTag() throws JspException, IOException {
        PageContext context = (PageContext)this.getJspContext();
        ArrayList<String> list = new ArrayList<String>();
        this.fillErrorList(context, list);
        if (list.isEmpty()) {
            return;
        }
        Element e = Element.fromString(this.element);
        String html = e.write(this, list);
        this.getJspContext().getOut().print(html);
    }

    private void fillErrorList(PageContext context, List<String> list) {
        ActionSupport action = (ActionSupport)context.findAttribute("__action");
        if (action == null) {
            return;
        }
        if (GeneralHelper.isStrEmpty(this.key)) {
            Map<String, List<String>> errors = action.getAllErrors();
            if (this.index == -1) {
                Collection<List<String>> col = errors.values();
                for (List<String> err : col) {
                    list.addAll(err);
                }
            } else {
                Set<String> set = errors.keySet();
                for (String key : set) {
                    String value = action.getError(key, this.index);
                    if (!GeneralHelper.isStrNotEmpty(value)) continue;
                    list.add(value);
                }
            }
        } else if (this.index == -1) {
            list.addAll(action.getErrors(this.key));
        } else {
            String value = action.getError(this.key, this.index);
            if (GeneralHelper.isStrNotEmpty(value)) {
                list.add(value);
            }
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public void setCssAlign(String cssAlign) {
        this.cssAlign = cssAlign;
    }

    public void setCssId(String cssId) {
        this.cssId = cssId;
    }

    public void setCssDir(String cssDir) {
        this.cssDir = cssDir;
    }

    public void setCssLang(String cssLang) {
        this.cssLang = cssLang;
    }

    public void setCssTitle(String cssTitle) {
        this.cssTitle = cssTitle;
    }

    public void setCssType(String cssType) {
        this.cssType = cssType;
    }

    public void setCssCompact(String cssCompact) {
        this.cssCompact = cssCompact;
    }

    public void setCssStart(String cssStart) {
        this.cssStart = cssStart;
    }

    public void setCssAttrs(String cssAttrs) {
        this.cssAttrs = cssAttrs;
    }

    static enum Element {
        SPAN,
        DIV{

            @Override
            protected void writeAttrs(Error tag, StringBuilder sb) {
                if (tag.cssAlign != null) {
                    sb.append(" align=\"").append(tag.cssAlign).append("\"");
                }
                super.writeAttrs(tag, sb);
            }
        }
        ,
        UL{

            @Override
            protected void writeAttrs(Error tag, StringBuilder sb) {
                if (tag.cssType != null) {
                    sb.append(" type=\"").append(tag.cssType).append("\"");
                }
                if (tag.cssCompact != null) {
                    sb.append(" compact=\"").append(tag.cssCompact).append("\"");
                }
                super.writeAttrs(tag, sb);
            }

            @Override
            protected void writeBody(Error tag, List<String> list, StringBuilder sb) {
                this.writeBodyLI(tag, list, sb);
            }
        }
        ,
        OL{

            @Override
            protected void writeAttrs(Error tag, StringBuilder sb) {
                if (tag.cssType != null) {
                    sb.append(" type=\"").append(tag.cssType).append("\"");
                }
                if (tag.cssCompact != null) {
                    sb.append(" compact=\"").append(tag.cssCompact).append("\"");
                }
                if (tag.cssStart != null) {
                    sb.append(" start=\"").append(tag.cssStart).append("\"");
                }
                super.writeAttrs(tag, sb);
            }

            @Override
            protected void writeBody(Error tag, List<String> list, StringBuilder sb) {
                this.writeBodyLI(tag, list, sb);
            }
        };

        static final Element DEFAULT;

        public String toString() {
            return super.toString().toLowerCase();
        }

        static Element fromString(String name) {
            if (GeneralHelper.isStrEmpty(name)) {
                return DEFAULT;
            }
            Element e = Element.valueOf(name.toUpperCase());
            if (e == null) {
                e = DEFAULT;
            }
            return e;
        }

        String write(Error tag, List<String> list) {
            StringBuilder sb = new StringBuilder();
            sb.append("<").append((Object)this);
            this.writeAttrs(tag, sb);
            sb.append(">");
            this.writeBody(tag, list, sb);
            sb.append("</").append((Object)this).append(">");
            return sb.toString();
        }

        protected void writeAttrs(Error tag, StringBuilder sb) {
            if (tag.cssClass != null) {
                sb.append(" class=\"").append(tag.cssClass).append("\"");
            }
            if (tag.cssStyle != null) {
                sb.append(" style=\"").append(tag.cssStyle).append("\"");
            }
            if (tag.cssId != null) {
                sb.append(" id=\"").append(tag.cssId).append("\"");
            }
            if (tag.cssDir != null) {
                sb.append(" dir=\"").append(tag.cssDir).append("\"");
            }
            if (tag.cssLang != null) {
                sb.append(" lang=\"").append(tag.cssLang).append("\"");
            }
            if (tag.cssTitle != null) {
                sb.append(" title=\"").append(tag.cssTitle).append("\"");
            }
            if (tag.cssAttrs != null) {
                sb.append(" ").append(tag.cssAttrs);
            }
        }

        protected void writeBody(Error tag, List<String> list, StringBuilder sb) {
            this.writeStyleBodyBR(tag, list, sb);
        }

        protected void writeStyleBodyBR(Error tag, List<String> list, StringBuilder sb) {
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0) {
                    sb.append("<br/>");
                }
                String msg = list.get(i);
                if (tag.escape) {
                    msg = GeneralHelper.escapeXML(msg);
                }
                sb.append(msg);
            }
        }

        protected void writeBodyLI(Error tag, List<String> list, StringBuilder sb) {
            for (String msg : list) {
                if (tag.escape) {
                    msg = GeneralHelper.escapeXML(msg);
                }
                sb.append("<li>").append(msg).append("</li>");
            }
        }

        static {
            DEFAULT = SPAN;
        }
    }
}

