/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class LogUtil {
    public static final String JESSMA_LOGGER_NAME = "JessMA";
    public static final Logger jessMALogger = LoggerFactory.getLogger((String)"JessMA");

    public static final Logger getJessMALogger() {
        return jessMALogger;
    }

    public static final Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz);
    }

    public static final Logger getLogger(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    public static final void exception(Throwable e, Object action, boolean printStack) {
        LogUtil.exception(jessMALogger, e, action, printStack);
    }

    public static final void exception(Logger logger, Throwable e, Object action, boolean printStack) {
        StringBuilder msg = new StringBuilder("Execption occur on ");
        msg.append(action);
        msg.append(" -> ");
        msg.append(e.toString());
        String error = msg.toString();
        if (printStack) {
            logger.error(error, e);
        } else {
            logger.error(error);
        }
    }

    public static final void fail(Object action, Object module, boolean printStack) {
        LogUtil.fail(jessMALogger, action, module, printStack);
    }

    public static final void fail(Logger logger, Object action, Object module, boolean printStack) {
        StringBuilder msg = new StringBuilder("Operation fail on ");
        msg.append(action);
        msg.append(" -> ");
        msg.append(module);
        logger.error(msg.toString());
    }

    public static final void logServerStartup(Object o) {
        jessMALogger.info("->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->->");
        jessMALogger.info("starting: {}", o);
    }

    public static final void logServerShutdown(Object o) {
        jessMALogger.info("stoping: {}", o);
        jessMALogger.info("<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-<-");
    }

    static {
        if (jessMALogger == NOPLogger.NOP_LOGGER) {
            System.err.println("!!! --> JessMA Logger is not valid, please check <-- !!!");
        }
    }
}

