/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.jessma.util.CryptHelper;
import org.jessma.util.GeneralHelper;

public class PackageHelper {
    private static final char FILE_EXT_CHAR = '.';
    private static final char PACKAGE_SEP_CHAR = '.';
    private static final char PATH_SEP_CHAR = '/';
    private static final char INNER_CLS_SEP_CHAR = '$';
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_PROTOCOL = "jar";
    private static final String PATH_SEP_STR = "/";
    private static final String EMPTY_STR = "";
    private static final String CLASS_SUFFIX = ".class";
    private static final int CLASS_SUFFIX_LEN = ".class".length();

    public static final Set<Class<?>> getClasses(String basePackage, boolean recursive) {
        return PackageHelper.getClasses(basePackage, recursive, (ClassFilter)null);
    }

    public static final Set<Class<?>> getClasses(String basePackage, boolean recursive, Class<?> compatibleType) {
        return PackageHelper.getClasses(basePackage, recursive, new CompatibleTypeFilter(compatibleType));
    }

    public static final Set<Class<?>> getClasses(String basePackage, boolean recursive, ClassFilter classFilter) {
        return PackageHelper.getClasses(basePackage, recursive, classFilter, new TopLevelClassFileFilter());
    }

    public static final Set<Class<?>> getClasses(String basePackage, boolean recursive, ClassFilter classFilter, ResourceFilter resourceFilter) {
        HashSet classes = new HashSet();
        String basePackagePath = basePackage.replace('.', '/');
        Set<String> names = PackageHelper.getResourceNames(basePackagePath, recursive, resourceFilter);
        for (String name : names) {
            String className = name.substring(0, name.length() - CLASS_SUFFIX_LEN);
            Class<?> clazz = GeneralHelper.loadClass(className = className.replace('/', '.'));
            if (clazz == null || classFilter != null && !classFilter.accept(clazz)) continue;
            classes.add(clazz);
        }
        return classes;
    }

    public static final Set<String> getResourceNames(String basePackagePath, boolean recursive) {
        return PackageHelper.getResourceNames(basePackagePath, recursive, null);
    }

    public static final Set<String> getResourceNames(String basePackagePath, boolean recursive, ResourceFilter filter) {
        basePackagePath = PackageHelper.adjustBasePackagePath(basePackagePath);
        HashSet<String> names = new HashSet<String>();
        List<URL> urlList = GeneralHelper.getClassResources(PackageHelper.class, basePackagePath);
        for (URL url : urlList) {
            String protocol = url.getProtocol();
            if (protocol.equals(FILE_PROTOCOL)) {
                String filePath = CryptHelper.urlDecode(url.getPath());
                int packageStartIndex = filePath.lastIndexOf(basePackagePath);
                PackageHelper.scanResourceNamesByFile(filePath, packageStartIndex, recursive, filter, names);
                continue;
            }
            if (!protocol.equals(JAR_PROTOCOL)) continue;
            PackageHelper.scanResourceNamesByJar(url, basePackagePath, recursive, filter, names);
        }
        return names;
    }

    public static final void scanResourceNamesByFile(String filePath, int packageStartIndex, boolean recursive, Set<String> names) {
        PackageHelper.scanResourceNamesByFile(filePath, packageStartIndex, recursive, null, names);
    }

    public static final void scanResourceNamesByFile(String filePath, int packageStartIndex, final boolean recursive, final ResourceFilter filter, Set<String> names) {
        File[] files;
        if (filePath.endsWith(PATH_SEP_STR)) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        if (packageStartIndex > filePath.length()) {
            packageStartIndex = filePath.length();
        }
        final String basePackagePath = filePath.substring(packageStartIndex);
        File dir = new File(filePath);
        for (File file : files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return recursive;
                }
                if (filter != null) {
                    String fileName = file.getName();
                    return filter.accept(basePackagePath, fileName);
                }
                return true;
            }
        })) {
            String name = file.getName();
            if (file.isDirectory()) {
                String subPath = filePath + '/' + name;
                PackageHelper.scanResourceNamesByFile(subPath, packageStartIndex, recursive, filter, names);
                continue;
            }
            if (basePackagePath.length() != 0) {
                name = basePackagePath + '/' + name;
            }
            if (name.startsWith(PATH_SEP_STR)) {
                name = name.substring(1, name.length());
            }
            names.add(name);
        }
    }

    public static final void scanResourceNamesByJar(URL url, String basePackagePath, boolean recursive, Set<String> names) {
        PackageHelper.scanResourceNamesByJar(url, basePackagePath, recursive, null, names);
    }

    public static final void scanResourceNamesByJar(URL url, String basePackagePath, boolean recursive, ResourceFilter filter, Set<String> names) {
        basePackagePath = PackageHelper.adjustBasePackagePath(basePackagePath);
        try {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String simpleName;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                int nameIndex = name.lastIndexOf(47);
                if (entry.isDirectory() || !name.startsWith(basePackagePath) || !recursive && nameIndex != basePackagePath.length()) continue;
                String packagePath = nameIndex != -1 ? name.substring(0, nameIndex) : EMPTY_STR;
                String string = simpleName = nameIndex != -1 ? name.substring(nameIndex + 1) : name;
                if (filter != null && !filter.accept(packagePath, simpleName)) continue;
                names.add(name);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final Set<String> getPackages(String pattern) {
        return PackageHelper.getPackages(EMPTY_STR, pattern);
    }

    public static final Set<String> getPackages(String basePackage, String pattern) {
        return PackageHelper.getPackages(basePackage, new PatternFilter(pattern));
    }

    public static final Set<String> getPackages(String basePackage, PackageFilter filter) {
        String basePackagePath = basePackage.replace('.', '/');
        basePackagePath = PackageHelper.adjustBasePackagePath(basePackagePath);
        HashSet<String> names = new HashSet<String>();
        List<URL> urlList = GeneralHelper.getClassResources(PackageHelper.class, basePackagePath);
        for (URL url : urlList) {
            String protocol = url.getProtocol();
            if (protocol.equals(FILE_PROTOCOL)) {
                String filePath = CryptHelper.urlDecode(url.getPath());
                int packageStartIndex = filePath.lastIndexOf(basePackagePath);
                PackageHelper.scanPackageNamesByFile(filePath, packageStartIndex, filter, names);
                continue;
            }
            if (!protocol.equals(JAR_PROTOCOL)) continue;
            PackageHelper.scanPackageNamesByJar(url, basePackagePath, filter, names);
        }
        return names;
    }

    public static final void scanPackageNamesByFile(String filePath, int packageStartIndex, Set<String> names) {
        PackageHelper.scanPackageNamesByFile(filePath, packageStartIndex, null, names);
    }

    public static final void scanPackageNamesByFile(String filePath, int packageStartIndex, PackageFilter filter, Set<String> names) {
        File[] files;
        if (filePath.endsWith(PATH_SEP_STR)) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        if (packageStartIndex > filePath.length()) {
            packageStartIndex = filePath.length();
        }
        String basePackagePath = filePath.substring(packageStartIndex);
        File dir = new File(filePath);
        for (File file : files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            String name;
            String packageName = name = file.getName();
            if (basePackagePath.length() != 0) {
                packageName = basePackagePath + '/' + packageName;
            }
            if (packageName.startsWith(PATH_SEP_STR)) {
                packageName = packageName.substring(1, packageName.length());
            }
            packageName = packageName.replace('/', '.');
            if (filter == null || filter.accept(packageName)) {
                names.add(packageName);
            }
            String subPath = filePath + '/' + name;
            PackageHelper.scanPackageNamesByFile(subPath, packageStartIndex, filter, names);
        }
    }

    public static final void scanPackageNamesByJar(URL url, String basePackagePath, Set<String> names) {
        PackageHelper.scanPackageNamesByJar(url, basePackagePath, null, names);
    }

    public static final void scanPackageNamesByJar(URL url, String basePackagePath, PackageFilter filter, Set<String> names) {
        basePackagePath = PackageHelper.adjustBasePackagePath(basePackagePath);
        try {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!entry.isDirectory() || !name.startsWith(basePackagePath)) continue;
                if (name.endsWith(PATH_SEP_STR)) {
                    name = name.substring(0, name.length() - 1);
                }
                if (name.equals(basePackagePath)) continue;
                String packageName = name.replace('/', '.');
                if (filter != null && !filter.accept(packageName)) continue;
                names.add(packageName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final String adjustBasePackagePath(String basePackagePath) {
        if ((basePackagePath = GeneralHelper.safeTrimString(basePackagePath).replace('.', '/')).startsWith(PATH_SEP_STR)) {
            basePackagePath = basePackagePath.substring(1, basePackagePath.length());
        }
        if (basePackagePath.endsWith(PATH_SEP_STR)) {
            basePackagePath = basePackagePath.substring(0, basePackagePath.length() - 1);
        }
        return basePackagePath;
    }

    public static class PatternFilter
    implements PackageFilter {
        Pattern pattern;

        public PatternFilter(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public boolean accept(String packageName) {
            return this.pattern.matcher(packageName).matches();
        }
    }

    public static interface PackageFilter {
        public boolean accept(String var1);
    }

    public static class CompatibleTypeFilter
    implements ClassFilter {
        private Class<?> clazz;

        public CompatibleTypeFilter(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean accept(Class<?> clazz) {
            return this.clazz.isAssignableFrom(clazz);
        }
    }

    public static interface ClassFilter {
        public boolean accept(Class<?> var1);
    }

    public static class TopLevelClassFileFilter
    extends FileTypeFilter {
        public TopLevelClassFileFilter() {
            super(PackageHelper.CLASS_SUFFIX);
        }

        @Override
        public boolean accept(String packagePath, String fileName) {
            return super.accept(packagePath, fileName) && fileName.indexOf(36) == -1;
        }
    }

    public static class FileTypesFilter
    implements ResourceFilter {
        private Set<String> suffixes = new HashSet<String>();

        public FileTypesFilter(String suffix1, String ... suffixN) {
            HashSet<String> suffixes = new HashSet<String>(suffixN.length + 1);
            suffixes.add(suffix1);
            suffixes.addAll(Arrays.asList(suffixN));
            this.setSuffixes(suffixes);
        }

        public FileTypesFilter(Set<String> suffixes) {
            this.setSuffixes(suffixes);
        }

        private void setSuffixes(Set<String> suffixes) {
            for (String suffix : suffixes) {
                int index = suffix.lastIndexOf(46);
                if (index != -1) {
                    this.suffixes.add(suffix.substring(index));
                    continue;
                }
                this.suffixes.add('.' + suffix);
            }
        }

        @Override
        public boolean accept(String packagePath, String fileName) {
            int index = fileName.lastIndexOf(46);
            if (index == -1) {
                return false;
            }
            String suffix = fileName.substring(index);
            return this.suffixes.contains(suffix);
        }
    }

    public static class FileTypeFilter
    implements ResourceFilter {
        private String suffix;

        public FileTypeFilter(String suffix) {
            int index = suffix.lastIndexOf(46);
            this.suffix = index != -1 ? suffix.substring(index) : '.' + suffix;
        }

        @Override
        public boolean accept(String packagePath, String fileName) {
            return fileName.endsWith(this.suffix);
        }
    }

    public static interface ResourceFilter {
        public boolean accept(String var1, String var2);
    }
}

