/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.util;

import java.util.List;
import org.jessma.util.Range;

public class Pagination {
    public static final int DEFAULT_PAGE_SIZE = 10;
    private int rowCount;
    private int currentPage = 1;
    private int pageSize;
    private int pageCount;
    private List<?> list;

    public Pagination(List<?> list) {
        this(list, 10);
    }

    public Pagination(List<?> list, int pageSize) {
        this.list = list;
        this.rowCount = list.size();
        this.setPageSize(pageSize);
    }

    private void adjustPageCount() {
        this.pageCount = (this.rowCount + this.pageSize - 1) / this.pageSize;
    }

    public List<?> getList() {
        return this.list;
    }

    public List<?> getCurrentList() {
        List<?> currentList = null;
        if (this.currentPage >= 1 && this.currentPage <= this.pageCount) {
            int index = (this.currentPage - 1) * this.pageSize;
            currentList = this.list.subList(index, this.currentPage < this.pageCount ? index + this.pageSize : this.rowCount);
        }
        return currentList;
    }

    public Range<Integer> getCurrentRange() {
        Range<Integer> range = null;
        if (this.currentPage >= 1 && this.currentPage <= this.pageCount) {
            int begin = (this.currentPage - 1) * this.pageSize;
            int end = this.currentPage < this.pageCount ? begin + this.pageSize : this.rowCount;
            range = new Range<Integer>(begin + 1, end);
        }
        return range;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public boolean setCurrentPage(int page) {
        if (page >= 1 && page <= this.pageCount) {
            this.currentPage = page;
            return true;
        }
        return false;
    }

    public boolean nextPage() {
        return this.setCurrentPage(this.currentPage + 1);
    }

    public boolean prePage() {
        return this.setCurrentPage(this.currentPage - 1);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int size) {
        if (size <= 0) {
            size = 10;
        }
        int index = (this.currentPage - 1) * this.pageSize;
        this.pageSize = size;
        this.currentPage = index > this.pageSize ? (index + this.pageSize - 1) / this.pageSize : 1;
        this.adjustPageCount();
    }

    public int getPageCount() {
        return this.pageCount;
    }
}

