/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.util.archive;

import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.PatternSet;
import org.jessma.util.archive.TaskExecutor;

public abstract class UnArchiver
extends TaskExecutor {
    boolean overwrite = true;

    public UnArchiver(String source) {
        super(source);
    }

    public UnArchiver(String source, String target) {
        super(source, target);
    }

    protected abstract Expand getExpand();

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overWrite) {
        this.overwrite = overWrite;
    }

    protected File getSourceFile() {
        return new File(this.source);
    }

    protected File getTargetDir() {
        if (this.target != null) {
            return new File(this.target);
        }
        return this.getSourceFile().getParentFile();
    }

    protected PatternSet getPatternSet() {
        PatternSet ps = null;
        if (this.includes != null || this.excludes != null) {
            ps = new PatternSet();
            if (this.includes != null) {
                ps.setIncludes(this.includes);
            }
            if (this.excludes != null) {
                ps.setExcludes(this.excludes);
            }
        }
        return ps;
    }

    @Override
    protected Task getTask() {
        Project project = new Project();
        Expand expand = this.getExpand();
        PatternSet ps = this.getPatternSet();
        expand.setProject(project);
        expand.setSrc(this.getSourceFile());
        expand.setDest(this.getTargetDir());
        expand.setOverwrite(this.isOverwrite());
        if (ps != null) {
            ps.setProject(project);
            expand.addPatternset(ps);
        }
        return expand;
    }
}

