/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.util.archive;

import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.jessma.util.GeneralHelper;
import org.jessma.util.archive.Archiver;

public class Zipper
extends Archiver {
    public static final String SUFFIX = ".zip";
    public static final String DEFAULT_ENCODING = GeneralHelper.IS_WINDOWS_PLATFORM ? "GBK" : "UTF-8";
    private String comment;
    private String encoding = DEFAULT_ENCODING;

    public Zipper(String source) {
        super(source);
    }

    public Zipper(String source, String target) {
        super(source, target);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getSuffix() {
        return SUFFIX;
    }

    @Override
    protected Task getTask() {
        Project project = new Project();
        Zip zip = new Zip();
        FileSet src = this.getSourceFileSet();
        src.setProject(project);
        zip.setProject(project);
        zip.setDestFile(this.getTargetFile());
        zip.addFileset(src);
        if (this.encoding != null) {
            zip.setEncoding(this.encoding);
        }
        if (this.comment != null) {
            zip.setComment(this.comment);
        }
        return zip;
    }

    private FileSet getSourceFileSet() {
        File f = new File(this.source);
        FileSet fs = new FileSet();
        this.fillFileSetAttributes(fs, f);
        return fs;
    }
}

