/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.util.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jessma.util.GeneralHelper;
import org.jessma.util.Range;
import org.jessma.util.http.HttpHelper;

public class FileDownloader {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String DEFAULT_CONTENT_TYPE = "application/force-download";
    private static final String WINDOWS_AGENT_CHARSET = "GBK";
    private static final String DEFAULT_AGENT_CHARSET = "UTF-8";
    private String saveFileName;
    private String contentType = "application/force-download";
    private int bufferSize = 4096;
    private String filePath;
    private byte[] bytes;
    private InputStream stream;
    private Mode mode;
    private Throwable cause;

    public FileDownloader() {
    }

    public FileDownloader(String filePath) {
        this(filePath, DEFAULT_CONTENT_TYPE);
    }

    public FileDownloader(String filePath, String contentType) {
        this(filePath, contentType, new File(filePath).getName());
    }

    public FileDownloader(String filePath, String contentType, String saveFileName) {
        this(filePath, contentType, saveFileName, 4096);
    }

    public FileDownloader(String filePath, String contentType, String saveFileName, int bufferSize) {
        this.filePath = filePath;
        this.contentType = contentType;
        this.saveFileName = saveFileName;
        this.bufferSize = bufferSize;
        this.mode = Mode.FILE;
    }

    public FileDownloader(byte[] bytes, String saveFileName) {
        this(bytes, DEFAULT_CONTENT_TYPE, saveFileName);
    }

    public FileDownloader(byte[] bytes, String contentType, String saveFileName) {
        this(bytes, contentType, saveFileName, 4096);
    }

    public FileDownloader(byte[] bytes, String contentType, String saveFileName, int bufferSize) {
        this.bytes = bytes;
        this.contentType = contentType;
        this.saveFileName = saveFileName;
        this.bufferSize = bufferSize;
        this.mode = Mode.BYTES;
    }

    public FileDownloader(InputStream is, String saveFileName) {
        this(is, DEFAULT_CONTENT_TYPE, saveFileName);
    }

    public FileDownloader(InputStream is, String contentType, String saveFileName) {
        this(is, contentType, saveFileName, 4096);
    }

    public FileDownloader(InputStream is, String contentType, String saveFileName, int bufferSize) {
        this.stream = is;
        this.contentType = contentType;
        this.saveFileName = saveFileName;
        this.bufferSize = bufferSize;
        this.mode = Mode.STREAM;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
        this.mode = Mode.FILE;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
        this.mode = Mode.BYTES;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
        this.mode = Mode.STREAM;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getSaveFileName() {
        return this.saveFileName;
    }

    public void setSaveFileName(String saveFileName) {
        this.saveFileName = saveFileName;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Throwable getCause() {
        return this.cause;
    }

    private void reset() {
        this.cause = null;
    }

    public Result download(HttpServletRequest request, HttpServletResponse response) {
        this.reset();
        try {
            if (this.mode == null) {
                throw new IllegalStateException("can not distinguish download mode");
            }
            switch (this.mode) {
                case FILE: {
                    File file = this.getFile(request);
                    this.downloadFile(request, response, file);
                    break;
                }
                case BYTES: {
                    this.checkBytes();
                    this.downloadBytes(request, response);
                    break;
                }
                case STREAM: {
                    this.checkStream();
                    this.downloadStream(request, response);
                }
            }
        }
        catch (Exception e) {
            this.cause = e;
            if (e instanceof FileNotFoundException) {
                return Result.FILE_NOT_FOUND;
            }
            if (e instanceof IOException) {
                return Result.READ_WRITE_FAIL;
            }
            if (e instanceof IllegalStateException) {
                return Result.ILLEGAL_STATE;
            }
            if (e instanceof IllegalArgumentException) {
                return Result.ILLEGAL_ARG;
            }
            return Result.UNKNOWN_EXCEPTION;
        }
        return Result.SUCCESS;
    }

    private void downloadFile(HttpServletRequest request, HttpServletResponse response, File file) throws IOException {
        int length = (int)file.length();
        Range<Integer> range = this.prepareDownload(request, response, length);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        this.doDownload(response, is, range);
    }

    private void downloadBytes(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int length = this.bytes.length;
        Range<Integer> range = this.prepareDownload(request, response, length);
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(this.bytes));
        this.doDownload(response, is, range);
    }

    private void downloadStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int length = this.stream.available();
        Range<Integer> range = this.prepareDownload(request, response, length);
        BufferedInputStream is = new BufferedInputStream(this.stream);
        this.doDownload(response, is, range);
    }

    private Range<Integer> prepareDownload(HttpServletRequest request, HttpServletResponse response, int length) throws UnsupportedEncodingException {
        String charset = HttpHelper.isRequestNotComeFromWidnows(request) ? DEFAULT_AGENT_CHARSET : WINDOWS_AGENT_CHARSET;
        String fileName = new String(this.saveFileName.getBytes(charset), "ISO-8859-1");
        Range<Integer> range = FileDownloader.parseDownloadRange(request);
        int begin = 0;
        int end = length - 1;
        response.setContentType(this.contentType);
        response.setContentLength(length);
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        if (range != null) {
            if (range.getBegin() != null) {
                begin = range.getBegin();
                if (range.getEnd() != null) {
                    end = range.getEnd();
                }
            } else if (range.getEnd() != null) {
                begin = Math.max(end + range.getEnd() + 1, 0);
            }
            String contentRange = String.format("bytes %d-%d/%d", begin, end, length);
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Range", contentRange);
            response.setStatus(206);
        }
        return new Range<Integer>(begin, end);
    }

    private static Range<Integer> parseDownloadRange(HttpServletRequest request) {
        int length;
        int preIndex;
        Range<Integer> range = null;
        String header = request.getHeader("Range");
        if (header != null && (preIndex = header.indexOf(61)) != -1 && (length = (header = header.substring(preIndex + 1).trim()).length()) > 0) {
            int sepIndex = header.indexOf(45);
            range = new Range<Integer>();
            if (sepIndex >= 0) {
                int end;
                String str = header.substring(0, sepIndex);
                int begin = GeneralHelper.str2Int(str, -1);
                if (begin != -1) {
                    range.setBegin(begin);
                }
                if (sepIndex < length - 1 && (end = GeneralHelper.str2Int(str = header.substring(sepIndex + 1, length), -1)) != -1) {
                    range.setEnd(begin != -1 ? end : -end);
                }
            } else {
                int point = GeneralHelper.str2Int(header, -1);
                if (point != -1) {
                    range.setBegin(point);
                    range.setEnd(point);
                }
            }
        }
        return range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDownload(HttpServletResponse response, InputStream is, Range<Integer> range) throws IOException {
        int begin = range.getBegin();
        int end = range.getEnd();
        OutputStream os = null;
        try {
            int i;
            byte[] b = new byte[this.bufferSize];
            os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            is.skip(begin);
            for (int left = end - begin + 1; left > 0 && (i = is.read(b, 0, Math.min(b.length, left))) != -1; left -= i) {
                os.write(b, 0, i);
            }
            os.flush();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private File getFile(HttpServletRequest request) throws FileNotFoundException {
        File file = new File(this.filePath);
        if (!file.isAbsolute()) {
            file = new File(HttpHelper.getRequestRealPath(request, this.filePath));
        }
        if (!file.isFile()) {
            throw new FileNotFoundException(String.format("file '%s' not found or is directory", this.filePath));
        }
        this.checkDownloadParam(file.getName());
        return file;
    }

    private void checkBytes() throws FileNotFoundException, IllegalArgumentException {
        if (this.bytes == null) {
            throw new FileNotFoundException("input byte array is null");
        }
        this.checkDownloadParam(null);
    }

    private void checkStream() throws FileNotFoundException, IllegalArgumentException {
        if (this.stream == null) {
            throw new FileNotFoundException("input stream is null");
        }
        this.checkDownloadParam(null);
    }

    private void checkDownloadParam(String defSaveFileName) throws IllegalArgumentException {
        if (this.saveFileName == null) {
            if (defSaveFileName != null) {
                this.saveFileName = defSaveFileName;
            } else {
                throw new IllegalArgumentException("save file name is null");
            }
        }
        if (this.contentType == null) {
            this.contentType = DEFAULT_CONTENT_TYPE;
        }
        if (this.bufferSize <= 0) {
            this.bufferSize = 4096;
        }
    }

    public static enum Mode {
        FILE,
        BYTES,
        STREAM;

    }

    public static enum Result {
        SUCCESS,
        ILLEGAL_STATE,
        ILLEGAL_ARG,
        FILE_NOT_FOUND,
        READ_WRITE_FAIL,
        UNKNOWN_EXCEPTION;

    }
}

