/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.util.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileCleaningTracker;
import org.jessma.util.GeneralHelper;
import org.jessma.util.LStrSet;
import org.jessma.util.http.HttpHelper;

public class FileUploader {
    public static final long NO_LIMIT_SIZE_MAX = -1L;
    public static final long NO_LIMIT_FILE_SIZE_MAX = -1L;
    public static final int DEFAULT_SIZE_THRESHOLD = 10240;
    public static final FileNameGenerator DEFAULT_FILE_NAME_GENERATOR = new CommonFileNameGenerator();
    private String savePath;
    private long sizeMax = -1L;
    private long fileSizeMax = -1L;
    private Set<String> acceptTypes = new LStrSet();
    private Map<String, String[]> paramFields = new HashMap<String, String[]>();
    private Map<String, FileInfo[]> fileFields = new HashMap<String, FileInfo[]>();
    private FileNameGenerator fileNameGenerator = DEFAULT_FILE_NAME_GENERATOR;
    private int factorySizeThreshold = 10240;
    private String factoryRepository;
    private FileCleaningTracker factoryCleaningTracker;
    private String servletHeaderencoding;
    private ProgressListener servletProgressListener;
    private Throwable cause;

    public FileUploader() {
    }

    public FileUploader(String savePath) {
        this(savePath, null);
    }

    public FileUploader(String savePath, long sizeMax, long fileSizeMax) {
        this(savePath, null, sizeMax, fileSizeMax);
    }

    public FileUploader(String savePath, String[] acceptTypes) {
        this(savePath, acceptTypes, -1L, -1L);
    }

    public FileUploader(String savePath, String[] acceptTypes, long sizeMax, long fileSizeMax) {
        this.savePath = savePath;
        this.sizeMax = sizeMax;
        this.fileSizeMax = fileSizeMax;
        if (acceptTypes != null) {
            this.setAcceptTypes(acceptTypes);
        }
    }

    public String getSavePath() {
        return this.savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    public void setFileSizeMax(long fileSizeMax) {
        this.fileSizeMax = fileSizeMax;
    }

    public long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(long sizeMax) {
        this.sizeMax = sizeMax;
    }

    public Set<String> getAcceptTypes() {
        return this.acceptTypes;
    }

    public void setAcceptTypes(Set<String> acceptTypes) {
        this.acceptTypes.clear();
        for (String type : acceptTypes) {
            this.addAcceptType(type);
        }
    }

    public void setAcceptTypes(String[] acceptTypes) {
        this.acceptTypes.clear();
        for (String type : acceptTypes) {
            this.addAcceptType(type);
        }
    }

    public boolean addAcceptType(String acceptType) {
        if ((acceptType = this.adjustAcceptType(acceptType)).length() > 1) {
            return this.acceptTypes.add(acceptType);
        }
        return false;
    }

    public boolean removeAcceptType(String acceptType) {
        if ((acceptType = this.adjustAcceptType(acceptType)).length() > 1) {
            return this.acceptTypes.remove(acceptType);
        }
        return false;
    }

    private String adjustAcceptType(String acceptType) {
        int index = acceptType.lastIndexOf(".");
        acceptType = index != -1 ? acceptType.substring(index, acceptType.length()) : "." + acceptType;
        return acceptType;
    }

    public Map<String, String[]> getParamFields() {
        return this.paramFields;
    }

    private void addParamField(String name, String value) {
        String[] array = this.paramFields.get(name);
        array = this.addField(array, name, value);
        this.paramFields.put(name, array);
    }

    private <T> T[] addField(T[] array, String name, T value) {
        if (array == null) {
            array = (Object[])Array.newInstance(value.getClass(), 1);
            array[0] = value;
        } else {
            Object[] array2 = (Object[])Array.newInstance(value.getClass(), array.length + 1);
            System.arraycopy(array, 0, array2, 0, array.length);
            array2[array.length] = value;
            array = array2;
        }
        return array;
    }

    public Map<String, FileInfo[]> getFileFields() {
        return this.fileFields;
    }

    private void addFileField(String name, FileInfo value) {
        FileInfo[] array = this.fileFields.get(name);
        array = this.addField(array, name, value);
        this.fileFields.put(name, array);
    }

    public String getFactoryRepository() {
        return this.factoryRepository;
    }

    public void setFactoryRepository(String factoryRepository) {
        this.factoryRepository = factoryRepository;
    }

    public int getFactorySizeThreshold() {
        return this.factorySizeThreshold;
    }

    public void setFactorySizeThreshold(int factorySizeThreshold) {
        this.factorySizeThreshold = factorySizeThreshold;
    }

    public FileCleaningTracker getFactoryCleaningTracker() {
        return this.factoryCleaningTracker;
    }

    public void setFactoryCleaningTracker(FileCleaningTracker factoryCleaningTracker) {
        this.factoryCleaningTracker = factoryCleaningTracker;
    }

    public String getServletHeaderencoding() {
        return this.servletHeaderencoding;
    }

    public void setServletHeaderencoding(String servletHeaderencoding) {
        this.servletHeaderencoding = servletHeaderencoding;
    }

    public ProgressListener getServletProgressListener() {
        return this.servletProgressListener;
    }

    public void setServletProgressListener(ProgressListener servletProgressListener) {
        this.servletProgressListener = servletProgressListener;
    }

    public FileNameGenerator getFileNameGenerator() {
        return this.fileNameGenerator;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator;
    }

    public Throwable getCause() {
        return this.cause;
    }

    private void reset() {
        this.cause = null;
        this.fileFields.clear();
        this.paramFields.clear();
    }

    private void clean(List<FileItemInfo> fiis, int count) {
        this.reset();
        for (int i = 0; i < count; ++i) {
            File file = fiis.get((int)i).file;
            try {
                file.delete();
                continue;
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
    }

    public Result upload(HttpServletRequest request, HttpServletResponse response) {
        this.reset();
        String absolutePath = this.getAbsoluteSavePath(request);
        if (absolutePath == null) {
            this.cause = new FileNotFoundException(String.format("path '%s' not found or is not directory", this.savePath));
            return Result.INVALID_SAVE_PATH;
        }
        ServletFileUpload sfu = this.getFileUploadComponent();
        ArrayList<FileItemInfo> fiis = new ArrayList<FileItemInfo>();
        List items = null;
        Result result = Result.SUCCESS;
        String encoding = this.servletHeaderencoding != null ? this.servletHeaderencoding : request.getCharacterEncoding();
        FileNameGenerator fnGenerator = this.fileNameGenerator != null ? this.fileNameGenerator : DEFAULT_FILE_NAME_GENERATOR;
        try {
            items = sfu.parseRequest(request);
        }
        catch (FileUploadException e) {
            this.cause = e;
            result = e instanceof FileUploadBase.FileSizeLimitExceededException ? Result.FILE_SIZE_EXCEEDED : (e instanceof FileUploadBase.SizeLimitExceededException ? Result.SIZE_EXCEEDED : (e instanceof FileUploadBase.InvalidContentTypeException ? Result.INVALID_CONTENT_TYPE : (e instanceof FileUploadBase.IOFileUploadException ? Result.FILE_UPLOAD_IO_EXCEPTION : Result.OTHER_PARSE_REQUEST_EXCEPTION)));
        }
        if (result == Result.SUCCESS && (result = this.parseFileItems(items, fnGenerator, absolutePath, encoding, fiis)) == Result.SUCCESS) {
            result = this.writeFiles(fiis);
        }
        return result;
    }

    private Result writeFiles(List<FileItemInfo> fiis) {
        for (int i = 0; i < fiis.size(); ++i) {
            FileItemInfo fii = fiis.get(i);
            try {
                fii.item.write(fii.file);
                continue;
            }
            catch (Exception e) {
                this.clean(fiis, i);
                this.cause = e;
                return Result.WRITE_FILE_FAIL;
            }
        }
        return Result.SUCCESS;
    }

    private Result parseFileItems(List<FileItem> items, FileNameGenerator fnGenerator, String absolutePath, String encoding, List<FileItemInfo> fiis) {
        for (FileItem item : items) {
            Result result;
            if (item.isFormField()) {
                this.parseFormField(item, encoding);
                continue;
            }
            if (GeneralHelper.isStrEmpty(item.getName()) || (result = this.parseFileField(item, absolutePath, fnGenerator, fiis)) == Result.SUCCESS) continue;
            this.reset();
            this.cause = new InvalidParameterException(String.format("file '%s' not accepted", item.getName()));
            return result;
        }
        return Result.SUCCESS;
    }

    private Result parseFileField(FileItem item, String absolutePath, FileNameGenerator fnGenerator, List<FileItemInfo> fiis) {
        String suffix = null;
        String uploadFileName = item.getName();
        boolean isAcceptType = this.acceptTypes.isEmpty();
        int stuffPos = uploadFileName.lastIndexOf(".");
        if (stuffPos != -1) {
            suffix = uploadFileName.substring(stuffPos, uploadFileName.length()).toLowerCase();
            if (!isAcceptType) {
                isAcceptType = this.acceptTypes.contains(suffix);
            }
        }
        if (!isAcceptType) {
            return Result.INVALID_FILE_TYPE;
        }
        String saveFileName = fnGenerator.generate(item, suffix);
        if (suffix != null && !saveFileName.endsWith(suffix)) {
            saveFileName = saveFileName + suffix;
        }
        String fullFileName = absolutePath + File.separator + saveFileName;
        File saveFile = new File(fullFileName);
        FileInfo info = new FileInfo(uploadFileName, saveFile);
        fiis.add(new FileItemInfo(item, saveFile));
        this.addFileField(item.getFieldName(), info);
        return Result.SUCCESS;
    }

    private void parseFormField(FileItem item, String encoding) {
        String name = item.getFieldName();
        String value = item.getString();
        if (!GeneralHelper.isStrEmpty(value) && encoding != null) {
            try {
                value = new String(value.getBytes("ISO-8859-1"), encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        this.addParamField(name, value);
    }

    private ServletFileUpload getFileUploadComponent() {
        DiskFileItemFactory dif = new DiskFileItemFactory();
        if (this.factorySizeThreshold != 10240) {
            dif.setSizeThreshold(this.factorySizeThreshold);
        }
        if (this.factoryRepository != null) {
            dif.setRepository(new File(this.factoryRepository));
        }
        if (this.factoryCleaningTracker != null) {
            dif.setFileCleaningTracker(this.factoryCleaningTracker);
        }
        ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)dif);
        if (this.sizeMax != -1L) {
            sfu.setSizeMax(this.sizeMax);
        }
        if (this.fileSizeMax != -1L) {
            sfu.setFileSizeMax(this.fileSizeMax);
        }
        if (this.servletHeaderencoding != null) {
            sfu.setHeaderEncoding(this.servletHeaderencoding);
        }
        if (this.servletProgressListener != null) {
            sfu.setProgressListener(this.servletProgressListener);
        }
        return sfu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAbsoluteSavePath(HttpServletRequest request) {
        String path = null;
        File file = new File(this.savePath);
        if (!file.isAbsolute()) {
            file = new File(HttpHelper.getRequestRealPath(request, this.savePath));
        }
        if (file.isDirectory()) {
            path = file.getAbsolutePath();
        } else if (!file.exists()) {
            try {
                Class<FileUploader> clazz = FileUploader.class;
                synchronized (FileUploader.class) {
                    if (file.exists() || file.mkdirs()) {
                        path = file.getAbsolutePath();
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        {
            return path;
        }
    }

    public static enum Result {
        SUCCESS,
        SIZE_EXCEEDED,
        FILE_SIZE_EXCEEDED,
        INVALID_CONTENT_TYPE,
        FILE_UPLOAD_IO_EXCEPTION,
        OTHER_PARSE_REQUEST_EXCEPTION,
        INVALID_FILE_TYPE,
        WRITE_FILE_FAIL,
        INVALID_SAVE_PATH;

    }

    private class FileItemInfo {
        FileItem item;
        File file;

        public FileItemInfo(FileItem item, File file) {
            this.item = item;
            this.file = file;
        }
    }

    public static class FileInfo {
        private String uploadFileName;
        private File saveFile;

        FileInfo() {
        }

        FileInfo(String uploadFileName, File saveFile) {
            this.uploadFileName = uploadFileName;
            this.saveFile = saveFile;
        }

        public String getUploadFileName() {
            return this.uploadFileName;
        }

        public String getUploadFileSimpleName() {
            if (this.uploadFileName != null) {
                String path = this.uploadFileName;
                if (!GeneralHelper.isWindowsPlatform()) {
                    path = path.replace('\\', File.separatorChar);
                }
                return new File(path).getName();
            }
            return null;
        }

        void setUploadFileName(String uploadFileName) {
            this.uploadFileName = uploadFileName;
        }

        public File getSaveFile() {
            return this.saveFile;
        }

        void setSaveFile(File saveFile) {
            this.saveFile = saveFile;
        }
    }

    public static class CommonFileNameGenerator
    implements FileNameGenerator {
        private static final int MAX_SERIAL = 999999;
        private static final AtomicInteger atomic = new AtomicInteger();

        private static int getNextInteger() {
            int value = atomic.incrementAndGet();
            if (value >= 999999) {
                atomic.set(0);
            }
            return value;
        }

        @Override
        public String generate(FileItem item, String suffix) {
            int serial = CommonFileNameGenerator.getNextInteger();
            long millsec = System.currentTimeMillis();
            return String.format("%06d_%013d", serial, millsec);
        }
    }

    public static interface FileNameGenerator {
        public String generate(FileItem var1, String var2);
    }
}

