/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.util.http;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jessma.util.BeanHelper;
import org.jessma.util.CryptHelper;
import org.jessma.util.GeneralHelper;
import org.jessma.util.KV;

public class HttpHelper {
    public static final String URL_SECHEME_SUFFIX = "://";
    public static final String URL_PATH_SEPARATOR = "/";
    public static final String URL_PORT_SEPARATOR = ":";
    public static final String URL_PARAM_FLAG = "?";
    public static final String URL_PARAM_SEPARATOR = "&";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final int HTTP_DEFAULT_PORT = 80;
    public static final int HTTPS_DEFAULT_PORT = 443;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static ServletContext servletContext;

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static final synchronized void initializeServletContext(ServletContext servletContext) {
        if (HttpHelper.servletContext != null) {
            throw new IllegalStateException("'HttpHelper.servletContext' had been initialized before");
        }
        if (servletContext == null) {
            throw new IllegalArgumentException("param 'servletContext' is null (not valid)");
        }
        HttpHelper.servletContext = servletContext;
    }

    public static final synchronized void unInitializeServletContext() {
        servletContext = null;
    }

    public static final HttpURLConnection getHttpConnection(String url, KV<String, String> ... properties) throws IOException {
        return HttpHelper.getHttpConnection(url, null, properties);
    }

    public static final HttpURLConnection getHttpConnection(String url, String method, KV<String, String> ... properties) throws IOException {
        URL connUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)connUrl.openConnection();
        if (GeneralHelper.isStrNotEmpty(method)) {
            conn.setRequestMethod(method);
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (KV<String, String> kv : properties) {
            conn.setRequestProperty(kv.getKey(), kv.getValue());
        }
        return conn;
    }

    public static final void writeString(HttpURLConnection conn, String content, String charsetName) throws IOException {
        HttpHelper.writeString(conn.getOutputStream(), content, charsetName);
    }

    public static final void writeString(HttpServletResponse response, String content, String charsetName) throws IOException {
        HttpHelper.writeString((OutputStream)response.getOutputStream(), content, charsetName);
    }

    public static final void writeString(OutputStream os, String content, String charsetName) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, charsetName));
        pw.write(content);
        pw.flush();
        pw.close();
    }

    public static final void writeBytes(HttpURLConnection conn, byte[] content) throws IOException {
        HttpHelper.writeBytes(conn.getOutputStream(), content);
    }

    public static final void writeBytes(HttpServletResponse response, byte[] content) throws IOException {
        HttpHelper.writeBytes((OutputStream)response.getOutputStream(), content);
    }

    public static final void writeBytes(OutputStream os, byte[] content) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        bos.write(content);
        bos.flush();
        bos.close();
    }

    public static final String readString(HttpURLConnection conn, boolean escapeReturnChar, String charsetName) throws IOException {
        return HttpHelper.readString(conn.getInputStream(), escapeReturnChar, charsetName);
    }

    public static final String readString(HttpServletRequest request, boolean escapeReturnChar, String charsetName) throws IOException {
        return HttpHelper.readString((InputStream)request.getInputStream(), escapeReturnChar, charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readString(InputStream is, boolean escapeReturnChar, String charsetName) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is, charsetName));
        try {
            if (escapeReturnChar) {
                String line = null;
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            } else {
                int count = 0;
                char[] array = new char[4096];
                while ((count = rd.read(array)) != -1) {
                    sb.append(array, 0, count);
                }
            }
        }
        finally {
            rd.close();
        }
        return sb.toString();
    }

    public static final byte[] readBytes(HttpURLConnection conn) throws IOException {
        return HttpHelper.readBytes(conn.getInputStream(), conn.getContentLength());
    }

    public static final byte[] readBytes(HttpServletRequest request) throws IOException {
        return HttpHelper.readBytes((InputStream)request.getInputStream(), request.getContentLength());
    }

    public static final byte[] readBytes(InputStream is) throws IOException {
        return HttpHelper.readBytes(is, 0);
    }

    public static final byte[] readBytes(InputStream is, int length) throws IOException {
        byte[] array = null;
        if (length > 0) {
            array = new byte[length];
            int read = 0;
            int total = 0;
            while ((read = is.read(array, total, array.length - total)) != -1) {
                total += read;
            }
        } else {
            LinkedList<byte[]> list = new LinkedList<byte[]>();
            byte[] buffer = new byte[4096];
            int read = 0;
            int total = 0;
            while ((read = is.read(buffer)) != -1) {
                byte[] e = new byte[read];
                System.arraycopy(buffer, 0, e, 0, read);
                list.add(e);
                total += read;
            }
            array = new byte[total];
            int write = 0;
            for (byte[] e : list) {
                System.arraycopy(e, 0, array, write, e.length);
                write += e.length;
            }
        }
        return array;
    }

    public static final String makeURL(String srcURL, KV<String, String> ... params) {
        return HttpHelper.makeURL(srcURL, null, params);
    }

    public static final String makeURL(String srcURL, String charset, KV<String, String> ... params) {
        StringBuilder sbURL = new StringBuilder(srcURL);
        char token = '&';
        char firstToken = srcURL.indexOf(63) != -1 ? token : (char)'?';
        for (int i = 0; i < params.length; ++i) {
            KV<String, String> kv = params[i];
            String key = kv.getKey();
            String val = kv.getValue();
            if (i > 0) {
                sbURL.append(token);
            } else {
                sbURL.append(firstToken);
            }
            sbURL.append(key);
            sbURL.append('=');
            if (!GeneralHelper.isStrNotEmpty(val)) continue;
            sbURL.append(CryptHelper.urlEncode(val, charset));
        }
        return sbURL.toString();
    }

    public static final String ensurePath(String path, String defPath) {
        if (GeneralHelper.isStrEmpty(path)) {
            path = defPath;
        }
        if (!path.startsWith(URL_PATH_SEPARATOR)) {
            path = URL_PATH_SEPARATOR + path;
        }
        if (!path.endsWith(URL_PATH_SEPARATOR)) {
            path = path + URL_PATH_SEPARATOR;
        }
        return path;
    }

    public static final <T> T getRequestAttribute(HttpServletRequest request, String name) {
        return (T)request.getAttribute(name);
    }

    public static final <T> void setRequestAttribute(HttpServletRequest request, String name, T value) {
        request.setAttribute(name, value);
    }

    public static final void removeRequestAttribute(HttpServletRequest request, String name) {
        request.removeAttribute(name);
    }

    public static final <T> T getSessionAttribute(HttpSession session, String name) {
        return (T)session.getAttribute(name);
    }

    public static final <T> void setSessionAttribute(HttpSession session, String name, T value) {
        session.setAttribute(name, value);
    }

    public static final void removeSessionAttribute(HttpSession session, String name) {
        session.removeAttribute(name);
    }

    public static final void invalidateSession(HttpSession session) {
        session.invalidate();
    }

    public static final <T> T getApplicationAttribute(String name) {
        return HttpHelper.getApplicationAttribute(servletContext, name);
    }

    public static final <T> T getApplicationAttribute(ServletContext servletContext, String name) {
        return (T)servletContext.getAttribute(name);
    }

    public static final <T> void setApplicationAttribute(String name, T value) {
        HttpHelper.setApplicationAttribute(servletContext, name, value);
    }

    public static final <T> void setApplicationAttribute(ServletContext servletContext, String name, T value) {
        servletContext.setAttribute(name, value);
    }

    public static final void removeApplicationAttribute(String name) {
        HttpHelper.removeApplicationAttribute(servletContext, name);
    }

    public static final void removeApplicationAttribute(ServletContext servletContext, String name) {
        servletContext.removeAttribute(name);
    }

    public static final String getParam(HttpServletRequest request, String name) {
        String param = HttpHelper.getParamNoTrim(request, name);
        if (param != null) {
            param = param.trim();
            return param;
        }
        return param;
    }

    public static final String getParamNoTrim(HttpServletRequest request, String name) {
        return request.getParameter(name);
    }

    public static final List<String> getParamNames(HttpServletRequest request) {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            names.add((String)en.nextElement());
        }
        return names;
    }

    public static final List<String> getParamValues(HttpServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        return values != null ? Arrays.asList(values) : null;
    }

    public static final Map<String, String[]> getParamMap(HttpServletRequest request) {
        return request.getParameterMap();
    }

    public static final Boolean getBooleanParam(HttpServletRequest request, String name) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Boolean(s);
    }

    public static final boolean getBooleanParam(HttpServletRequest request, String name, boolean def) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Boolean(s, def);
    }

    public static final Byte getByteParam(HttpServletRequest request, String name) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Byte(s);
    }

    public static final byte getByteParam(HttpServletRequest request, String name, byte def) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Byte(s, def);
    }

    public static final Character getCharParam(HttpServletRequest request, String name) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Char(s);
    }

    public static final char getCharParam(HttpServletRequest request, String name, char def) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Char(s, def);
    }

    public static final Short getShortParam(HttpServletRequest request, String name) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Short(s);
    }

    public static final short getShortParam(HttpServletRequest request, String name, short def) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Short(s, def);
    }

    public static final Integer getIntParam(HttpServletRequest request, String name) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Int(s);
    }

    public static final int getIntParam(HttpServletRequest request, String name, int def) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Int(s, def);
    }

    public static final Long getLongParam(HttpServletRequest request, String name) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Long(s);
    }

    public static final long getLongParam(HttpServletRequest request, String name, long def) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Long(s, def);
    }

    public static final Float getFloatParam(HttpServletRequest request, String name) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Float(s);
    }

    public static final float getFloatParam(HttpServletRequest request, String name, float def) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Float(s, def);
    }

    public static final Double getDoubleParam(HttpServletRequest request, String name) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Double(s);
    }

    public static final double getDoubleParam(HttpServletRequest request, String name, double def) {
        String s = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Double(s, def);
    }

    public static final Date getDateParam(HttpServletRequest request, String name) {
        String str = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Date(str);
    }

    public static final Date getDateParam(HttpServletRequest request, String name, String format) {
        String str = HttpHelper.getParam(request, name);
        return GeneralHelper.str2Date(str, format);
    }

    public static final <T> T createFormBean(HttpServletRequest request, Class<T> clazz) {
        return HttpHelper.createFormBean(request, clazz, null);
    }

    public static final <T> T createFormBean(HttpServletRequest request, Class<T> clazz, Map<String, String> keyMap) {
        Map<String, String[]> valueMap = HttpHelper.getParamMap(request);
        return BeanHelper.createBean(clazz, valueMap, keyMap);
    }

    public static final <T> T createFormBeanByProperties(HttpServletRequest request, Class<T> clazz) {
        return HttpHelper.createFormBeanByProperties(request, clazz, null);
    }

    public static final <T> T createFormBeanByProperties(HttpServletRequest request, Class<T> clazz, Map<String, String> keyMap) {
        Map<String, String[]> properties = HttpHelper.getParamMap(request);
        return BeanHelper.createBeanByProperties(clazz, properties, keyMap);
    }

    public static final <T> T createFormBeanByFieldValues(HttpServletRequest request, Class<T> clazz) {
        return HttpHelper.createFormBeanByFieldValues(request, clazz, null);
    }

    public static final <T> T createFormBeanByFieldValues(HttpServletRequest request, Class<T> clazz, Map<String, String> keyMap) {
        Map<String, String[]> values = HttpHelper.getParamMap(request);
        return BeanHelper.createBeanByFieldValues(clazz, values, keyMap);
    }

    public static final <T> void fillFormBeanProperties(HttpServletRequest request, T bean) {
        HttpHelper.fillFormBeanProperties(request, bean, null);
    }

    public static final <T> void fillFormBeanProperties(HttpServletRequest request, T bean, Map<String, String> keyMap) {
        Map<String, String[]> properties = HttpHelper.getParamMap(request);
        BeanHelper.setProperties(bean, properties, keyMap);
    }

    public static final <T> void fillFormBeanFieldValues(HttpServletRequest request, T bean) {
        HttpHelper.fillFormBeanFieldValues(request, bean, null);
    }

    public static final <T> void fillFormBeanFieldValues(HttpServletRequest request, T bean, Map<String, String> keyMap) {
        Map<String, String[]> values = HttpHelper.getParamMap(request);
        BeanHelper.setFieldValues(bean, values, keyMap);
    }

    public static final <T> void fillFormBeanPropertiesOrFieldValues(HttpServletRequest request, T bean) {
        HttpHelper.fillFormBeanPropertiesOrFieldValues(request, bean, null);
    }

    public static final <T> void fillFormBeanPropertiesOrFieldValues(HttpServletRequest request, T bean, Map<String, String> keyMap) {
        Map<String, String[]> valueMap = HttpHelper.getParamMap(request);
        BeanHelper.setPropertiesOrFieldValues(bean, valueMap, keyMap);
    }

    public static final HttpSession getSession(HttpServletRequest request) {
        return HttpHelper.getSession(request, true);
    }

    public static final HttpSession getSession(HttpServletRequest request, boolean create) {
        return request.getSession(create);
    }

    public static final HttpSession createSession(HttpServletRequest request) {
        return HttpHelper.getSession(request);
    }

    public static final Cookie[] getCookies(HttpServletRequest request) {
        return request.getCookies();
    }

    public static final Cookie getCookie(HttpServletRequest request, String name) {
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(name)) continue;
                cookie = c;
                break;
            }
        }
        return cookie;
    }

    public static final String getCookieValue(HttpServletRequest request, String name) {
        String value = null;
        Cookie cookie = HttpHelper.getCookie(request, name);
        if (cookie != null) {
            value = cookie.getValue();
        }
        return value;
    }

    public static final void addCookie(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    public static final void addCookie(HttpServletResponse response, String name, String value) {
        HttpHelper.addCookie(response, new Cookie(name, value));
    }

    public static final Locale getRequestLocale(HttpServletRequest request) {
        return request.getLocale();
    }

    public static final List<Locale> getRequestLocales(HttpServletRequest request) {
        return Collections.list(request.getLocales());
    }

    public static final String getRequestBasePath(HttpServletRequest request) {
        String scheme = request.getScheme();
        int serverPort = request.getServerPort();
        StringBuilder sb = new StringBuilder(scheme).append(URL_SECHEME_SUFFIX).append(request.getServerName());
        if (!(scheme.equals(HTTP_SCHEME) && serverPort == 80 || scheme.equals(HTTPS_SCHEME) && serverPort == 443)) {
            sb.append(URL_PORT_SEPARATOR).append(request.getServerPort());
        }
        sb.append(request.getContextPath()).append(URL_PATH_SEPARATOR);
        return sb.toString();
    }

    public static final String getRequestRealPath(HttpServletRequest request, String path) {
        if (servletContext != null) {
            return servletContext.getRealPath(path);
        }
        try {
            Method m = request.getClass().getMethod("getServletContext", new Class[0]);
            ServletContext sc = (ServletContext)m.invoke((Object)request, new Object[0]);
            return sc.getRealPath(path);
        }
        catch (Exception e) {
            return request.getRealPath(path);
        }
    }

    public static final String getRequestUserAgentPlatform(HttpServletRequest request) {
        int index = 1;
        String platform = null;
        String agent = request.getHeader("user-agent");
        if (GeneralHelper.isStrNotEmpty(agent)) {
            int i = 0;
            StringTokenizer st = new StringTokenizer(agent, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (i == 0) {
                    if (token.toLowerCase().indexOf("compatible") != -1) {
                        index = 2;
                    }
                } else if (i == index) {
                    int sep = token.indexOf(")");
                    if (sep != -1) {
                        token = token.substring(0, sep);
                    }
                    platform = GeneralHelper.safeTrimString(token);
                    break;
                }
                ++i;
            }
        }
        return platform;
    }

    public static final void setContentType(HttpServletResponse response, String contentType, String encoding) {
        StringBuilder sb = new StringBuilder(contentType);
        if (encoding != null) {
            sb.append(";charset=").append(encoding);
        }
        response.setContentType(sb.toString());
    }

    public static final void setNoCacheHeader(HttpServletResponse response) {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    public static final boolean isRequestNotComeFromWidnows(HttpServletRequest request) {
        String agent = request.getHeader("user-agent");
        if (GeneralHelper.isStrNotEmpty(agent)) {
            return agent.toLowerCase().indexOf("windows") == -1;
        }
        return false;
    }

    public static final String getUrlHost(String url) {
        int p1 = url.indexOf(URL_SECHEME_SUFFIX);
        if (p1 != -1) {
            url = url.substring(p1 + 3);
            return HttpHelper.getUrlHost(url);
        }
        int p2 = url.indexOf(URL_PATH_SEPARATOR);
        if (p2 != -1) {
            return url.substring(0, p2);
        }
        int p3 = url.indexOf(URL_PARAM_FLAG);
        if (p3 != -1) {
            return url.substring(0, p3);
        }
        return url;
    }

    public static final String getUrlBase(String url, String scheme) {
        int p1 = url.indexOf(URL_SECHEME_SUFFIX);
        if (p1 != -1) {
            int p2 = url.indexOf(URL_PATH_SEPARATOR, p1 + 3);
            if (p2 != -1) {
                return url.substring(0, p2);
            }
            int p3 = url.indexOf(URL_PARAM_FLAG, p1 + 3);
            if (p3 != -1) {
                return url.substring(0, p3);
            }
            return url;
        }
        url = scheme + url;
        return HttpHelper.getUrlBase(url, scheme);
    }

    public static final String getUrlBase(String url) {
        return HttpHelper.getUrlBase(url, "http://");
    }

    public static final String truncateUrlParams(String url) {
        int p = url.indexOf(URL_PARAM_FLAG);
        if (p != -1) {
            url = url.substring(0, p);
        }
        return url;
    }

    public static final String addUrlParams(String url, Object ... params) {
        String ENC = "UTF-8";
        int index = url.indexOf(63);
        char sep1 = index == -1 ? (char)'?' : '&';
        StringBuilder sb = new StringBuilder(url);
        for (int i = 0; i < params.length; i += 2) {
            String key = CryptHelper.urlEncode(params[i].toString(), "UTF-8");
            sb.append(i == 0 ? sep1 : (char)'&').append(key).append('=');
            if (i >= params.length - 1) continue;
            String val = CryptHelper.urlEncode(params[i + 1].toString(), "UTF-8");
            sb.append(val);
        }
        return sb.toString();
    }

    public static final String addUrlParams(String url, Map<String, String> map) {
        int i = 0;
        Object[] params = new Object[map.size() * 2];
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            params[i++] = key == null ? "" : key;
            params[i++] = val == null ? "" : val;
        }
        return HttpHelper.addUrlParams(url, params);
    }

    public static final String deleteUrlParams(String url, String ... names) {
        String baseUrl = HttpHelper.truncateUrlParams(url);
        Map<String, String> params = HttpHelper.getUrlParamMap(url);
        for (String name : names) {
            params.remove(name);
        }
        return HttpHelper.addUrlParams(baseUrl, params);
    }

    public static final Map<String, String> getUrlParamMap(String url) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int index = url.indexOf(63);
        if (index != -1) {
            String[] params;
            String str = url.substring(index + 1);
            for (String param : params = str.split("\\&")) {
                String value;
                String[] pair = param.split("\\=", 2);
                String name = CryptHelper.urlDecode(pair[0]);
                String string = value = pair.length == 2 ? CryptHelper.urlDecode(pair[1]) : "";
                if (name.isEmpty()) continue;
                map.put(name, value);
            }
        }
        return map;
    }

    public static final String getUrlParam(String url, String name) {
        return HttpHelper.getUrlParamMap(url).get(name);
    }

    public static final String encodeUrlParams(String url) {
        String baseUrl = HttpHelper.truncateUrlParams(url);
        if (baseUrl.length() < url.length()) {
            Map<String, String> params = HttpHelper.getUrlParamMap(url);
            String[] items = new String[params.size() * 2];
            int i = 0;
            for (Map.Entry<String, String> e : params.entrySet()) {
                items[i++] = CryptHelper.urlEncode(e.getKey());
                items[i++] = CryptHelper.urlEncode(e.getValue());
            }
            url = HttpHelper.addUrlParams(baseUrl, items);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] unGZip(byte[] bytes) throws IOException {
        byte[] buffer = new byte[4096];
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        GZIPInputStream gzip = new GZIPInputStream(bis);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int r;
            while ((r = gzip.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, r);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (gzip != null) {
                    gzip.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

