/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.util.mail;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

class ByteArrayDataSource
implements DataSource {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private ByteArrayOutputStream baos = null;
    private String type = "application/octet-stream";
    private String name = "ByteArrayDataSource";

    private void init(String type, String name) {
        if (type != null) {
            this.type = type;
        }
        if (name != null) {
            this.name = name;
        }
    }

    public ByteArrayDataSource(byte[] data, String type, String name) throws IOException {
        ByteArrayInputStream Bis = null;
        try {
            Bis = new ByteArrayInputStream(data);
            this.byteArrayDataSource(Bis, type, name);
        }
        catch (IOException ioex) {
            throw ioex;
        }
        finally {
            try {
                if (Bis != null) {
                    Bis.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    public ByteArrayDataSource(InputStream aIs, String type, String name) throws IOException {
        this.byteArrayDataSource(aIs, type, name);
    }

    private void byteArrayDataSource(InputStream aIs, String type, String name) throws IOException {
        this.init(type, name);
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int length = 0;
            byte[] buffer = new byte[4096];
            bis = new BufferedInputStream(aIs);
            this.baos = new ByteArrayOutputStream();
            bos = new BufferedOutputStream(this.baos);
            while ((length = bis.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, length);
            }
        }
        catch (IOException ioex) {
            throw ioex;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (this.baos != null) {
                    this.baos.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    public ByteArrayDataSource(String data, String type, String name) throws IOException {
        this(data, DEFAULT_ENCODING, type, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayDataSource(String data, String encoding, String type, String name) throws IOException {
        this.init(type, name);
        try {
            this.baos = new ByteArrayOutputStream();
            this.baos.write(data.getBytes(encoding));
        }
        catch (UnsupportedEncodingException uex) {
        }
        catch (IOException ignored) {
        }
        finally {
            try {
                if (this.baos != null) {
                    this.baos.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    public String getContentType() {
        return this.type;
    }

    public InputStream getInputStream() throws IOException {
        if (this.baos == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.baos.toByteArray());
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        this.baos = new ByteArrayOutputStream();
        return this.baos;
    }
}

