/*
 * Decompiled with CFR 0.152.
 */
package org.jessma.ext.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jessma.ext.guice.GuiceBean;
import org.jessma.ext.guice.GuiceBeans;
import org.jessma.mvc.Action;
import org.jessma.mvc.ActionExecutor;
import org.jessma.mvc.ActionFilter;
import org.jessma.mvc.ActionSupport;
import org.jessma.util.BeanHelper;
import org.jessma.util.CoupleKey;
import org.jessma.util.GeneralHelper;

public class GuiceInjectFilter
implements ActionFilter {
    private Injector injector;
    private Map<CoupleKey<Class<?>, Method>, GuiceAttr[]> guiceMap;

    public void init() {
        this.guiceMap = new HashMap();
        this.injector = Guice.createInjector((Stage)this.configStage(), this.configModules());
    }

    public void destroy() {
        this.guiceMap = null;
        this.injector = null;
    }

    protected Injector getInjector() {
        return this.injector;
    }

    protected Stage configStage() {
        return Stage.DEVELOPMENT;
    }

    protected Collection<Module> configModules() {
        return new ArrayList<Module>();
    }

    public String doFilter(ActionExecutor executor) throws Exception {
        Action action = executor.getAction();
        Method method = executor.getEntryMethod();
        CoupleKey key = new CoupleKey(action.getClass(), (Object)method);
        this.checkGuiceMap(executor, action, key);
        this.tryInject(action, key);
        return executor.invoke();
    }

    private void checkGuiceMap(ActionExecutor executor, Action action, CoupleKey<Class<?>, Method> key) throws Exception {
        if (!this.guiceMap.containsKey(key)) {
            ArrayList<GuiceAttr> guiceAttrList = new ArrayList<GuiceAttr>();
            Map<String, GuiceBean> guiceBeanMap = this.parseGuiceBeans(executor, action, key);
            this.parseGuiceAttrs(executor, action, guiceAttrList, guiceBeanMap);
            this.tryPutGuiceMap(key, guiceAttrList);
        }
    }

    private void parseGuiceAttrs(ActionExecutor executor, Action action, List<GuiceAttr> guiceAttrList, Map<String, GuiceBean> guiceBeanMap) throws Exception {
        Set<Map.Entry<String, GuiceBean>> entries = guiceBeanMap.entrySet();
        for (Map.Entry<String, GuiceBean> entry : entries) {
            this.parseGuiceAttr(executor, action, entry, guiceAttrList);
        }
    }

    private void tryInject(Action action, CoupleKey<Class<?>, Method> key) {
        GuiceAttr[] guiceAttrs = this.guiceMap.get(key);
        if (guiceAttrs != null) {
            for (GuiceAttr guiceAttr : guiceAttrs) {
                guiceAttr.inject(action);
            }
        }
    }

    private void tryPutGuiceMap(CoupleKey<Class<?>, Method> key, List<GuiceAttr> guiceAttrList) {
        GuiceAttr[] guiceAttrs = guiceAttrList.isEmpty() ? null : guiceAttrList.toArray(new GuiceAttr[guiceAttrList.size()]);
        GeneralHelper.syncTryPut(this.guiceMap, key, (Object)guiceAttrs);
    }

    private void parseGuiceAttr(ActionExecutor executor, Action action, Map.Entry<String, GuiceBean> entry, List<GuiceAttr> guiceAttrList) throws Exception {
        String attr = entry.getKey();
        GuiceBean guiceBean = entry.getValue();
        if (attr == null) {
            return;
        }
        Class<?> actionClass = action.getClass();
        Class stopClass = ActionSupport.class.isAssignableFrom(actionClass) ? ActionSupport.class : Object.class;
        GuiceAttr guiceAttr = new GuiceAttr(attr, guiceBean.type());
        this.parsePropertyOrField(executor, actionClass, stopClass, guiceAttr);
        guiceAttrList.add(guiceAttr);
    }

    private Map<String, GuiceBean> parseGuiceBeans(ActionExecutor executor, Action action, CoupleKey<Class<?>, Method> key) throws Exception {
        HashMap<String, GuiceBean> guiceBeanMap = new HashMap<String, GuiceBean>();
        this.analysisGuiceBeans(executor, action, (AnnotatedElement)key.getKey2(), guiceBeanMap);
        if (guiceBeanMap.isEmpty()) {
            this.analysisGuiceBeans(executor, action, (AnnotatedElement)key.getKey1(), guiceBeanMap);
        }
        return guiceBeanMap;
    }

    private void parsePropertyOrField(ActionExecutor executor, Class<? extends Action> actionClass, Class<?> stopClass, GuiceAttr guiceAttr) throws Exception {
        PropertyDescriptor pd = BeanHelper.getPropDescByName(actionClass, stopClass, (String)guiceAttr.attr);
        Method setter = BeanHelper.getPropertyWriteMethod((PropertyDescriptor)pd);
        if (setter != null) {
            guiceAttr.property = pd;
            if (guiceAttr.type == Object.class) {
                guiceAttr.type = setter.getReturnType();
            }
        } else {
            Field field = BeanHelper.getInstanceFiledByName(actionClass, stopClass, (String)guiceAttr.attr);
            if (field != null) {
                guiceAttr.field = field;
                if (guiceAttr.type == Object.class) {
                    guiceAttr.type = field.getType();
                }
            }
        }
        if (guiceAttr.property == null && guiceAttr.field == null) {
            GuiceInjectFilter.throwParseException(executor, null, String.format("no property or field named '%s'", guiceAttr.attr));
        }
    }

    private void analysisGuiceBeans(ActionExecutor executor, Action action, AnnotatedElement element, Map<String, GuiceBean> guiceBeanMap) throws Exception {
        GuiceBeans guiceBeans;
        GuiceBean guiceBean = element.getAnnotation(GuiceBean.class);
        if (guiceBean != null) {
            GeneralHelper.tryPut(guiceBeanMap, (Object)guiceBean.value(), (Object)guiceBean);
        }
        if ((guiceBeans = element.getAnnotation(GuiceBeans.class)) != null) {
            GuiceBean[] guiceBeanArr = guiceBeans.value();
            if (guiceBeanArr.length == 0) {
                guiceBeanMap.put(null, null);
            } else {
                for (GuiceBean guiceBean2 : guiceBeanArr) {
                    GeneralHelper.tryPut(guiceBeanMap, (Object)guiceBean2.value(), (Object)guiceBean2);
                }
            }
        }
    }

    private static final void throwParseException(ActionExecutor executor, String name, String cause) throws Exception {
        String msg = GeneralHelper.isStrNotEmpty((String)name) ? String.format("Parse @GuiceBean / @GuiceBeans fail '%s#%s()' ['%s'] -> %s", executor.getAction().getClass().getName(), executor.getEntryMethod().getName(), name, cause) : String.format("Parse @GuiceBean / @GuiceBeans fail '%s#%s()' -> %s", executor.getAction().getClass().getName(), executor.getEntryMethod().getName(), cause);
        throw new RuntimeException(msg);
    }

    private class GuiceAttr {
        String attr;
        PropertyDescriptor property;
        Field field;
        Class<?> type;

        public GuiceAttr(String attr, Class<?> type) {
            this.attr = attr;
            this.type = type;
        }

        private boolean inject(Action action) {
            Object bean = GuiceInjectFilter.this.injector.getInstance(this.type);
            if (this.property != null) {
                return BeanHelper.setProperty((Object)action, (PropertyDescriptor)this.property, (Object)bean);
            }
            if (this.field != null) {
                return BeanHelper.setFieldValue((Object)action, (Field)this.field, (Object)bean);
            }
            return false;
        }
    }
}

