/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio;

import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.EndianSeekableDataInput;
import org.jetbrains.bio.RomBuffer;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010#\u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010&\u001a\u00020\u0007H\u0016J\b\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\b\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lorg/jetbrains/bio/LightweightRomBuffer;", "Lorg/jetbrains/bio/RomBuffer;", "input", "Lorg/jetbrains/bio/EndianSeekableDataInput;", "order", "Ljava/nio/ByteOrder;", "maxLength", "", "position", "limit", "(Lorg/jetbrains/bio/EndianSeekableDataInput;Ljava/nio/ByteOrder;JJJ)V", "getMaxLength", "()J", "getOrder", "()Ljava/nio/ByteOrder;", "getPosition", "setPosition", "(J)V", "close", "", "duplicate", "readByte", "", "readBytes", "", "size", "", "readCString", "", "readDouble", "", "readFloat", "", "readFloats", "", "readInt", "readInts", "", "readLong", "readShort", "", "big"})
public class LightweightRomBuffer
extends RomBuffer {
    private final EndianSeekableDataInput input;
    @NotNull
    private final ByteOrder order;
    private final long maxLength;
    private long position;

    @Override
    @NotNull
    public LightweightRomBuffer duplicate(long position, long limit) {
        return new LightweightRomBuffer(this.input, this.getOrder(), this.getMaxLength(), position, limit);
    }

    @Override
    public void close() {
    }

    @Override
    @NotNull
    public byte[] readBytes(int size) {
        this.input.seek(this.getPosition());
        this.input.setOrder(this.getOrder());
        byte[] dst = new byte[size];
        this.input.read(dst, 0, size);
        LightweightRomBuffer lightweightRomBuffer = this;
        lightweightRomBuffer.setPosition(lightweightRomBuffer.getPosition() + (long)dst.length);
        this.checkLimit();
        return dst;
    }

    @Override
    public byte readByte() {
        this.input.seek(this.getPosition());
        this.input.setOrder(this.getOrder());
        byte value = this.input.readByte();
        LightweightRomBuffer lightweightRomBuffer = this;
        lightweightRomBuffer.setPosition(lightweightRomBuffer.getPosition() + 1L);
        this.checkLimit();
        return value;
    }

    @Override
    public short readShort() {
        this.input.seek(this.getPosition());
        this.input.setOrder(this.getOrder());
        short value = this.input.readShort();
        LightweightRomBuffer lightweightRomBuffer = this;
        lightweightRomBuffer.setPosition(lightweightRomBuffer.getPosition() + (long)2);
        this.checkLimit();
        return value;
    }

    @Override
    @NotNull
    public int[] readInts(int size) {
        this.input.seek(this.getPosition());
        this.input.setOrder(this.getOrder());
        int[] dst = new int[size];
        this.input.readInt(dst, 0, size);
        LightweightRomBuffer lightweightRomBuffer = this;
        lightweightRomBuffer.setPosition(lightweightRomBuffer.getPosition() + (long)(size * 4));
        this.checkLimit();
        return dst;
    }

    @Override
    public int readInt() {
        this.input.seek(this.getPosition());
        this.input.setOrder(this.getOrder());
        int value = this.input.readInt();
        LightweightRomBuffer lightweightRomBuffer = this;
        lightweightRomBuffer.setPosition(lightweightRomBuffer.getPosition() + (long)4);
        this.checkLimit();
        return value;
    }

    @Override
    public long readLong() {
        this.input.seek(this.getPosition());
        this.input.setOrder(this.getOrder());
        long value = this.input.readLong();
        LightweightRomBuffer lightweightRomBuffer = this;
        lightweightRomBuffer.setPosition(lightweightRomBuffer.getPosition() + (long)8);
        this.checkLimit();
        return value;
    }

    @Override
    @NotNull
    public float[] readFloats(int size) {
        this.input.seek(this.getPosition());
        this.input.setOrder(this.getOrder());
        float[] dst = new float[size];
        this.input.readFloat(dst, 0, size);
        LightweightRomBuffer lightweightRomBuffer = this;
        lightweightRomBuffer.setPosition(lightweightRomBuffer.getPosition() + (long)(size * 4));
        this.checkLimit();
        return dst;
    }

    @Override
    public float readFloat() {
        this.input.seek(this.getPosition());
        this.input.setOrder(this.getOrder());
        float value = this.input.readFloat();
        LightweightRomBuffer lightweightRomBuffer = this;
        lightweightRomBuffer.setPosition(lightweightRomBuffer.getPosition() + (long)4);
        this.checkLimit();
        return value;
    }

    @Override
    public double readDouble() {
        this.input.seek(this.getPosition());
        this.input.setOrder(this.getOrder());
        double value = this.input.readDouble();
        LightweightRomBuffer lightweightRomBuffer = this;
        lightweightRomBuffer.setPosition(lightweightRomBuffer.getPosition() + (long)8);
        this.checkLimit();
        return value;
    }

    @Override
    @NotNull
    public String readCString() {
        return this.doReadCString();
    }

    @Override
    @NotNull
    public ByteOrder getOrder() {
        return this.order;
    }

    @Override
    public long getMaxLength() {
        return this.maxLength;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(long l) {
        this.position = l;
    }

    public LightweightRomBuffer(@NotNull EndianSeekableDataInput input, @NotNull ByteOrder order, long maxLength, long position, long limit) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        this.input = input;
        this.order = order;
        this.maxLength = maxLength;
        this.position = position;
        this.setLimit(limit);
    }

    public /* synthetic */ LightweightRomBuffer(EndianSeekableDataInput endianSeekableDataInput, ByteOrder byteOrder, long l, long l2, long l3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = endianSeekableDataInput.length();
        }
        if ((n & 8) != 0) {
            l2 = 0L;
        }
        if ((n & 0x10) != 0) {
            l3 = -1L;
        }
        this(endianSeekableDataInput, byteOrder, l, l2, l3);
    }
}

