/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio;

import com.indeed.util.mmap.DirectMemory;
import com.indeed.util.mmap.FloatArray;
import com.indeed.util.mmap.IntArray;
import com.indeed.util.mmap.MMapBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.RomBuffer;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010#\u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010&\u001a\u00020\u0005H\u0016J\b\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lorg/jetbrains/bio/MMBRomBuffer;", "Lorg/jetbrains/bio/RomBuffer;", "mapped", "Lcom/indeed/util/mmap/MMapBuffer;", "position", "", "limit", "(Lcom/indeed/util/mmap/MMapBuffer;JJ)V", "maxLength", "getMaxLength", "()J", "order", "Ljava/nio/ByteOrder;", "getOrder", "()Ljava/nio/ByteOrder;", "getPosition", "setPosition", "(J)V", "close", "", "duplicate", "readByte", "", "readBytes", "", "size", "", "readCString", "", "readDouble", "", "readFloat", "", "readFloats", "", "readInt", "readInts", "", "readLong", "readShort", "", "big"})
public class MMBRomBuffer
extends RomBuffer {
    private final long maxLength;
    private final MMapBuffer mapped;
    private long position;

    @Override
    public long getMaxLength() {
        return this.maxLength;
    }

    @Override
    @NotNull
    public ByteOrder getOrder() {
        DirectMemory directMemory = this.mapped.memory();
        Intrinsics.checkNotNullExpressionValue((Object)directMemory, (String)"mapped.memory()");
        ByteOrder byteOrder = directMemory.getOrder();
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"mapped.memory().order");
        return byteOrder;
    }

    @Override
    @NotNull
    public MMBRomBuffer duplicate(long position, long limit) {
        return new MMBRomBuffer(this.mapped, position, limit);
    }

    @Override
    public void close() {
    }

    @Override
    @NotNull
    public byte[] readBytes(int size) {
        byte[] dst = new byte[size];
        this.mapped.memory().getBytes(this.getPosition(), dst);
        MMBRomBuffer mMBRomBuffer = this;
        mMBRomBuffer.setPosition(mMBRomBuffer.getPosition() + (long)dst.length);
        this.checkLimit();
        return dst;
    }

    @Override
    public byte readByte() {
        byte value = this.mapped.memory().getByte(this.getPosition());
        MMBRomBuffer mMBRomBuffer = this;
        mMBRomBuffer.setPosition(mMBRomBuffer.getPosition() + 1L);
        this.checkLimit();
        return value;
    }

    @Override
    public short readShort() {
        short value = this.mapped.memory().getShort(this.getPosition());
        MMBRomBuffer mMBRomBuffer = this;
        mMBRomBuffer.setPosition(mMBRomBuffer.getPosition() + (long)2);
        this.checkLimit();
        return value;
    }

    @Override
    @NotNull
    public int[] readInts(int size) {
        int[] dst = new int[size];
        IntArray buff = this.mapped.memory().intArray(this.getPosition(), (long)size);
        buff.get(0L, dst);
        MMBRomBuffer mMBRomBuffer = this;
        mMBRomBuffer.setPosition(mMBRomBuffer.getPosition() + (long)(size * 4));
        this.checkLimit();
        return dst;
    }

    @Override
    public int readInt() {
        int value = this.mapped.memory().getInt(this.getPosition());
        MMBRomBuffer mMBRomBuffer = this;
        mMBRomBuffer.setPosition(mMBRomBuffer.getPosition() + (long)4);
        this.checkLimit();
        return value;
    }

    @Override
    public long readLong() {
        long value = this.mapped.memory().getLong(this.getPosition());
        MMBRomBuffer mMBRomBuffer = this;
        mMBRomBuffer.setPosition(mMBRomBuffer.getPosition() + (long)8);
        this.checkLimit();
        return value;
    }

    @Override
    @NotNull
    public float[] readFloats(int size) {
        float[] dst = new float[size];
        FloatArray floatArray = this.mapped.memory().floatArray(this.getPosition(), (long)size);
        Intrinsics.checkNotNull((Object)floatArray);
        FloatArray value = floatArray;
        value.get(0L, dst);
        MMBRomBuffer mMBRomBuffer = this;
        mMBRomBuffer.setPosition(mMBRomBuffer.getPosition() + (long)(size * 4));
        this.checkLimit();
        return dst;
    }

    @Override
    public float readFloat() {
        float value = this.mapped.memory().getFloat(this.getPosition());
        MMBRomBuffer mMBRomBuffer = this;
        mMBRomBuffer.setPosition(mMBRomBuffer.getPosition() + (long)4);
        this.checkLimit();
        return value;
    }

    @Override
    public double readDouble() {
        double value = this.mapped.memory().getDouble(this.getPosition());
        MMBRomBuffer mMBRomBuffer = this;
        mMBRomBuffer.setPosition(mMBRomBuffer.getPosition() + (long)8);
        this.checkLimit();
        return value;
    }

    @Override
    @NotNull
    public String readCString() {
        return this.doReadCString();
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(long l) {
        this.position = l;
    }

    public MMBRomBuffer(@NotNull MMapBuffer mapped, long position, long limit) {
        Intrinsics.checkNotNullParameter((Object)mapped, (String)"mapped");
        this.mapped = mapped;
        this.position = position;
        this.maxLength = this.mapped.memory().length();
        this.setLimit(limit);
    }

    public /* synthetic */ MMBRomBuffer(MMapBuffer mMapBuffer, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = -1L;
        }
        this(mMapBuffer, l, l2);
    }
}

