/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio;

import com.indeed.util.mmap.MMapBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.MMBRomBuffer;
import org.jetbrains.bio.RomBuffer;
import org.jetbrains.bio.RomBufferFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/bio/MMBRomBufferFactory;", "Lorg/jetbrains/bio/RomBufferFactory;", "path", "Ljava/nio/file/Path;", "order", "Ljava/nio/ByteOrder;", "(Ljava/nio/file/Path;Ljava/nio/ByteOrder;)V", "memBuffer", "Lcom/indeed/util/mmap/MMapBuffer;", "value", "getOrder", "()Ljava/nio/ByteOrder;", "setOrder", "(Ljava/nio/ByteOrder;)V", "getPath", "()Ljava/nio/file/Path;", "close", "", "create", "Lorg/jetbrains/bio/RomBuffer;", "big"})
public final class MMBRomBufferFactory
implements RomBufferFactory {
    private MMapBuffer memBuffer;
    @NotNull
    private ByteOrder order;
    @NotNull
    private final Path path;

    @Override
    @NotNull
    public ByteOrder getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(@NotNull ByteOrder value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)value, (Object)this.order) ^ true) {
            this.memBuffer.close();
            this.memBuffer = new MMapBuffer(this.path, FileChannel.MapMode.READ_ONLY, value);
            this.order = value;
        }
    }

    @Override
    @NotNull
    public RomBuffer create() {
        return new MMBRomBuffer(this.memBuffer, 0L, 0L, 6, null);
    }

    @Override
    public void close() {
        this.memBuffer.close();
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public MMBRomBufferFactory(@NotNull Path path, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        this.path = path;
        this.memBuffer = new MMapBuffer(this.path, FileChannel.MapMode.READ_ONLY, order);
        this.order = order;
    }
}

