/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio;

import com.google.common.io.LittleEndianDataOutputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.iq80.snappy.Snappy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.CompressionType;
import org.jetbrains.bio.FastByteArrayOutputStream;
import org.jetbrains.bio.OrderedDataOutput;
import org.jetbrains.bio.OrderedDataOutput$WhenMappings;
import org.jetbrains.bio.SupportKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0006J'\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00150 \u00a2\u0006\u0002\b!J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0017J\u000e\u0010&\u001a\u00020\u00152\u0006\u0010#\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00152\u0006\u0010#\u001a\u00020)J\u000e\u0010*\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0017J\u000e\u0010+\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0006J\u000e\u0010,\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0017J\u0018\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/bio/OrderedDataOutput;", "Ljava/io/Closeable;", "Ljava/lang/AutoCloseable;", "output", "Ljava/io/OutputStream;", "offset", "", "order", "Ljava/nio/ByteOrder;", "(Ljava/io/OutputStream;JLjava/nio/ByteOrder;)V", "endianOutput", "Ljava/io/DataOutput;", "getEndianOutput", "()Ljava/io/DataOutput;", "getOrder", "()Ljava/nio/ByteOrder;", "Ljava/io/DataOutputStream;", "getOutput", "()Ljava/io/DataOutputStream;", "written", "ack", "", "size", "", "close", "skipBytes", "count", "tell", "with", "compression", "Lorg/jetbrains/bio/CompressionType;", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "writeBoolean", "v", "", "writeByte", "writeDouble", "", "writeFloat", "", "writeInt", "writeLong", "writeShort", "writeString", "s", "", "length", "Companion", "big"})
public final class OrderedDataOutput
implements Closeable,
AutoCloseable {
    @NotNull
    private final DataOutputStream output;
    @NotNull
    private final DataOutput endianOutput;
    private long written;
    private final long offset;
    @NotNull
    private final ByteOrder order;
    private static final ThreadLocal def$delegate;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final DataOutputStream getOutput() {
        return this.output;
    }

    @NotNull
    public final DataOutput getEndianOutput() {
        return this.endianOutput;
    }

    public final void skipBytes(int count) {
        boolean bl = count >= 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "count must be >=0";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.output.write(new byte[count]);
        this.ack(count);
    }

    public final void writeByte(int v) {
        this.endianOutput.write(v);
        this.ack(1);
    }

    public final void writeBoolean(boolean v) {
        this.writeByte(v ? 1 : 0);
    }

    public final void writeShort(int v) {
        this.endianOutput.writeShort(v);
        this.ack(2);
    }

    public final void writeInt(int v) {
        this.endianOutput.writeInt(v);
        this.ack(4);
    }

    public final void writeLong(long v) {
        this.endianOutput.writeLong(v);
        this.ack(8);
    }

    public final void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeString(@NotNull String s, int length) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        boolean bl = s.length() <= length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = s;
        Charset charset = Charsets.US_ASCII;
        bl3 = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.output.write(byArray);
        int padding = length - s.length();
        this.output.write(new byte[padding]);
        this.ack(length);
    }

    public static /* synthetic */ void writeString$default(OrderedDataOutput orderedDataOutput, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = string.length();
        }
        orderedDataOutput.writeString(string, n);
    }

    private final void ack(int size) {
        this.written += (long)size;
    }

    public final int with(@NotNull CompressionType compression, @NotNull Function1<? super OrderedDataOutput, Unit> block) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (compression.getAbsent()) {
            long snapshot = this.written;
            block.invoke((Object)this);
            n = (int)(this.written - snapshot);
        } else {
            switch (OrderedDataOutput$WhenMappings.$EnumSwitchMapping$0[compression.ordinal()]) {
                case 1: {
                    OrderedDataOutput.Companion.getDef().reset();
                    DeflaterOutputStream inner = new DeflaterOutputStream((OutputStream)this.output, OrderedDataOutput.Companion.getDef(), 4096);
                    block.invoke((Object)new OrderedDataOutput(inner, this.offset, this.order));
                    inner.finish();
                    Deflater deflater = OrderedDataOutput.Companion.getDef();
                    Intrinsics.checkNotNullExpressionValue((Object)deflater, (String)"def");
                    this.ack((int)deflater.getBytesWritten());
                    Deflater deflater2 = OrderedDataOutput.Companion.getDef();
                    Intrinsics.checkNotNullExpressionValue((Object)deflater2, (String)"def");
                    n = (int)deflater2.getBytesRead();
                    break;
                }
                case 2: {
                    FastByteArrayOutputStream inner = new FastByteArrayOutputStream(0, 1, null);
                    block.invoke((Object)new OrderedDataOutput(inner, this.offset, this.order));
                    byte[] uncompressedBuf = inner.toByteArray();
                    byte[] compressedBuf = new byte[Snappy.maxCompressedLength((int)uncompressedBuf.length)];
                    int compressedSize = Snappy.compress((byte[])uncompressedBuf, (int)0, (int)uncompressedBuf.length, (byte[])compressedBuf, (int)0);
                    this.output.write(compressedBuf, 0, compressedSize);
                    this.ack(compressedSize);
                    n = uncompressedBuf.length;
                    break;
                }
                case 3: {
                    throw (Throwable)new IllegalStateException("Unexpected compression: " + (Object)((Object)compression));
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return n;
    }

    public final long tell() {
        return this.offset + this.written;
    }

    @Override
    public void close() {
        this.output.close();
    }

    @NotNull
    public final ByteOrder getOrder() {
        return this.order;
    }

    public OrderedDataOutput(@NotNull OutputStream output, long offset, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        this.offset = offset;
        this.order = order;
        this.output = new DataOutputStream(output);
        this.endianOutput = Intrinsics.areEqual((Object)this.order, (Object)ByteOrder.BIG_ENDIAN) ? (DataOutput)this.output : (DataOutput)new LittleEndianDataOutputStream((OutputStream)this.output);
    }

    static {
        Companion = new Companion(null);
        def$delegate = ThreadLocal.withInitial(Companion.def.2.INSTANCE);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0086\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/bio/OrderedDataOutput$Companion;", "", "()V", "def", "Ljava/util/zip/Deflater;", "kotlin.jvm.PlatformType", "getDef", "()Ljava/util/zip/Deflater;", "def$delegate", "Ljava/lang/ThreadLocal;", "invoke", "Lorg/jetbrains/bio/OrderedDataOutput;", "path", "Ljava/nio/file/Path;", "order", "Ljava/nio/ByteOrder;", "offset", "", "create", "", "big"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(Companion.class, "def", "getDef()Ljava/util/zip/Deflater;", 0))};
        }

        private final Deflater getDef() {
            return (Deflater)SupportKt.getValue(def$delegate, Companion, $$delegatedProperties[0]);
        }

        @NotNull
        public final OrderedDataOutput invoke(@NotNull Path path, @NotNull ByteOrder order, long offset, boolean create2) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)order, (String)"order");
            boolean bl = offset == 0L || !create2;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            FileChannel fc = create2 ? FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.READ, StandardOpenOption.WRITE) : FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE);
            OutputStream outputStream = Channels.newOutputStream(fc.position(offset));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"Channels.newOutputStream(fc.position(offset))");
            OutputStream outputStream2 = outputStream;
            int n = 8192;
            boolean bl5 = false;
            BufferedOutputStream output = outputStream2 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream2 : new BufferedOutputStream(outputStream2, n);
            return new OrderedDataOutput(output, offset, order);
        }

        public static /* synthetic */ OrderedDataOutput invoke$default(Companion companion, Path path, ByteOrder byteOrder, long l, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            if ((n & 4) != 0) {
                l = 0L;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.invoke(path, byteOrder, l, bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

