/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.iq80.snappy.Snappy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.BBRomBuffer;
import org.jetbrains.bio.CompressionType;
import org.jetbrains.bio.RomBuffer;
import org.jetbrains.bio.RomBuffer$WhenMappings;
import org.jetbrains.bio.SupportKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 >2\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0004J/\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020 H\u0004J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H&J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H&J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u0016H&J\b\u0010(\u001a\u00020 H&J\b\u0010)\u001a\u00020*H&J\b\u0010+\u001a\u00020,H&J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u001a\u001a\u00020\u0016H&J\b\u0010/\u001a\u00020\u0016H&J\u0010\u00100\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u0016H&J\b\u00102\u001a\u00020\u0004H&J\b\u00103\u001a\u000204H&J\u0006\u00105\u001a\u00020\u0016J\u0006\u00106\u001a\u00020\u0016JP\u00107\u001a\u0002H8\"\u0004\b\u0000\u001082\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\u0017\u00109\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H80:\u00a2\u0006\u0002\b;H\u0000\u00a2\u0006\u0004\b<\u0010=R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006?"}, d2={"Lorg/jetbrains/bio/RomBuffer;", "Ljava/io/Closeable;", "()V", "value", "", "limit", "getLimit", "()J", "setLimit", "(J)V", "maxLength", "getMaxLength", "order", "Ljava/nio/ByteOrder;", "getOrder", "()Ljava/nio/ByteOrder;", "position", "getPosition", "setPosition", "checkHeader", "", "leMagic", "", "checkLimit", "decompress", "offset", "size", "compression", "Lorg/jetbrains/bio/CompressionType;", "uncompressBufSize", "decompress$big", "doReadCString", "", "duplicate", "hasRemaining", "", "readByte", "", "readBytes", "", "readCString", "readDouble", "", "readFloat", "", "readFloats", "", "readInt", "readInts", "", "readLong", "readShort", "", "readUnsignedByte", "readUnsignedShort", "with", "T", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "with$big", "(JJLorg/jetbrains/bio/CompressionType;ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "big"})
public abstract class RomBuffer
implements Closeable {
    private long limit = -1L;
    private static final ThreadLocal inf$delegate;
    @NotNull
    public static final Companion Companion;

    public abstract long getPosition();

    public abstract void setPosition(long var1);

    @NotNull
    public abstract ByteOrder getOrder();

    public abstract long getMaxLength();

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long value) {
        boolean bl = value <= this.getMaxLength();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Limit " + value + " is greater than buffer length " + this.getMaxLength();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.limit = value == -1L ? this.getMaxLength() : value;
    }

    @NotNull
    public abstract RomBuffer duplicate(long var1, long var3);

    public final void checkHeader(int leMagic) {
        int magic = this.readInt();
        boolean bl = magic == leMagic;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            int bigMagic = Integer.reverseBytes(leMagic);
            String string = "Unexpected header magic: Actual " + magic + " doesn't match expected LE=" + leMagic + " (BE=" + bigMagic + ')';
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public abstract int[] readInts(int var1);

    @NotNull
    public abstract float[] readFloats(int var1);

    @NotNull
    public abstract byte[] readBytes(int var1);

    public abstract byte readByte();

    public final int readUnsignedByte() {
        return Byte.toUnsignedInt(this.readByte());
    }

    public abstract short readShort();

    public final int readUnsignedShort() {
        return Short.toUnsignedInt(this.readShort());
    }

    public abstract int readInt();

    public abstract long readLong();

    public abstract float readFloat();

    public abstract double readDouble();

    @NotNull
    public abstract String readCString();

    @NotNull
    protected final String doReadCString() {
        byte ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = this.readByte()) != (byte)0) {
            sb.append((char)ch);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public final boolean hasRemaining() {
        return this.getPosition() < this.getLimit();
    }

    protected final void checkLimit() {
        boolean bl = this.getPosition() <= this.getLimit();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Buffer overflow: pos " + this.getPosition() + " > limit " + this.getLimit() + ", max length: " + this.getMaxLength();
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T with$big(long offset, long size, @NotNull CompressionType compression, int uncompressBufSize, @NotNull Function1<? super RomBuffer, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Closeable closeable = this.decompress$big(offset, size, compression, uncompressBufSize);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            object = block.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)object;
    }

    public static /* synthetic */ Object with$big$default(RomBuffer romBuffer, long l, long l2, CompressionType compressionType, int n, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: with");
        }
        if ((n2 & 4) != 0) {
            compressionType = CompressionType.NO_COMPRESSION;
        }
        return romBuffer.with$big(l, l2, compressionType, n, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RomBuffer decompress$big(long offset, long size, @NotNull CompressionType compression, int uncompressBufSize) {
        RomBuffer romBuffer;
        Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
        if (compression.getAbsent()) {
            romBuffer = this.duplicate(offset, offset + size);
        } else {
            Closeable closeable = this.duplicate(offset, this.getLimit());
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Object it = (RomBuffer)closeable;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                RomBuffer $this$with = it;
                boolean bl6 = false;
                it = $this$with.readBytes(Ints.checkedCast((long)size));
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object compressedBuf = it;
            int uncompressedSize = 0;
            byte[] uncompressedBuf = null;
            switch (RomBuffer$WhenMappings.$EnumSwitchMapping$0[compression.ordinal()]) {
                case 1: {
                    int maxUncompressedChunk;
                    int sizeInt;
                    int n;
                    uncompressedSize = 0;
                    switch (uncompressBufSize) {
                        case 0: {
                            n = 2 * (int)size;
                            break;
                        }
                        default: {
                            n = uncompressBufSize;
                        }
                    }
                    uncompressedBuf = new byte[n];
                    Inflater inflater = RomBuffer.Companion.getInf();
                    inflater.reset();
                    inflater.setInput((byte[])compressedBuf);
                    int remaining = sizeInt = (int)size;
                    int n2 = maxUncompressedChunk = uncompressBufSize == 0 ? sizeInt : uncompressBufSize;
                    while (remaining > 0) {
                        Intrinsics.checkNotNullExpressionValue((Object)Bytes.ensureCapacity((byte[])uncompressedBuf, (int)(uncompressedSize + maxUncompressedChunk), (int)(maxUncompressedChunk / 2)), (String)"Bytes.ensureCapacity(\n  \u2026                        )");
                        if (inflater.finished()) {
                            inflater.reset();
                            inflater.setInput((byte[])compressedBuf, sizeInt - remaining, remaining);
                        }
                        int actual = inflater.inflate(uncompressedBuf, uncompressedSize, maxUncompressedChunk);
                        Inflater inflater2 = inflater;
                        Intrinsics.checkNotNullExpressionValue((Object)inflater2, (String)"inflater");
                        remaining = inflater2.getRemaining();
                        uncompressedSize += actual;
                    }
                    inflater.reset();
                    break;
                }
                case 2: {
                    uncompressedSize = Snappy.getUncompressedLength((byte[])compressedBuf, (int)0);
                    uncompressedBuf = new byte[uncompressedSize];
                    Snappy.uncompress((byte[])compressedBuf, (int)0, (int)((Object)compressedBuf).length, (byte[])uncompressedBuf, (int)0);
                    break;
                }
                case 3: {
                    throw (Throwable)new IllegalStateException("Unexpected compression: " + (Object)((Object)compression));
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ByteBuffer input = ByteBuffer.wrap(uncompressedBuf, 0, uncompressedSize);
            ByteBuffer byteBuffer = input.order(this.getOrder());
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"input.order(order)");
            romBuffer = new BBRomBuffer(byteBuffer);
        }
        return romBuffer;
    }

    public static /* synthetic */ RomBuffer decompress$big$default(RomBuffer romBuffer, long l, long l2, CompressionType compressionType, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decompress");
        }
        if ((n2 & 4) != 0) {
            compressionType = CompressionType.NO_COMPRESSION;
        }
        return romBuffer.decompress$big(l, l2, compressionType, n);
    }

    public RomBuffer() {
        boolean bl = this.getMaxLength() >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Buffer length is " + this.getMaxLength() + ", maybe associated stream failed to open.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    static {
        Companion = new Companion(null);
        inf$delegate = ThreadLocal.withInitial(Companion.inf.2.INSTANCE);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/bio/RomBuffer$Companion;", "", "()V", "inf", "Ljava/util/zip/Inflater;", "kotlin.jvm.PlatformType", "getInf", "()Ljava/util/zip/Inflater;", "inf$delegate", "Ljava/lang/ThreadLocal;", "big"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(Companion.class, "inf", "getInf()Ljava/util/zip/Inflater;", 0))};
        }

        private final Inflater getInf() {
            return (Inflater)SupportKt.getValue(inf$delegate, Companion, $$delegatedProperties[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

