/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.big;

import com.google.common.collect.ComparisonChain;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.big.BedEntry;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/bio/big/AggregationEvent;", "", "offset", "", "type", "item", "Lorg/jetbrains/bio/big/BedEntry;", "(IILorg/jetbrains/bio/big/BedEntry;)V", "getItem", "()Lorg/jetbrains/bio/big/BedEntry;", "getOffset", "()I", "getType", "compareTo", "other", "toString", "", "big"})
final class AggregationEvent
implements Comparable<AggregationEvent> {
    private final int offset;
    private final int type;
    @NotNull
    private final BedEntry item;

    @NotNull
    public String toString() {
        return (this.type == 0 ? "END" : "START") + '@' + this.offset;
    }

    @Override
    public int compareTo(@NotNull AggregationEvent other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ComparisonChain.start().compare(this.offset, other.offset).compare(this.type, other.type).result();
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getType() {
        return this.type;
    }

    @NotNull
    public final BedEntry getItem() {
        return this.item;
    }

    public AggregationEvent(int offset, int type, @NotNull BedEntry item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.offset = offset;
        this.type = type;
        this.item = item;
    }
}

